#ifndef _KEYBOARD_HPP
#define _KEYBOARD_HPP

#include "misc.hpp"

/*
 * Define POLL_KEYS to compile with the keyboard interrupt monitor, which
 * makes the program able to detect several keypresses at once.
 */

#define POLL_KEYS

typedef unsigned KeyCode;
class Keyboard;
extern Keyboard keyboard;

#ifdef POLL_KEYS

# define KEY_SCANCODES 128

typedef void interrupt (*ISR)(...);

class Key
	{
	friend Keyboard;

		BOOL	pressed;
		UINT	count;
		Key()	{ pressed = count = 0; }
		void press()
				{ if (!pressed) { pressed = 1; count++; } }
		void release()
				{ if (pressed) pressed = 0; }
	public:
		BOOL	isPressed()
				{ return pressed; }
		UINT	getCount()
				{ return count; }
		void	resetCount()
				{ count = 0; }
		UINT	tacCount()			// Test And Clear count
				{ UINT t=count; count=0; return t; }
	};

#endif

class Keyboard
	{
#ifdef POLL_KEYS
	friend void interrupt newInt09Handler(...);
		Key key[KEY_SCANCODES];
		void handler();
		static BOOL chainInt09;
#endif
		static int instances;
	public:
		Keyboard();
		~Keyboard();
		KeyCode flush();	// empty buffer, return last key
		KeyCode get();
#ifdef POLL_KEYS
		Key &operator[] (int n)
				{ return key[n]; }
		static BOOL getChainState()
			{ return chainInt09; }
		static void setChainState(BOOL s)
			{ chainInt09 = (s != 0); }
#endif
	};

#endif
