/*
 * Defines BOOL, UCHAR, ULONG, min(), max(), swap() and sort().
 * Declares various utility function.
 *
 * By Robert Schmidt <robert@alkymi.unit.no>.
 * This file is Copyright (C) of Ztiff Zox Softwear, 1993.
 *
 */

#ifndef _MISC_HPP
#define _MISC_HPP

#define FALSE	0
#define TRUE	1

typedef unsigned char	BOOL;
typedef unsigned char	UCHAR;
typedef unsigned int	UINT;
typedef unsigned long	ULONG;


// template functions to return the least of two values

template <class T>
inline T min(T a, T b)
	{
	return (a<b) ? a : b;
	}

// template functions to return the greatest of two values

template <class T>
inline T max(T a, T b)
	{
	return (a<b) ? b : a;
	}

// template functions to swap the values of two variables

template <class T>
inline void swap(T &a, T &b)
	{
	T t=a; a=b; b=t;
	}

// template functions to swap the values of two variables if the first
// is larger than the second

template <class T>
inline void sort(T &a, T &b)
	{
	if (b<a)
		swap(a,b);
	}

// template functions to clamp x within lower and upper bounds

template <class T>
inline void bound(T &x, T lower, T upper)
	{
	if (x<lower)
		x = lower;
	else
		if (x>upper)
			x = upper;
	}


// Now declare some standard versions of these template functions:

inline int min(int, int);
inline UINT min(UINT, UINT);
inline long min(long, long);
inline ULONG min(ULONG, ULONG);
inline int max(int, int);
inline UINT max(UINT, UINT);
inline long max(long, long);
inline ULONG max(ULONG, ULONG);
inline void bound(int &, int, int);
inline void bound(long &, long, long);

#endif
