#include <assert.h>
#include <mem.h>

#include "resource.hpp"

// These are specials for the scrolling arrow wall bitmap.  The variables
// start with "win" because I initially used the Windows 3.1 logo bitmap.

extern char *winLogoData; // pointer to real arrow bitmap
extern BitmapX *winBitmap;

// resTab is the global table of resources.  It will currently only hold
// bitmaps.

ResourceTable *resTab;

// Initialize a new Resource by allocating s bytes, and copying from d
// if (d!=0).

Resource::Resource(unsigned s, char *d)
	{
	assert(s);
	data = new char[s];
	assert(data);
	size = s;
	if (d)
		memcpy(data, d, s);
	}

// This BitmapX constructor converts an uncompressed IffBitMap to
// Zox3D's own bitmap storage format.

BitmapX::BitmapX(unsigned w, unsigned h, IffBitMap &b, unsigned t)
	: Resource(w*h), width(w), height(h), type(t), bound1(0), bound2(0)
	{
	const char *source = (const char *)b.body.getData();
	unsigned srcWidth = b.getWidth();
	char *tmp = data;
	int firstSpecial = 1;
	for (int x=0; x<width; ++x)
		{
		int special = 0;	// set if transparent or mirror color occured

		for (int y=0; y<height; ++y)
			{
			char color = source[y*srcWidth + x];
			*(tmp++) = color;
			if (color==0)	// color 0 means this row is special
				special = 1;
			}
		if (special)
			{
			// update the upper and lower bounds for special rows
			bound2 = long(x+1)*0x10000L/width - 1;	// upper bound
			if (firstSpecial)
				{
				bound1 = long(x)*0x10000L/width;	// lower bound
				firstSpecial = 0;
				}
			}
		}
	}

// This ResourceTable constructor reads in a text file of descriptions of
// resources and where to find them, allocating them and loading them
// in conventional memory as we go.
//
// NOTE: only resources of type BitmapX is supported at the moment.


ResourceTable::ResourceTable(istream &resDesc)
	{
	resDesc >> resources;			// get total number of resources
	res = new Resource*[resources];	// allocate the table itself
	assert(res);
	for (int r = 0; r<resources; ++r)
		{
		unsigned w, h, type;
		char fname[63];
		resDesc >> w >> h >> type >> fname;	// get the resource dimensions
											//  and file name
		IffBitMap b(fname);					// assume its a LBM and read it
		int ok = b.uncompress();			// try to uncompress it.
		assert(ok != 0);
		res[r] = new BitmapX(w, h, b, type);// convert LBM to our format
		assert(res[r]);

		// This is special for the demo.  It prepares bitmap number 7
		// for scrolling, by duplicating it, so that we can scroll it
		// simply by moving a pointer through the double bitmap.

		if (r == 7)		// Arrow bitmap - prepare fancy wall scroll
			{
			winBitmap = (BitmapX *)res[r];
			char *nd = new char[winBitmap->getSize() * 2];
			unsigned s = winBitmap->getSize();
			assert(nd);
			memcpy(nd, winBitmap->getData(), s);
			memcpy(nd + s, winBitmap->getData(), s);
			delete[] winBitmap->getData();
			winLogoData = winBitmap->getData() = nd;
			}
		}
	}

ResourceTable::~ResourceTable()
	{
	for (int r = 0; r<resources; ++r)
		delete res[r];
	// restore the arrow bitmap pointer to the correct value
	winBitmap->getData() = winLogoData;
	delete[] res;
	}
