#ifndef _WSLICE_HPP
#define _WSLICE_HPP

#include "fixed.h"
#include "resource.hpp"
#include "zox3d.hpp"

extern Fixed *tFactorX, *tFactorY, *tRatio;


class WallSlice
	{
	public:
		static int hitherBottom, hitherTop;
		static void resetHither()
			{ hitherBottom = windowHeight-1; hitherTop = 0; }

		BitmapNo bno;
		BitmapX &bmap;
		unsigned pixel;
		int top, bottom;
		Fixed wElev, fTop, fBottom;

		WallSlice(BitmapNo n, unsigned p);
		int isSpecial()
			{ return bmap.isSpecialAt(pixel); }
		int isBitmapped()
			{ return bno != NO_BITMAP; }

		void calcPos(Fixed depthRatio);

		void drawOpaque();		// draws to with vgaBuf/tempBuf
		void drawTransparent(); // draws to tempBuf
		void drawColor(char);	// draws to tempBuf
		void drawFrom(char *);	// copies from memory buffer to vgaBuf
		void drawFloor();		// draw floor (and ceiling)
	};


#endif
