
------------------------------------------------------------
--        Name: Alden Dima
--      E-mail: dimaaa@seas.gwu.edu
--      School: The George Washington University
--              School of Engineering and Applied Science
--              Washington, D.C.
--       Class: CSci 298 - Independent Study
--     Project: Ada Curses Binding and Textual User Interface
--        File: adremame.adb "adatui-repaint_main_menu.adb"
--        Date: 12/24/95 
-- Description: One of many adatui subunit bodies, this file
--              implements a subprogram declared in the adatui
--              package.
--   Revisions: 5/31/96 - AAD - Rewrote Ada-Curses binding to
--              enhance portability and maintainability.  Made
--              necessary changes in AdaTUI/TUIDemo to
--              accomodate new binding.  Made minor changes
--              to correct a problem using access types with
--              unconstrained arrays discovered by GNAT 3.03.
--              Eliminated several unused variables.
------------------------------------------------------------

separate (AdaTUI)
procedure repaint_main_menu ( width : integer; a_menu : a_menu_t ) is
   x          : c.signed_int;
   void       : c.signed_int;
   temp_str   : bstrings.bounded_string;
   temp_str2  : bstrings.bounded_string;
   temp_charv : aliased c.charv(1..80);
   temp_charp : c.charp;
   index      : natural;

begin
--
-- Modified loop to handle changes in menu type - AAD - 5/31/96
--
   index := 0;
   while a_menu.all(index).item_name /= NULL loop
      x := c.signed_int ( index * width );
      temp_str  := pad_string ( a_menu.all(index).item_name.all, width - 1 );
      temp_str2 := prepad_string ( bstrings.to_string ( temp_str ), 1 );
      make_charv (
	 source => temp_str2,
	 target => temp_charv);
   --
   -- using unchecked access because type c.charp is defined at a higher
   -- level than temp_charv - creates a potential for dangling pointers
   --
      temp_charp := temp_charv'unchecked_access;

      void  := pdcurses.mvwaddstr ( main_window, 0, x, temp_charp );
      index := index + 1;
   end loop;

   void := pdcurses.touchwin (main_window);
   void := pdcurses.wrefresh (main_window);
end repaint_main_menu;

