
------------------------------------------------------------
--        Name: Alden Dima
--      E-mail: dimaaa@seas.gwu.edu
--      School: The George Washington University
--              School of Engineering and Applied Science
--              Washington, D.C.
--       Class: CSci 298 - Independent Study
--     Project: Ada Curses Binding and Textual User Interface
--        File: adwiedst.adb "adatui-win_edit_string.adb"
--        Date: 12/24/95 
-- Description: One of many adatui subunit bodies, this file
--              implements a subprogram declared in the adatui
--              package.
--   Revisions: 5/31/96 - AAD - Rewrote Ada-Curses binding to
--              enhance portability and maintainability.  Made
--              necessary changes in AdaTUI/TUIDemo to
--              accomodate new binding.  Made minor changes
--              to correct a problem using access types with
--              unconstrained arrays discovered by GNAT 3.03.
--              Eliminated several unused variables.
------------------------------------------------------------

separate (AdaTUI)
procedure win_edit_string (
   window   :        pdcurses.A_WINDOW_T;
   buffer   : in out bstrings.bounded_string;
   field    : in     integer;
   key      :    out integer )
is
   original  : bstrings.bounded_string;
   buffer_index  : integer;
   temp_index    : integer;
   chars_deleted : integer;
   BUFFER_START  : constant integer := 1;
   defdisp   : boolean := TRUE;
   stop      : boolean := FALSE;
   insert    : boolean := FALSE;
   current_y : c.signed_int;
   current_x : c.signed_int;
   begin_y   : c.signed_int;
   begin_x   : c.signed_int;
   old_attr  : pdcurses.attr_t;
   temp_int  : c.signed_int;
   wedit     : pdcurses.A_WINDOW_T;
   void      : c.signed_int;
--
-- local subprograms to increase readability of code
--
   function in_buffer ( index : integer ) return boolean is
   begin
      return index > BUFFER_START;
   end in_buffer;

   function after_blank ( index : integer ) return boolean is
      temp : character;
   begin
      if in_buffer(index) then
	 temp := bstrings.element (
	    source => buffer,
	    index  => index - 1 );         

	 return temp = ' ';
      else
	 return FALSE;
      end if;
   end after_blank;

   function is_printable ( item : character ) return boolean
      renames ada.characters.handling.is_graphic; 

   procedure buffer_insert (
      source   : in out bstrings.bounded_string;
      before   : in     positive;
      new_item : in     character )
   is
      temp : string(1..1);
   begin
      temp(1) := new_item;
      bstrings.insert (
	 source   => source,
	 before   => before,
	 new_item => temp );
   end buffer_insert;

   pragma inline ( in_buffer     );
   pragma inline ( after_blank   );
   pragma inline ( buffer_insert );

begin
--
-- set buffer_index to point to first element in buffer
--
   buffer_index := BUFFER_START; 
--
-- exit function if errors exist with string lengths
--
   if field >= bstrings.Max_Length or bstrings.length(buffer) > field - 1 then 
      key := pdcurses.ERR;
      return;
   end if;
--
-- save original contents of buffer
--
   original := buffer;

   void := pdcurses.wrefresh(window);
   pdcurses.getyx ( window, current_y, current_x );
   pdcurses.getbegyx ( window, begin_y, begin_x );
   temp_int := c.signed_int ( field );
   wedit := pdcurses.subwin (
      window, 1, temp_int, begin_y + current_y, begin_x + current_x );

   old_attr := pdcurses.wgetattr ( wedit );
   color_box ( wedit, EDITBOXCOLOR, FALSE ); 
   normal_cursor;

   while not stop loop
      repaint_edit_box ( wedit, buffer_index, bstrings.to_string(buffer) );

      key := wait_for_key;

      case key is
      --
      -- restore original buffer contents
      -- 
	 when KEY_ESC =>
            buffer := original; 
            stop := TRUE;
      
	 when NEWLINE | pdcurses.KEY_UP | pdcurses.KEY_DOWN =>
	    stop := TRUE;

	 when pdcurses.KEY_LEFT =>
	    if buffer_index > BUFFER_START then
	       buffer_index := buffer_index - 1;
	    end if;

	 when pdcurses.KEY_RIGHT =>
	    defdisp := FALSE;
	    if buffer_index < bstrings.length(buffer) then
	       buffer_index := buffer_index + 1;
	    end if;
      -- 
      -- toggle insert mode
      -- KEY_IC  = enter insert character mode
      -- KEY_EIC = exit  insert character mode
      --
	 when pdcurses.KEY_IC | pdcurses.KEY_EIC =>
	    defdisp := FALSE;
	    insert := not insert;

            if insert then
               insert_cursor;
            else
               normal_cursor;
            end if;
      --
      -- c == erasechar()
      -- backspace, ^H
      --
	 when pdcurses.ECHAR =>
	    if buffer_index > BUFFER_START then
	       bstrings.delete (
		  source  => buffer,
		  from    => buffer_index - 1,
		  through => buffer_index - 1 );

	       buffer_index := buffer_index - 1;
	    end if;
      --
      -- c == killchar()
      -- delete input line, ^U
      --
	 when pdcurses.DLCHAR =>
	    buffer_index := BUFFER_START;
	    bstrings.delete (
	       source  => buffer,
	       from    => BUFFER_START,
	       through => bstrings.length ( buffer ) );
      --
      -- c == wordchar()
      -- delete word in input, ^W
      --
	 when pdcurses.DWCHAR =>
	    temp_index := buffer_index;
	    chars_deleted := 0;
	 --
	 -- starting from the current cursor position move backwards,
	 -- marking the previous character for deletion until the 
	 -- previous character is preceded by a non-blank.
	 --
	    while in_buffer(buffer_index) and after_blank(buffer_index) loop
	       buffer_index  := buffer_index - 1;
	       chars_deleted := chars_deleted + 1;
	    end loop;
	 --
	 -- starting from the current cursor position move backwards,
	 -- marking the previous character for deletion until the 
	 -- previous character is preceded by a blank.
	 --
	    while in_buffer(buffer_index) and not after_blank(buffer_index) loop
	       buffer_index := buffer_index - 1;
	       chars_deleted := chars_deleted + 1;
	    end loop;
	 --
	 -- perform the actual deletions
	 --
	    bstrings.delete (
	       source  => buffer,
	       from    => buffer_index,
	       through => buffer_index + chars_deleted );

	 when others =>
	    if is_printable ( character'val(key) ) then 
	       if defdisp then
		  buffer_index := BUFFER_START;
		  bstrings.delete (
		     source  => buffer,
		     from    => BUFFER_START,
		     through => bstrings.length(buffer) );

		  defdisp := FALSE;
	       end if;
	    --
	    -- insert a character before current cursor position
	    -- by moving it and following characters ahead one position
	    -- and then setting the current buffer element to the new 
	    -- character.
	    --
	       if insert and bstrings.length(buffer) < field - 1 then
		  buffer_insert (
		     source   => buffer, 
		     before   => buffer_index,
		     new_item => character'val (key) );

		  buffer_index := buffer_index + 1;

	       elsif bstrings.length(buffer) < field - 1 then
		  bstrings.delete (
		     source  => buffer,
		     from    => buffer_index,
		     through => bstrings.length ( buffer ) );

		  buffer_insert (
		     source   => buffer, 
		     before   => buffer_index,
		     new_item => character'val (key) );

		  buffer_index := buffer_index + 1;
	       end if;
	    end if;
      end case;
   end loop;

   void := pdcurses.wattrset ( wedit, old_attr );
   repaint_edit_box (
      a_window  => wedit,
      x         => buffer_index,
      buffer    => bstrings.to_string ( buffer ) );

   void := pdcurses.delwin ( wedit );
   return;
end win_edit_string;
