WITH Ada.Calendar;
PACKAGE Dates IS
------------------------------------------------------------------
--| Specification for package to represent calendar dates
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: November 1995                                     
------------------------------------------------------------------

  TYPE Months IS
    (Jan, Feb, Mar, Apr, May, Jun, Jul, Aug, Sep, Oct, Nov, Dec);

  SUBTYPE Year_Number  IS Ada.Calendar.Year_Number;
  SUBTYPE Day_Number   IS Ada.Calendar.Day_Number;

  TYPE Date IS PRIVATE;
  Date_Error : EXCEPTION;

  -- constructors

  FUNCTION Today RETURN Date;
  -- Pre:  None
  -- Post: Returns today's date; analogous to Ada.Calendar.Clock

  FUNCTION Date_Of(Year  : Year_Number;
                   Month : Months;
                   Day   : Day_Number) RETURN Date;
  -- Pre:    Year, Month, and Day are defined
  -- Post:   Returns a Date value
  -- Raises: Date_Error if the year, month, day triple do not
  --   form a valid date (Feb. 30, for example)
  -- Analogous to Ada.Calendar.Time_Of

  -- selectors

  FUNCTION Year (D: Date) RETURN Year_Number;
  FUNCTION Month(D: Date) RETURN Months;
  FUNCTION Day  (D: Date) RETURN Day_Number;
  -- Pre:  D is defined
  -- Post: Return the year, month, or day component, respectively

PRIVATE

  TYPE Date IS RECORD
    Month: Months := Months'First;
    Day:   Day_Number := Day_Number'First;
    Year:  Year_Number := Year_Number'First;
  END RECORD;

END Dates;
