WITH Ada.Text_IO;
WITH Ada.Integer_Text_IO;
PROCEDURE Test_Multiply IS
------------------------------------------------------------------
--| Demonstration of recursive Multiply function
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: July 1995                                     
------------------------------------------------------------------


  FirstInt  : Integer;  -- inputs
  SecondInt : Positive;
  Answer    : Integer;  -- output

  FUNCTION Multiply (M : IN Integer; N : IN Positive) 
    RETURN Integer IS
  -- Performs multiplication recursively using the + operator
  -- Pre : M and N are defined 
  -- Post: returns M * N           

    Result: Integer;
    
  BEGIN  -- Multiply   

    Ada.Text_IO.Put(Item => "Multiply called with parameters");
    Ada.Integer_Text_IO.Put(Item => M, Width => 2);
    Ada.Integer_Text_IO.Put(Item => N, Width => 3);
    Ada.Text_IO.New_Line;
    
    IF N = 1 THEN
      Result := M;                     -- stopping case   
    ELSE
      Result := M + Multiply(M, N-1);  -- recursion   
    END  IF;

    Ada.Text_IO.Put(Item => "Returning from Multiply with result ");
    Ada.Integer_Text_IO.Put(Item => Result, Width => 1);
    Ada.Text_IO.New_Line;

    RETURN Result;

  END Multiply;

BEGIN -- Test_Multiply

  Ada.Text_IO.Put(Item => "Please enter a integer > ");
  Ada.Integer_Text_IO.Get(Item => FirstInt);
  Ada.Text_IO.Put(Item => "Please enter a positive integer > ");
  Ada.Integer_Text_IO.Get(Item => SecondInt);

  Answer := Multiply(M => FirstInt, N => SecondInt);

  Ada.Text_IO.Put(Item => "The product of the two integers is ");
  Ada.Integer_Text_IO.Put(Item => Answer, Width => 1);
  Ada.Text_IO.New_Line;

END Test_Multiply;
