WITH Binary_Search_Generic;
WITH Debugging_Support;
PACKAGE BODY Tables_Generic IS
------------------------------------------------------------------
--| Body of the abstract data type for a table of
--| element records, each element containing a key.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: October 1995                                     
------------------------------------------------------------------

  PROCEDURE Locate IS 
    NEW Binary_Search_Generic(
	  ElementType => Element,
          KeyType => KeyType,
          KeyOf => KeyOf,
          "<" => "<",
	  IndexType => TableIndex,
	  ListType  => TableData);
  
  PROCEDURE InitializeTable (Table : IN OUT TableType) IS
  BEGIN -- stub
    Debugging_Support.Enter (Subprogram => "InitializeTable",
      Message => "Under Construction");
    Debugging_Support.Leave (Subprogram => "InitializeTable");
  END InitializeTable;
      
  FUNCTION SizeOfTable(Table: TableType) RETURN Natural IS
  BEGIN -- stub
    Debugging_Support.Enter (Subprogram => "SizeOfTable",
      Message => "Under Construction");
    Debugging_Support.Leave (Subprogram => "SizeOfTable");
    RETURN 0; 
  END SizeOfTable; 
      
  PROCEDURE Search (Table   : TableType; 
                    Target  : KeyType; 
                    Success : OUT Boolean) IS
  BEGIN -- stub
    Debugging_Support.Enter (Subprogram => "Search",
      Message => "Under Construction");
    Debugging_Support.Leave (Subprogram => "Search");
  END Search;
      
  PROCEDURE Insert (Table   : IN OUT TableType; 
                    Item    : Element;
                    Success : OUT Boolean) IS
  BEGIN -- stub
    Debugging_Support.Enter (Subprogram => "Insert",
      Message => "Under Construction");
    Debugging_Support.Leave (Subprogram => "Insert");
  END Insert;
      
  PROCEDURE Delete (Table   : IN OUT TableType; 
                    Target  : KeyType;
                    Success : OUT Boolean) IS
  BEGIN -- stub
    Debugging_Support.Enter (Subprogram => "Delete",
      Message => "Under Construction");
    Debugging_Support.Leave (Subprogram => "Delete");
  END Delete;
 
  PROCEDURE Replace  (Table   : IN OUT TableType;
                      Item    : Element;
                      Success : OUT Boolean) IS
  BEGIN -- stub
    Debugging_Support.Enter (Subprogram => "Replace",
      Message => "Under Construction");
    Debugging_Support.Leave (Subprogram => "Replace");
  END Replace; 
      
  PROCEDURE Retrieve (Table   : TableType;
                      Target  : KeyType;
                      Item    : OUT Element;
                      Success : OUT Boolean) IS
  BEGIN -- stub
    Debugging_Support.Enter (Subprogram => "Retrieve",
      Message => "Under Construction");
    Debugging_Support.Leave (Subprogram => "Retrieve");
  END Retrieve;
      
  PROCEDURE Traverse (Table : TableType) IS
  BEGIN -- stub
    Debugging_Support.Enter (Subprogram => "Traverse",
      Message => "Under Construction");
    Debugging_Support.Leave (Subprogram => "Traverse");
  END Traverse;
   
END Tables_Generic;
