WITH Ada.Text_IO;
WITH Ada.Float_Text_IO;
PROCEDURE Test_Max_Value IS
------------------------------------------------------------------
--| illustrates use of unconstrained array types
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: September 1995                                     
------------------------------------------------------------------

  TYPE  ListType IS ARRAY(Integer RANGE <>) of Float;

  L1 : ListType(1..5);     -- 5 elements
  L2 : ListType(-4..3);    -- 8 elements

  -- local procedure to display the contents of a list

  PROCEDURE DisplayList(L: ListType) IS
  -- Pre: L is defined
  -- Post: display all values in the list

  BEGIN -- DisplayList

    FOR Count IN L'Range LOOP
      Ada.Float_Text_IO.Put(Item=>L(Count), Fore=>3, Aft=>1, Exp=>0);
    END LOOP;
    Ada.Text_IO.New_Line;

  END DisplayList;


  FUNCTION MaxValue(L: ListType) RETURN Float IS
  -- Pre: L is defined
  -- Post: returns the largest value stored in L

    CurrentMax : Float;

  BEGIN -- MaxValue

    CurrentMax := Float'First;     -- minimum value of Float

    FOR WhichElement IN L'Range LOOP
      IF L(WhichElement) > CurrentMax THEN
        CurrentMax := L(WhichElement);
      END IF;
    END LOOP;
    -- assert: CurrentMax contains the largest value in L

    RETURN CurrentMax;

  END MaxValue;


BEGIN -- Test_Max_Value

  L1 := (0.0, -5.7, 2.3, 5.9, 1.6);
  L2 := (3.1, -2.4, 0.0, -5.7, 8.0, 2.3, 5.9, 1.6);

  Ada.Text_IO.Put(Item=> "Testing MaxValue for float lists");
  Ada.Text_IO.New_Line;
  Ada.Text_IO.New_Line;
  Ada.Text_IO.Put(Item=> "Here is the list L1");
  Ada.Text_IO.New_Line;
  DisplayList(L => L1);
  
  Ada.Text_IO.Put(Item=> "The maximum value in this list is ");
  Ada.Float_Text_IO.Put(Item => MaxValue(L=>L1), 
                Fore=>1, Aft=>2, Exp=>0);
  Ada.Text_IO.New_Line;
  Ada.Text_IO.New_Line;

  Ada.Text_IO.Put(Item=> "Here is the list L2");
  Ada.Text_IO.New_Line;
  DisplayList(L => L2);
  
  Ada.Text_IO.Put(Item=> "The maximum value in this list is ");
  Ada.Float_Text_IO.Put(Item => MaxValue(L=>L2), 
                Fore=>1, Aft=>2, Exp=>0);
  Ada.Text_IO.New_Line;

END Test_Max_Value;
