WITH Ada.Text_IO;
WITH VStrings;
WITH VStrings.IO;
PROCEDURE Test_VStrings IS
------------------------------------------------------------------
--| program copies its input file test.dat into its output file test.out
--| then closes test.out, re-opens it for input,  
--| and displays its contents on the screen.
--| Author: Michael B. Feldman, The George Washington University 
--| Last Modified: September 1995                                     
------------------------------------------------------------------

  MaxLineLength: CONSTANT Positive := 255;
  
  InData  : Ada.Text_IO.File_Type;
  OutData : Ada.Text_IO.File_Type;
  S       : VStrings.VString(MaxLength => MaxLineLength);

BEGIN -- Test_VStrings

  Ada.Text_IO.Open
    (File=>InData, Mode=>Ada.Text_IO.In_File, Name=>"test.dat");
  Ada.Text_IO.Create
    (File=>OutData, Mode=>Ada.Text_IO.Out_File, Name=>"test.out");

  WHILE NOT Ada.Text_IO.End_of_File(File => InData) LOOP

    VStrings.IO.Get_Line(File => InData, 
      Item => S, MaxLength => MaxLineLength);
    VStrings.IO.Put(File => OutData, Item => S);
    Ada.Text_IO.New_Line(File => OutData);

  END LOOP;

  Ada.Text_IO.Close(File => InData);
  Ada.Text_IO.Close(File => OutData);
  Ada.Text_IO.Open(File=>InData, Mode=>Ada.Text_IO.In_File, Name=>"test.out");


  WHILE NOT Ada.Text_IO.End_of_File(File => InData) LOOP

    VStrings.IO.Get_Line(File => InData, 
      Item => S, MaxLength => MaxLineLength);
    VStrings.IO.Put(Item => S);
    Ada.Text_IO.New_Line;

  END LOOP;

  Ada.Text_IO.Close(File => InData);

EXCEPTION

  WHEN Ada.Text_IO.Name_Error =>
    Ada.Text_IO.Put
      (Item => "File test.dat doesn't exist in this directory!");
    Ada.Text_IO.New_Line;

END Test_VStrings;
