{$A+,B-,D+,E+,F-,I-,L+,N+,O-,R-,S-,V-}
{$M 16384,0,655360}
program LZH_Test;
uses
  LZH;
type
  IObuf = array[0..10*1024-1] of byte;
var
  infile,outfile: file;
  ibuf,obuf: IObuf;
  s: String;

  procedure Error (msg: String);
  begin
    writeln(msg);
    HALT(1)
  end;

{$F+}
  procedure ReadNextBlock;
{$F-}
  begin
    inptr:= 0;
    BlockRead(infile,inbuf^,sizeof(ibuf),inend);
    if IoResult>0 then Error('! Error reading input file');
  end;

{$F+}
  procedure WriteNextBlock;
{$F-}
  var
    wr: word;
  begin
    BlockWrite(outfile,outbuf^,outptr,wr);
    if (IoResult>0) or (wr<outptr) then
      Error('! Error writing output file');
    outptr:= 0
  end;

  procedure OpenInput (fn: String);
  begin
    assign(infile,fn); reset(infile,1);
    if IoResult>0 then Error('! Can''t open input file');
    inbuf:= @ibuf;
    ReadToBuffer:= ReadNextBlock;
    ReadToBuffer;
  end;

  procedure OpenOutput (fn: String);
  begin
    assign(outfile,fn); rewrite(outfile,1);
    if IoResult>0 then Error('! Can''t open output file');
    outbuf:= @obuf;
    outend:= sizeof(obuf);
    outptr:= 0;
    WriteFromBuffer:= WriteNextBlock;
  end;

begin {main}
   if ParamCount<>3 then begin
     writeln('Usage: lzhuf e(compression)|d(uncompression) infile outfile');
     HALT(1)
   end;
   OpenInput(ParamStr(2));
   OpenOutput(ParamStr(3));
   s:= ParamStr(1);
   case s[1] of
     'e','E': Encode(filesize(infile));
     'd','D': Decode
   else
     Error('! Use [D] for Decompression or [E] for Compression')
   end;
   close(infile); if IoResult>0 then Error('! Error closing input file');
   if outptr>0 then WriteNextBlock;
   close(outfile); if IoResult>0 then Error('! Error closing output file');
end.
