.COMMENT
 ****************************************************************************
 DEBUG.INC      Pass32 SYSTEM File
                this file implements the internal 16 bit debugger
                (c) 1996,1998 by Dieter Pawelczak - Pass32 Version 2.0
 ============================================================================
 DEBUG.INC - SYSTEM FILE USED BY THE PASS32 ASSEMBLER
 Attention - don't alter this file !

; You can use an individual debug file with the .DEBUGFILE directive
; With the .DEBUG option the procedure DEBUGPROC is called before
; each instruction.

 ****************************************************************************
.DATA

 debugregs         db  'EAX: 00000000 EBX: 00000000 ECX: 00000000 EDX: 00000000 EDI: 00000000           ';
 debugregs2        db  'ESI: 00000000 CS: 0000 DS: 0000 ES: 0000 FS: 0000 GS: 0000 F:0000 SP: 0000 ';
 debuginfo         db  '             : line :      :                                                         ',0;
 debughex          db  '0123456789ABCDEF'
 regeax            dd  ?
 regebx            dd  ?
 regecx            dd  ?
 regedx            dd  ?
 regedi            dd  ?
 regesi            dd  ?
 reges             dw  ?
 regds             dw  ?
 debuginfoOffset   dw  ?
 debugflags        dw  ?
 debugoffset       dw  ?
 debugcheckkey     db  0
 debuglineinfo0    db  '     0:                 ',0
.CODE
.NODEBUG
DEBUGPROC PROC
   push ds
   push ax
   mov ax,cs
   mov ds,ax
   pop ax
   mov regedi,edi
   mov regesi,esi
   mov regeax,eax
   mov regebx,ebx
   mov regecx,ecx
   mov regedx,edx
   mov ax,es
   mov reges,ax
   pop ax
   mov regds,ax
   pop bx
   pop ax
   mov debuginfooffset,ax
   push ax
   mov debugoffset,bx
   push bx
   pushf
   pop ax
   mov debugflags,ax
   push ax
   mov ax,0b800h           ; Video
   mov es,ax
   mov di,offset debugregs
   mov si,3520
   mov ecx,240
debugprintloop:
   mov al,[di]
   mov ah,1eh
   mov es:[si],ax
   inc di
   add si,2
   loop debugprintloop
   mov eax,regeax
   mov si,3530
   call debughexout
   mov eax,regebx
   add si,14
   call debughexout
   mov eax,regecx
   add si,14
   call debughexout
   mov eax,regedx
   add si,14
   call debughexout
   mov eax,regedi
   add si,14
   call debughexout
   mov si,3690
   mov eax,regesi
   call debughexout
   add si,12
   mov ax,cs
   call debughexout4
   add si,12
   mov ax,regds
   call debughexout4
   add si,12
   mov ax,reges
   call debughexout4
   add si,12
   mov ax,fs
   call debughexout4
   add si,12
   mov ax,gs
   call debughexout4
   mov ax,debugflags
   add si,8
   call debughexout4
   add si,12
   mov eax,esp
   call debughexout4
   mov si,3840
   mov ax,debugoffset
   call debughexout4             ; display current IP
   mov si,3852
   mov di,debuginfooffset
debugprintloop2:
   mov al,[di]
   cmp al,0
   je debugprintloopende
   mov es:[si],al
   inc di
   add si,2
   cmp si,4000
   jne debugprintloop2
debugprintloopende:
   mov di,debugoffset
   mov al,[di]
   cmp debugcheckkey,2
   je short debugnextjmp
   cmp al,0c2h        ; RET / RETF INSTRUCTION
   je short debugkey
   cmp al,0c3h
   je short debugkey
   cmp al,0cbh
   je short debugkey
   cmp al,0cah
   je short debugkey
   cmp debugcheckkey,1
   je short debugnokey
debugnextjmp:
   cmp al,0e8h        ; CALL / JMP INSTRUCTION
   je short debugkey
   cmp al,0ffh
   je short debugkey
   cmp al,0ebh
   je short debugkey
   cmp al,0e9h
   je short debugkey
   cmp debugcheckkey,0
   jne short debugnokey
debugkey:
   mov debugcheckkey,0
   mov ah,7                     ; Wait for a keystroke
   int 21h
   cmp al,3                     ; [CRTL]+[C]
   je short debugabort
   cmp al,27                    ; [ESC]  RUN UNTIL RET/RETF INSTRUCTION
   jne short  debugnoesc
   mov debugcheckkey,1
debugnoesc:
   cmp al,13                    ; [RETURN] RUN UNTIL NEXT CALL/JMP
   jne short debugnoret               ;          INSTRUCTION
   mov debugcheckkey,2
debugnoret:
debugnokey:
   mov ax,reges
   mov es,ax
   mov edi,regedi
   mov esi,regesi
   mov eax,regeax
   mov ebx,regebx
   mov ecx,regecx
   mov edx,regedx
   mov edi,regedi
   mov esi,regesi
   push ax
   mov ax,regds
   mov ds,ax
   pop ax
   popf
   ret 2        ;
debugabort:
   mov ah,4ch
   int 21h
   ret
ENDP DEBUGPROC
DEBUGHEXOUT PROC
   mov ebx,eax
   mov cl,28
DEBUGHEXOUTLOOP:
   mov eax,ebx
   shr eax,cl
   and eax,0fh
   mov edi,offset DEBUGHEX
   add edi,eax
   mov al,[edi]
   mov es:[si],al
   add si,2
   sub cl,4
   cmp cl,0
   jne DEBUGHEXOUTLOOP
   mov eax,ebx
   and eax,0fh
   mov edi,offset DEBUGHEX
   add edi,eax
   mov al,[di]
   mov es:[si],al
   ret
ENDP DEBUGHEXOUT
DEBUGHEXOUT4 PROC
   mov bx,ax
   mov cl,12
DEBUGHEXOUTLOOP4:
   mov ax,bx
   shr ax,cl
   and eax,0fh
   mov edi,offset DEBUGHEX
   add edi,eax
   mov al,[di]
   mov es:[si],al
   add si,2
   sub cl,4
   cmp cl,0
   jne DEBUGHEXOUTLOOP4
   mov ax,bx
   and eax,0fh
   mov edi,offset DEBUGHEX
   add edi,eax
   mov al,[di]
   mov es:[si],al
   ret
ENDP DEBUGHEXOUT4

.IFPM
  .OUT DEBUG is not for PMode ...
  .OUT Make sure you installed Pass32 correctly!
.ENDIF
END


