/***************************************************
   N-Body Globular Cluster GRAPHICS FUNCTIONS
   This File (C) Copyright 1998 Graeme Fenwick
***************************************************/

#define  alleg_mouse_unused                       /* save space with Allegro */
#define  alleg_joystick_unused
#define  alleg_sound_unused
#define  alleg_gui_unused

#include <allegro.h>
#include "gl_gfx.h"

/********** INITIALIZE SCREEN routines and the display */

void initialize_screen(void)
{
   allegro_init();                                 /* initialize allegro gfx */
   set_gfx_mode(GFX_VGA, 320, 200, 0, 0);        /* standard(?) VGA mode 13h */
}

/********** PUT BODIES onto the screen in perspective */

void put_bodies(double **pos, int n, int dist, double spsize, int points,
   int unplot)
{
   double   sz, scale;                                     /* sz is screen z */
   int      sradius, body, bodycol, sx, sy;

   for (body = 0; body < n; ++body) {
      sz = 99 * pos[body][2] + dist;                 /* distance from viewer */
      scale = 1.0 / (sz / 99);                     /* determines perspective */
      sx = scale * pos[body][0] * 99 + 159;
      sy = scale * pos[body][1] * 99 + 99;
      bodycol = (unplot) ? 0 : (body % 255 + 1); 
      if (sz > 2)                    /* bodies closer than 2 are "behind" us */
         if (points)                                        /* point sources */
            putpixel(screen, sx, sy, bodycol);
         else {                                            /* scaled spheres */
            sradius = spsize * scale; 
            circlefill(screen, sx, sy, sradius, bodycol);
         }
   }
}


/********** Onscreen energy/time STATUS display */

void status(double e, int bad, double passed)
{
   text_mode(-1);                        /* transparent character background */
   if (bad)
      textout(screen, font, "Bad energy error", 0, 0, 3);     /* set message */
   else
      textout(screen, font, "                ", 0, 0, 0);   /* clear message */

   text_mode(0);                                         /* black_background */
   textprintf(screen, font, 0, 192, 4, "ENERGY: %+5.3f  ", e);
                              /* end spaces *almost* certainly clear old val */
   textprintf(screen, font, 176, 192, 5, "TIME: %+3.4f  ", passed);
}



