@echo off
REM  This batch file can be used to convert an AutoCad ADI file to HP7221
REM  format and send the resulting file to the HP7221 plotter.
REM
REM  Usage: PLOT7221 fname [SEND7221 options]
REM
REM  fname is the name (excluding the extension) of the file to be converted
REM  and plotted.  It is assumed that the input file's extension is .PLT.
REM  The file created by adi7221 will have the extension .HPP.
REM
REM  SEND7221 options, if included, are passed along to the SEND7221 command.
REM
REM  Note:  It is critical that fname come before any SEND7221 options.

IF %1. == . GOTO USAGE
ADI7221 %1.PLT %1.HPP
IF ERRORLEVEL 1 GOTO ADIERROR
SEND7221 %1.HPP %2 %3 %4 %5 %6 %7 %8 %9
IF ERRORLEVEL 1 GOTO SENDERROR
GOTO END

:USAGE
   ECHO Usage: PLOT7221 fname [SEND7221 options]
   GOTO END

:ADIERROR
   ECHO ADI7221 failed.  If necessary, recreate the .PLT file and try again.
   GOTO END

:SENDERROR
   ECHO SEND7221 failed.  Check the plotter and try again.
   GOTO END

:END
