;***********************************************************************
;* Funcion: aNorma
;* Comentarios: se usa para definir un area en torno a la cual
;* la norma tiene validez. Para usar este comando hay que definir
;* previamente la opcion de hatch. Esto es escoger el patron,
;* escala y color.
;***********************************************************************
;
; Change Log
; 
; 18/11/94 C.Perigault 
;
;
(defun c:aNorma ( / listaNormas listaTensiones listaDistancias
		    listaAsociacionDistancias radio norma tension distancia
		    osmode cmdecho gridmode angulo p1 p2 distancia conjunto
		    n i pi pi/2 entidad ucs wcs)

(setq ucs 1)
(setq wcs 0)
  ;**********************************************************************
  ;* Funcion : (printMenu lista)
  ;* Comentarios : Esta funcion se utiliza para imprimir menus de seleccion
  ;* en la pantalla de texto del acad para que el usuario seleccione
  ;* una alternativa. La lista debe ser de la forma  (clave descripcion)
  ;* donde la clave es un numero u otro objeto y descripcion un texto
  ;* (generalmente)
  ;************************************************************************
  (defun printMenu (lista / listaTemp numeroDeFilas numero opcion)
    (textscr)
    (setq listaTemp lista)
    (while listaTemp
      (setq numeroDeFilas 0)
      ; mientras tengamos elementos en la listaTemp o el numero de filas
      ; sea menor que 20 imprimimos el menu en la pantalla
      (while (and (< numeroDeFilas 20) listaTemp)
	(princ "\n[")
	(setq numero (car (car listaTemp)))
	(if (< numero 10) (princ " "))
	(princ numero)
	(princ "] ")
	(princ (cadr (car listaTemp)))
	(setq numeroDeFilas (+ numeroDeFilas 1))
l	(setq listaTemp (cdr listaTemp)))
      (princ "\n")
      (princ "\nIngrese el numero de su opcion o [enter] para continuar: ")
      (setq opcion (getint ))
      (if (assoc opcion lista) (setq listaTemp nil)))
    (graphscr)
    opcion)
  ; En esta es la lista de las principales normas
  (setq listaNormas '((1 "ANSI")
		     (2 "IEEE")
		     (3 "CEI NORMAL")
		     (4 "CEI REDUCIDA")
		     (5 "VDE REDUCIDA")
		     (6 "ENDESA")))
  ; Estos son los niveles de tension normalizados
  (setq listaTensiones '((1 "60-69 KV")
		       (2 "110 KV")
		       (3 "132 KV")
		       (4 "154 KV")
		       (5 "220 KV")
		       (6 "354 KV")
		       (7 "500 KV")))
  ; Estas son las distancias que necesitan ser normalizadas
  (setq listaDistancias
   '((1  "Distancia de conductores fijos : fase-tierra")
     (2  "Distancia de conductores fijos : fase-fase")
     (3  "Distancia de conductores moviles : fase-tierra")
     (4  "Distancia de conductores moviles : fase-fase")
     (5  "Distancia de conductores moviles : distinto circuito fase-fase")
     (6  "Distancia de partes vivas a gabildos de transporte")
     (7  "Distancia horizontal de partes vivas al cierro exterior")
     (8  "Altura al suelo de partes vivas (para peatones)")
     (9  "Altura de conductor al suelo para labores de trans. regiones urbanas con alto nivel de transito" )
     (10 "Altura de conductor al suelo para labores de transporte regiones suburbanas")
     (11 "Altura de conductor al suleo para labores de transporte regiones rurales")
   ))
  ; Esta es la lista que asocia la norma tension y distancia con el
  ; radio del validez de la norma
  ; la lista es de la forma ( (norma tension distancia) radio)
   (setq listaAsociacionDistancias
	;**ENDESA 60-69 KV**
     '( ((6 1 1) 0.800)
	((6 1 2) 1.150)
	((6 1 3) 1.000)
	((6 1 4) 1.750)
	((6 1 5) 2.000)
	((6 1 6) 1.300)
	((6 1 7) 2.000)
	((6 1 8) 3.300)
	((6 1 9) 8.500)
	((6 1 10) nil)
	((6 1 11) nil)
	;**ENDESA 110 KV **
	((6 2 1) 1.250)
	((6 2 2) 1.800)
	((6 2 3) 1.600)
	((6 2 4) 2.100)
	((6 2 5) nil)
	((6 2 6) 1.750)
	((6 2 7) 2.450)
	((6 2 8) 3.700)
	((6 2 9) 9.550)
	((6 2 10) nil)
	((6 2 11) nil)
	;**ENDESA 132 KV **
	((6 3 1) 1.100)
	((6 3 2) 1.500)
	((6 3 3) 2.000)
	((6 3 4) 2.300)
	((6 3 5) 2.700)
	((6 3 6) 1.600)
	((6 3 7) 2.800)
	((6 3 8) 3.600)
	((6 3 9) nil)
	((6 3 10) nil)
	((6 3 11) nil)
	;**ENDESA 154 KV **
	((6 4 1) 1.500)
	((6 4 2) 2.500)
	((6 4 3) 2.200)
	((6 4 4) 2.800)
	((6 4 5) nil)
	((6 4 6) 2.000)
	((6 4 7) 3.000)
	((6 4 8) 4.000)
	((6 4 9) 14.750)
	((6 4 10) nil)
	((6 4 11) nil)
	;**ENDESA 220 KV **
	((6 5 1) 2.100)
	((6 5 2) 2.400)
	((6 5 3) 3.000)
	((6 5 4) 3.300)
	((6 5 5) nil)
	((6 5 6) 2.600)
	((6 5 7) 2.900)
	((6 5 8) 5.250)
	((6 5 9) 16.500)
	((6 5 10) nil)
	((6 5 11) nil)
	;**ENDESA 345 KV **
	((6 6 1) nil)
	((6 6 2) nil)
	((6 6 3) nil)
	((6 6 4) nil)
	((6 6 5) nil)
	((6 6 6) nil)
	((6 6 7) nil)
	((6 6 8) nil)
	((6 6 9) nil)
	((6 6 10) nil)
	((6 6 11) nil)
	;**ENDESA 500 KV **
	((6 7 1) 3.700)
	((6 7 2) 4.700)
	((6 7 3) 5.000)
	((6 7 4) 6.000)
	((6 7 5) nil)
	((6 7 6) 4.200)
	((6 7 7) 4.500)
	((6 7 8) 6.500)
	((6 7 9) nil)
	((6 7 10) nil)
	((6 7 11) nil)))



  ; Imprimimos los menus y obtenemos la seleccion del usuario
  (setq radio (getreal "\nIngrese radio o [enter] para normas : "))
  ; si el usuario no ingresa la distancia se le presentan las
  ; normas como alternativas
  (if (not radio)
    (progn
      ; Imprimimos los menus para que el usuario haga la seleccion
      ; adecuada
      (setq norma     (printMenu listaNormas))
      (setq tension   (printMenu listaTensiones))
      (setq distancia (printMenu listaDistancias))
      (setq clave (list norma tension distancia))
       (if (not (cdr (assoc clave listaAsociacionDistancias)))
	 ; si la clave no se encuentra le avisamos del erro
	 ; al usurio
	 (progn
	   (princ "\nLa opcion : ")
	   (princ clave)
	   (princ " no se encuentra ")
	   (setq radio nil) )
	 ; de encontrase la clave le presentamos la informacion de
	 ; esta al usuario
	 (progn
	   (princ "\n\n\nNorma : " )
	   (princ (cadr (assoc norma listaNormas)))
	   (princ "   Tension: ")
	   (princ (cadr (assoc tension listaTensiones)))
	   (princ "  Distancia :")
	   (princ  (cadr (assoc clave listaAsociacionDistancias)))
	   (princ " [m]\n")
	   (princ (cadr (assoc distancia listaDistancias)))
	   (setq radio (cadr (assoc clave listaAsociacionDistancias)))))))
  ; guardamos el estado del sistema al entrar al comando
  (if radio
    (progn
      (setq osmode   (getvar "OSMODE"  ))
      (setq cmdecho  (getvar "CMDECHO" ))
      (setq gridmode (getvar "GRIDMODE"))
      (setvar "GRIDMODE" 0)
      (setvar "CMDECHO"  0)
      (setvar "OSMODE"   0)
      (setq pi 3.14159265359)
      (setq pi/2 (/ pi 2.0))
      (princ "\nSeleccione lineas: ")
      (setq conjunto (ssget))
      (setq n (sslength conjunto))
      (setq i 0)
      ; es aqui donde empezmoas a dibujar las areas
      ; solo se pueden dibujar areas para lineas y polinineas
     (while (< i n)
       (setq entidad (entget (ssname conjunto i)))
       ; Transformamos los punto del wcs al ucs
       ; para evitar complicaciones por las vistas
       (setq p1 (trans (cdr (assoc 10 entidad)) wcs ucs))
       (setq p2 (trans (cdr (assoc 11 entidad)) wcs ucs))
       ; solo si enxisten p1 y p2 graficamos el area
      (if (and p1 p2)
	(progn
	  (setq distancia (distance p1 p2))
	  (setq angulo    (angle    p1 p2))
	  (command  "PLINE"  p1 (polar p1 (+ angulo pi/2 ) radio)
		   "ARC" "CE" p1 (polar p1 (+ angulo pi) radio)
		   "LINE"   p1 "")
	  (command "hatch" "" "" "" (entlast) "" )
	  (command  "PLINE"  p1 (polar p1 (+ angulo pi ) radio)
		  "ARC" "CE" p1 (polar p1 (- angulo pi/2) radio)
		  "LINE"   p1 "")
	  (command "hatch" "" "" "" (entlast) "" )
	  (command  "PLINE"  p2 (polar p2 angulo radio)
		  "ARC" "CE" p2 (polar p2 (+ angulo pi/2) radio)
		  "LINE"   p2 "")
	  (command "hatch" "" "" "" (entlast) "" )
	  (command  "PLINE"  p2 (polar p2 (- angulo pi/2) radio)
		  "ARC" "CE" p2 (polar p2 angulo  radio)
		  "LINE"   p2 "")
	  (command "hatch" "" "" "" (entlast) "" )
	  (command  "PLINE"  p1 p2 (polar p2 (+ angulo pi/2) radio)
				 (polar p1 (+ angulo pi/2) radio)
			     p1 "")
	  (command "hatch" "" "" "" (entlast) "" )
	  (command  "PLINE"  p1 p2 (polar p2 (- angulo pi/2) radio)
			     (polar p1 (- angulo pi/2) radio)
			     p1 "")
	  (command "hatch" "" "" "" (entlast) "")
	  (setq i (+ i 1)))))
      ; volvemos al sistema a su estado inicial
      (setvar "GRIDMODE" gridmode)
      (setvar "OSMODE"   osmode  )
      (setvar "CMDECHO"  cmdecho ))))