;***********************************************************************
;* Comando : Mbloques
;* Se usa para generar la lista de bloques que existen en el dibujo
;* actual y que el usuario pueda buscar e insertar facilmente el bloque
;* en que desea de acuerdo al prefijo.
;* Lee la tabla de definicion de bloques y extrae todos los nombres de
;* bloques que empiecen con prefijo
;************************************************************************

; Change log
;
; 8/11/94  C.Perigault  Agrege el sinonimo maneja-bloques
;
; 
;
(defun c:maneja-bloques () (c:Mbloques))
(defun c:Mbloques ( / ListaEquipos EquipoNumero continuar bloque
		      NombreBloque numero prefijo opcion)


  ;**********************************************************************
  ;* Funcion : (printMenu lista)
  ;* Comentarios : Esta funcion se utiliza para imprimir menus de seleccion
  ;* en la pantalla de texto del acad para que el usuario seleccione
  ;* una alternativa. La lista debe ser de la forma  (clave descripcion)
  ;* donde la clave es un numero u otro objeto y descripcion un texto
  ;* (generalmente)
  ;************************************************************************
  (defun printMenu (lista / listaTemp numeroDeFilas numero opcion)
    (textscr)
    (setq opcion nil)
    (setq listaTemp lista)
    (while listaTemp
      (setq numeroDeFilas 0)
      ; mientras tengamos elementos en la listaTemp o el numero de filas
      ; sea menor que 20 imprimimos el menu en la pantalla
      (while (and (< numeroDeFilas 20) listaTemp)
	(princ "\n[")
	(setq numero (car (car listaTemp)))
	(if (< numero 10) (princ " "))
	(princ numero)
	(princ "] ")
	(princ (cadr (car listaTemp)))
	(setq numeroDeFilas (+ numeroDeFilas 1))
	(setq listaTemp (cdr listaTemp)))
      (princ "\n")
      (princ "\nIngrese el numero de su opcion o [enter] para continuar: ")
      (setq opcion (getint ))
      (if (assoc opcion lista)
       (setq listaTemp nil)))
    (graphscr)
    opcion)
    ;******************************************************************
  (graphscr)
  (setq prefijo (strcase (getstring "\nPrefijo o <enter> para todos : ") nil))

  (textscr)
  ; Inicializacion de variables
  (setq ListaEquipos nil)
  (setq EquipoNumero  1)
  (setq continuar    t  )
  ; Buscamos el primer bloque de la tabla de Bloques
  (setq bloque (tblnext "BLOCK" t))
  ; buscamos en todos los bloques definidos, los que pertenezcan
  ; a la serie prefijo
  (while bloque
    (setq NombreBloque (cdr (assoc 2 bloque)))
    (setq bloque (tblnext "BLOCK"))
    ; Son las primeras letras del nombre del bloque prefijo
      (if (or  (zerop (strlen prefijo))
	       (equal (strcase (substr NombreBloque 1
			    (strlen prefijo ) )nil) prefijo))
    ; Si es asi agregamos a la lista de equipos el nombre del bloque
      (progn
	(setq ListaEquipos (append ListaEquipos (list (list  EquipoNumero NombreBloque))))
	(setq  EquipoNumero (+ EquipoNumero 1)))))
    ; si existe el equipo lo insertamos
    (setq opcion (printMenu listaEquipos))
    (graphscr)
    (if opcion
      (progn
	(setvar "TEXTEVAL" 1)
	(command "INSERT" (cadr (assoc opcion ListaEquipos))  pause)
	(setq continuar nil)
	(setvar "TEXTEVAL" 0))))