'
' COMTYPE.BAS
'
' Reports the UART type for COM1 thru COM4
'
' *** IMPORTANT: Boot to DOS before running under Windows! ***
'

$ERROR ALL ON
$LIB ALL OFF

DEFINT A-Z

$INCLUDE "PCL4PB.BI"
$LINK "PCL4PB.OBJ"

%True = 0
%False = NOT %True

' Global Variables

DIM RxBuf(128+16) AS BYTE
DIM TxBuf(128+16) AS BYTE

DIM BaudCode AS INTEGER
DIM BaudRate AS SINGLE
DIM Port AS SHARED INTEGER
DIM C AS BYTE
DIM I AS INTEGER
DIM Code AS INTEGER
DIM RxBufSeg AS INTEGER
DIM TxBufSeg AS INTEGER
DIM UartString(4) AS STRING

' initialize

BaudCode = %Baud19200
BaudRate = 19200

UartString(0) = "8250/16450"
UartString(1) = "16550"
UartString(2) = "16650"
UartString(3) = "16750"

IF LEN(COMMAND$) > 0 THEN
   PRINT "Usage: COMTYPE"
   STOP
END IF

' compute RX buffer segment
RxBufSeg = 1 + VARSEG(RxBuf(0)) + (VARPTR(RxBuf(0)) \ 16)
IF SioInfo(ASC("I")) <> 0 THEN
  ' compute RX buffer segment
  TxBufSeg = 1 + VARSEG(TxBuf(0)) + (VARPTR(TxBuf(0)) \ 16)
ELSE
  TxBufSeg = 0
END IF

'search each port in turn
FOR Port = %COM1 TO %COM4
  ' setup receive buffer
  Code = SioRxBuf(Port, RxBufSeg, %Size128)
  IF TxBufSeg <> 0 THEN
     'setup transmit buffer
     Code = SioTxBuf(Port, TxBufSeg, %Size128)
  END IF

  ' reset port
  Code = SioReset(Port, BaudCode)
  IF Port = %COM1 THEN
     CLS
  END IF
  ' report
  PRINT "COM";LTRIM$(STR$(1+Port));": ";
  IF Code >= 0 THEN
     'found UART
     Code = SioFIFO(Port,%LEVEL.4TH)
     PRINT UartString(Code)
     Code = SioDone(Port)
  ELSE
     Code = SioError(Code)
     PRINT
  END IF

NEXT Port
END

 