/* HeadEdit XBBS message area reader -- Nodelist functions, header
   editor, miscellaneous functions */

/* Note this stuff needs to stay together as there is some really sloppy
   sharing of windows and such (bleagh!) */

#include "msgg.h"
#include "twindow.h"
#include "keys.h"
#include "headedit.h"

extern WINDOW *ewnd;


static char attrprompts[16][12]={
		"Private:",
		"Crash:",
		"Read:",
		"Sent:",
		"File:",
		"Forward:",
		"Orphan:",
		"Kill:",
		"Local:",
		"XX1:",
		"XX2:",
		"FReq:",
		"RReq:",
		"Receipt:",
		"Audit Rq:",
		"Update Rq:"
	};
static char mattrprompts[][12]={
		"Deleted:",
		"Anonymous:",
		"Echo:",
		"Net:",
		"Hold:",
		"Host Rt:",
		"Scanned:",
		"Keep:",
		"Treated:",
		"Packed:"
};


void pascal node_lister (void) {

	static char zone[7]="";
	static char net[7]="";
	char lines;
	struct nodeidx nid;
	int returncode;
	FIELD *fld;

	if(!nidxsize || !nidx) {
		any_message(" No nodelist available. ");
		pause();
		return;
	}
	wnd6=establish_window(4,maxy-7,5,31);
	set_border(wnd6,3);
	set_title(wnd6," Nodelist Scanner ");
	set_colors(wnd6,BORDER,7,0,0);
	display_window(wnd6);
	wcursor(wnd6,0,0);
	wprintf(wnd6," F10 to list or ESC to abort");
	if (!*zone || !(word)atol(zone)) {
		sprintf(zone,"%u",curaddress.zone);
		sprintf(net,"%u",curaddress.net);
	}
	init_template(wnd6);
	wprompt(wnd6,1,1,"Zone:");
	wprompt(wnd6,1,2,"Net:");
	fld=establish_field(wnd6,7,1,msk5,zone,'N');
	field_window(fld,"zone      ",40,6);
	fld=establish_field(wnd6,7,2,msk5,net,'N');
	field_window(fld,"net       ",40,5);
	prep_template(wnd6);
NodeOver:
	returncode=data_entry(wnd6);
	if (returncode==ESC){
		 delete_window(wnd6);
		 return;
	}
	if (returncode!=F10) goto NodeOver;
	if (atol(zone)<1 || atol(zone)>65535L || atol(net)>65535L) {
		error_message(" Invalid value(s)...zone=1-65535, net=0-65535 ");
		pause();
		goto NodeOver;
	}
	nid.zone=(word)atol(zone);
	nid.net=(word)atol(net);
	delete_window(wnd6);
	nid.node=0;
	nid.type=255;
	wnd4=establish_window(0,0,maxy,maxx);
	set_border(wnd4,1);
	set_title(wnd4," NodeList ");
	display_window(wnd4);
	wcursor(wnd4,0,0);
	any_message(" Searching ");
	if (!nid.net) {
		if (nodelist(&nid,3)==-1) goto BreakOut;
		clear_message();
		nid.type=3;
		lines=2;
		while(nodelist(&nid,4)>(-1)) {
			lines+=2;
			if (lines>=(maxy-3)) {
				any_message("More? (Y-n)");
				lines=toupper(generic_mouse_input(ewnd));
				clear_message();
				if (lines=='S' || lines=='N' || lines==ESC) goto BreakOut;
				lines=0;
			}
		}
		any_message(" Complete ");
		pause();
		goto BreakOut;
	}
	clear_message();
	if (nodelist(&nid,1)==-1) goto BreakOut;
	nid.type=0;
	lines=2;
	while(nodelist(&nid,2)>(-1)) {
		lines+=2;
		if (lines>=(maxy-3)) {
			any_message("More? (Y-n)");
			lines=toupper(generic_mouse_input(ewnd));
			clear_message();
			if (lines=='S' || lines=='N' || lines==ESC) goto BreakOut;
			lines=0;
		}
	}
	any_message(" Complete ");
	generic_mouse_input(ewnd);
BreakOut:
	clear_message();
	delete_window(wnd4);
}



int pascal nodelist (struct nodeidx *nii,char type) {

 struct nodeinfo nif;
 char temp[91];
 int handle;
 long x;
 static long cidx=0;
 WINDOW *fake;
 char len;

 if(!nidxsize || !nidx) {
	any_message(" No nodelist available. ");
	return (-1);
 }
 if (nii->zone==0) {
	nii->zone=curaddress.zone;
 }

 nif.zone=nii->zone;
 nif.net=nii->net;
 nif.node=nii->node;
 nif.type=nii->type;

 if (type==2 || type==4) {
	x=cidx;
	if (type==2) goto GotwhatIwant;
 }
 else x=cidx=0;
 if (type==3 || type==4) {
	 if (type==4) {
		x++;
		cidx=x;
	 }
	 for (;x<(nidxsize+1);x++) {
		if (nidx[x].zone==nif.zone && nidx[x].node==0) break;
	 }
	 cidx=x;
	 goto GotwhatIwant;
 }
 for (;x<(nidxsize+1);x++) {
	if (nidx[x].zone==nif.zone && nidx[x].net==nif.net && nidx[x].node==nif.node) break;
 }
 cidx=x;

GotwhatIwant:

 if (x>nidxsize) {
	 if (!type) {
		wnd6=establish_window(3,maxy-5,4,maxx-6);
		set_border(wnd6,3);
		set_title(wnd6," Node Info ");
		set_colors(wnd6,BORDER,7,0,0);
		display_window(wnd6);
		wcursor(wnd6,1,1);
		wprintf(wnd6,"\t\t\t\tRequested Node not found. ");
	 }
	 return (-1);
 }
 if (type==2 || type==4) {
	if (type==2) {
		x++;
		cidx=x;
	}
	if (x>nidxsize) return (-1);
	if (type==2 && (nidx[x].zone!=nif.zone || nidx[x].net!=nif.net)) return (-1);
	if (type==4 && (nidx[x].zone!=nif.zone || nidx[x].node!=0)) return (-1);
 }
 sprintf(temp,"%sQNL_DAT.BBS",nodepath);
 if ((handle=_open(temp,O_RDONLY | O_BINARY | O_DENYNONE))==-1) {
   error_message(" Can't open QNL_DAT.BBS ");
   pause();
   return(-1);
 }
 lseek(handle,x*(long)sizeof(struct nodeinfo),SEEK_SET);
 if (_read(handle,&nif,sizeof(struct nodeinfo))<1) {
	_close(handle);
	goto ReadError;
 }
 _close(handle);
 len=*nif.name;
 memmove(nif.name,&nif.name[1],len);
 nif.name[len]=0;
 len=*nif.city;
 memmove(nif.city,&nif.city[1],len);
 nif.city[len]=0;
 len=*nif.phone;
 memmove(nif.phone,&nif.phone[1],len);
 nif.phone[len]=0;
 len=*nif.password;
 memmove(nif.password,&nif.password[1],len);
 nif.password[len]=0;
 if (!type) {
	wnd6=establish_window(3,maxy-5,5,maxx-6);
	set_border(wnd6,3);
	set_title(wnd6," Node Info ");
	set_colors(wnd6,BORDER,7,0,0);
	wcursor(wnd6,1,1);
	fake=wnd6;
	display_window(fake);
 }
 else fake=wnd4;
 wprintf(fake,"\n");
 wprintfraw(fake,"Type:%hd * %u:%u/%u (%s, %s)\n",nif.type,nif.zone,nif.net,nif.node,nif.name,nif.city);
 wprintfraw(fake,"%s * %s * %u baud * %d cost * ",nif.phone,nif.password,nif.baud,nif.cost);
 if (nif.flags & B_hub) wprintf(fake,"Hub  ");
 if (nif.flags & B_host) wprintf(fake,"Host  ");
 if (nif.flags & B_region) wprintf(fake,"RC  ");
 if (nif.flags & B_zone) wprintf(fake,"ZC  ");
 if (nif.flags & B_CM) wprintf(fake,"CM");
 return(nif.cost);

ReadError:
	error_message(" Error reading record ");
	pause();
	return (-1);
}




int dest_check (char *bf,int key) {

   struct nodeidx nid;

   if (!autocheck && *bf) return 0;
   if ((currarea->attr & NET)==0 && (currarea->attr & ALTERNATE)==0) return 0;
   nid.node=(word)atol(dest);
   nid.net=(word)atol(dest_net);
   nid.zone=(word)atol(d_zone);
   clear_message();
   nid.type=255;
   sprintf(cost,"%-5d",nodelist(&nid,0));
   if (*cost=='-') strcpy(cost,"0    ");
   pause();
   delete_window(wnd6);
   if(wnd1)normal_video(wnd1);
   if(wnd1)field_tally(wnd1);
   if(wnd1)reverse_video(wnd1);
   return 0;
}



int orig_check (char *bf,int key) {

   struct nodeidx nid;

   if (!autocheck) return 0;
   if ((currarea->attr & NET)==0 && (currarea->attr & ALTERNATE)==0) return 0;
   nid.node=(word)atol(orig);
   nid.net=(word)atol(orig_net);
   nid.zone=(word)atol(o_zone);
   clear_message();
   nid.type=255;
   nodelist(&nid,0);
   pause();
   delete_window(wnd6);
   return 0;
}



void find_sysop (char *bf) {

	int  fp;
	char s[128];
	char *p;
	char first[36];
	char last[36];
	char searchname[39];
	char changed=0;
	int  x;
	int  y;
	long pos=0;

	strcpy(first,bf);
	rstrip(first);
	lstrip(first);
	if (!strlen(first)) return;
	strtok(first," ");
	p=strtok(0," ");
	if (p==NULL) *last=0;
	else strcpy(last,p);
	lstrip(last);
	if (*last) sprintf(searchname,"%s, %s",last,first);
	else strcpy(searchname,first);
	pos=0;

	if (isalpha(*searchname)) {
		sprintf(s,"%sFidoUser.IDX",nodepath);
		if ((fp=_open(s,O_RDONLY | O_BINARY | O_DENYNONE))!=-1) {
			lseek(fp,(long)((toupper(*searchname)-'A')*sizeof(long)),SEEK_SET);
			_read(fp,&pos,sizeof(long));
			_close(fp);
		}
	}
	sprintf(s,"%sFidoUser.LST",nodepath);
	if ((fp=_open(s,O_RDONLY | O_TEXT | O_DENYNONE))==-1) {
		any_message(" No FidoUser.Lst available ");
		pause();
		return;
	}
	setmode(fp,O_TEXT);
	lseek(fp,pos,SEEK_SET);
	any_message(" Searching... ");
	while (!eof(fp)) {
		pos=tell(fp);
		if (!fgetsx(s,128,fp)) break;
		s[39]=0;
		rstrip(s);
		lstrip(s);
		if (!stricmp(s,searchname)) {
			lseek(fp,pos,SEEK_SET);
			fgetsx(s,128,fp);
			p=&s[41];
			s[40]=0;
			rstrip(s);
			p=lstrip(p);
			if (strchr(p,':')) {
				sprintf(d_zone,"%-5u",(word)atol(strtok(p,":")));
				p=strtok(0,"/");
			}
			else {
				sprintf(d_zone,"%-5u",curaddress.zone);
				p=strtok(p,"/");
			}
			if (p!=NULL) sprintf(dest_net,"%-5u",(word)atol(p));
			p=strtok(0,"\n");
			if (p!=NULL) sprintf(dest,"%-5u",(word)atol(p));
			strcpy(d_point,"0    ");
			changed=1;
			break;
		}
		if (*s>*searchname) break;
	}
	_close(fp);
	if (changed) {
		if(wnd1) {
			curr_cursor(&x,&y);
			normal_video(wnd1);
			field_tally(wnd1);
			reverse_video(wnd1);
			dest_check("",0);
			cursor(x,y);
		}
		else dest_check("",0);
	}
	else any_message(" Unsuccessful search ");
	nopause();
}



int pascal edit_mess (char type) {  /* Message header editor */

    int exitcode;
    char inattr=0;
    char from[36];
	char to[36];
	char subj[64];
	char date[20];
	char times[11];
	char attr[16][2];
	char mattr[16][2];
	word register x;
	struct nodeidx nid;
	FIELD *fld;
	FIELD *fld2;
	WINDOW *wnd2;

ReStart:

	if (type==0) if (messno==0) {
		if (nomess==0) return ESC;
		messno=1;
	}

	wnd1=establish_window(maxx-79,maxy-24,24,79);
	set_border(wnd1,2);
	set_title(wnd1," Message Header Editor ");
	set_colors(wnd1,BORDER,7,0,0);
	display_window(wnd1);

NextMess:
	if (type<2) get_mess(0);
SkipGet:
	sprintf(from,"%s",msg.from);
	sprintf(to,"%s",msg.to);
	sprintf(subj,"%s",msg.subj);
	sprintf(date,"%s",msg.date);
	sprintf(times,"%u",msg.times);
	sprintf(dest,"%u",msg.dest);
	sprintf(orig,"%u",msg.orig);
	sprintf(cost,"%d",msg.cost);
	sprintf(orig_net,"%u",msg.orig_net);
	sprintf(dest_net,"%u",msg.dest_net);
	sprintf(d_zone,"%u",msg.d_zone);
	sprintf(o_zone,"%u",msg.o_zone);
	sprintf(o_point,"%u",msg.o_point);
	sprintf(d_point,"%u",msg.d_point);

OverMess:
	clear_window(wnd1);
	wcursor(wnd1,0,21);
	if (!type) {
		wprintf(wnd1," Message #%u of %u--PageUp/Dn to move  %s\n",messno,nomess,area_attr());
		wprintf(wnd1," F1=help, F2=DOS, F6=nodes, F7=attrs, F8=areas, F9=msgs, F10=save, ESC=exit");
		wcursor(wnd1,1,17);
		wprintf(wnd1,"Message text: %u bytes",msg.length-1);
	}
	else {
		wprintf(wnd1," Prepare new message header  %s\n",area_attr());
		wprintf(wnd1," F1=help, F2=DOS, F6=nodes, F7=attrs, F10=save, ESC=exit");
	}
	if (msg.attr & MSGPRIVATE) {
		wcursor(wnd1,1,0);
		wprintf(wnd1,"Private.");
	}
	if (msg.m_attr & MSGANON) {
		wcursor(wnd1,22,0);
		wprintf(wnd1,"Anon.");
	}
	if (msg.m_attr & MSGNET) {
		wcursor(wnd1,1,18);
		wprintf(wnd1,"Netmail.");
	}
	if (msg.attr & MSGFRQ) {
		wcursor(wnd1,52,17);
		wprintf(wnd1,"FReq.");
	}
	if (msg.attr & MSGFILE) {
		wcursor(wnd1,52,17);
		wprintf(wnd1,"Attach.");
	}
	if (msg.attr & MSGURQ) {
		wcursor(wnd1,52,17);
		wprintf(wnd1,"UReq.");
	}
	if (msg.m_attr & MSGECHO) {
		wcursor(wnd1,1,18);
		wprintf(wnd1,"Echomail.");
	}
	if (msg.m_attr & MSGDELETED) {
		wcursor(wnd1,1,18);
		wprintf(wnd1,"Del.");
	}
	if (msg.attr & MSGLOCAL) {
		wcursor(wnd1,20,18);
		wprintf(wnd1,"Local.");
	}
	if (msg.m_attr & MSGKEEP) {
		wcursor(wnd1,52,1);
		wprintf(wnd1,"Keep.");
	}
	wcursor(wnd1,1,19);
	wprintf(wnd1,quick_attr());
	init_template(wnd1);
	wprompt(wnd1,2,2,"From:");
	wprompt(wnd1,2,3,"To:");
	wprompt(wnd1,2,4,"Subj:");
	wprompt(wnd1,2,6,"Date:");
	wprompt(wnd1,2,7,"Times Read:");
	wprompt(wnd1,2,8,"Destination zone #:");
	wprompt(wnd1,2,9,"Destination net #:");
	wprompt(wnd1,2,10,"Destination node #:");
	wprompt(wnd1,2,11,"Destination point #:");
	wprompt(wnd1,2,12,"Origin zone #:");
	wprompt(wnd1,2,13,"Origin net #:");
	wprompt(wnd1,2,14,"Origin node #:");
	wprompt(wnd1,2,15,"Origin point #:");
	wprompt(wnd1,2,16,"Message cost:");
	if(type) {
		wprompt(wnd1,26,16,"Dest. domain:");
	}
	fld=establish_field(wnd1,26,2,msk35,from,'a');
	field_help(fld,myname);
	field_validate(fld,noblank);
	fld=establish_field(wnd1,26,3,msk35,to,'a');
	if ((currarea->attr & NET) || (currarea->attr & ALTERNATE)) field_help(fld,find_sysop);
	else field_window(fld,"to        ",40,12);
	field_validate(fld,noblank);
	fld=establish_field(wnd1,3,5,msk63,subj,'a');
	field_window(fld,"subj      ",40,13);
	field_validate(fld,noblank);
	fld=establish_field(wnd1,26,6,msk19,date,'a');
	field_help(fld,help_date);
	field_validate(fld,noblank);
	fld=establish_field(wnd1,26,7,msk10,times,'N');
	field_window(fld,"timesread ",40,14);
	fld=establish_field(wnd1,26,8,msk5,d_zone,'N');
	field_window(fld,"d_zone    ",40,1);
	fld=establish_field(wnd1,26,9,msk5,dest_net,'N');
	field_window(fld,"dest_net  ",40,2);
	fld=establish_field(wnd1,26,10,msk5,dest,'N');
	field_window(fld,"dest_node ",40,3);
	field_validate(fld,dest_check);
	fld=establish_field(wnd1,26,11,msk5,d_point,'N');
	field_window(fld,"d_point   ",40,3);
	fld=establish_field(wnd1,26,12,msk5,o_zone,'N');
	field_help(fld,myzone);
	fld=establish_field(wnd1,26,13,msk5,orig_net,'N');
	field_help(fld,mynet);
	fld=establish_field(wnd1,26,14,msk5,orig,'N');
	field_help(fld,mynode);
	field_validate(fld,orig_check);
	fld=establish_field(wnd1,26,15,msk5,o_point,'N');
	field_help(fld,mypoint);
	fld=establish_field(wnd1,18,16,msk5,cost,'N');
	field_window(fld,"cost      ",40,7);
	if(type) {
		fld=establish_field(wnd1,40,16,msk36,to_domain,'a');
		field_window(fld,"destdomain",40,7);
		field_help(fld,mydomain);
	}
	prep_template(wnd1);
SameMess:
    if(inattr) goto Attributes;
    exitcode=data_entry(wnd1);

AttrInterrupt:
	switch (exitcode) {
        case ALT_F1:
        case ALT_F2:
        case ALT_F3:
        case ALT_F4:
        case ALT_F5:
        case ALT_F6:
        case ALT_F7:
        case ALT_F8:
        case ALT_F9:
		case ALT_F10:   do_spawn(convertstring(fkey[exitcode-ALT_F1]));
						goto OverMess;
		case CTRL_HOME:
		case HOME:  if (type) break;
					messno=1;
					get_mess(0);
					goto NextMess;
		case CTRL_END:
		case END:   if (type) break;
					messno=nomess;
					get_mess(0);
					goto NextMess;
		case CTRL_PGDN:
		case PGDN:  if (type) break;
					messno++;
					if (messno>nomess) messno=1;
					get_mess(0);
					goto NextMess;
		case CTRL_PGUP:
		case PGUP:  if (type) break;
					if (messno==1) messno=nomess;
					else messno--;
					get_mess(0);
					goto NextMess;
		case F10:   strcpy(msg.from,rstrip(from));
					strcpy(msg.to,rstrip(to));
					strcpy(msg.subj,rstrip(subj));
					strcpy(msg.date,date);
					msg.times=(word)atol(times);
					msg.dest=(word)atol(dest);
					msg.orig=(word)atol(orig);
					msg.orig_net=(word)atol(orig_net);
					msg.dest_net=(word)atol(dest_net);
					msg.o_zone=(word)atol(o_zone);
					msg.d_zone=(word)atol(d_zone);
					msg.d_point=(word)atol(d_point);
					msg.o_point=(word)atol(o_point);
					msg.cost=atoi(cost);
					if (!type) put_mess();
					else {
						lstrip(to_domain);
						rstrip(to_domain);
						if(!*to_domain) strcpy(to_domain,curaddress.domain);
						delete_window(wnd1);
						wnd1=NULL;
						return (exitcode);
					}
					goto NextMess;
		case F9:    if (type) break;
					messno=select_mess();
					get_mess(0);
					goto NextMess;
		case F8:    if (type) break;
					areano=select_area();
					get_mess(0);
					goto NextMess;
		case F7:    goto Attributes;
		case F6:	if(!nidxsize) {
						any_message(" No nodelist available. ");
						pause();
						goto SameMess;
					}
					any_message(" [D]estination or [O]rigin node? [D] ");
					if (toupper(generic_mouse_input(ewnd))!='O') {
						nid.node=(word)atol(dest);
						nid.net=(word)atol(dest_net);
						nid.zone=(word)atol(d_zone);
					}
					else {
						nid.node=(word)atol(orig);
						nid.net=(word)atol(orig_net);
						nid.zone=(word)atol(o_zone);
					}
					nid.type=255;
					sprintf(cost,"%-5d",nodelist(&nid,0));
					if (*cost=='-') strcpy(cost,"0");
					generic_mouse_input(wnd6);
					delete_window(wnd6);
					clear_message();
					goto SameMess;
		case F4:	select_address();
					goto SameMess;
		case F3:    select_name();
					goto SameMess;
		case F2:    do_spawn("");
					goto OverMess;
		case ESC:   delete_window(wnd1);
					wnd1=NULL;
					return (exitcode);
	}
	bell();
	goto SameMess;

Attributes: /* Attribute editor */

	inattr=1;
	for (x=0;x<16;x++) {
		if (msg.attr & (1<<x)) attr[x][0]='X';
		else attr[x][0]='-';
		attr[x][1]=0;
	}
	for (x=0;x<10;x++) {
		if (msg.m_attr & (1<<x)) mattr[x][0]='X';
		else mattr[x][0]='-';
		mattr[x][1]=0;
	}
	wnd2=establish_window(maxx-40,maxy-21,21,40);
	set_border(wnd2,3);
	set_colors(wnd2,ALL,BLUE,WHITE,BRIGHT);
	set_colors(wnd2,BORDER,WHITE,BLUE,DIM);
	set_colors(wnd2,ACCENT,WHITE,BLACK,BRIGHT);
	set_colors(wnd2,TITLE,BLACK,CYAN,BRIGHT);
	set_title(wnd2," Message Attributes ");
	display_window(wnd2);
	init_template(wnd2);
	wcursor(wnd2,0,18);
	if (!type) wprintf(wnd2," Msg#%u/%u %s\n",messno,nomess,area_attr());
	wprintf(wnd2," [X][-] ESC F7=keep ");
	if(!type) wprintf(wnd2,"F5=qsv F10=save");
	wcursor(wnd2,0,0);
	reverse_video(wnd2);
	wprintf(wnd2," Standard ");
	wcursor(wnd2,21,0);
	wprintf(wnd2," Extra ");
	normal_video(wnd2);
	for (x=0;x<16;x++) {
		wprompt(wnd2,2,x+1,attrprompts[x]);
	}
	for (x=0;x<10;x++) {
		wprompt(wnd2,23,x+1,mattrprompts[x]);
	}
	for (x=0;x<16;x++) {
		fld2=establish_field(wnd2,13,x+1,msk1,attr[x],'O');
		field_window(fld2,"fidoattr  ",1,1);
	}
	for (x=0;x<10;x++) {
		fld2=establish_field(wnd2,34,x+1,msk1,mattr[x],'O');
		field_window(fld2,"xbbsattr  ",1,1);
		if(x==9) {
			if(stricmp(name,"Wayne Michaels") && stricmp(name,"Hector Plasmic") && stricmp(name,"Mark Kimes")) {
				field_protect(fld2,1);
			}
		}
	}

	prep_template(wnd2);
AttrOver:
	exitcode=data_entry(wnd2);
	if (exitcode==ESC) {
		goto QuitAttr;
	}
	if(type) {
		if(exitcode!=F7) {
			bell();
			goto AttrOver;
		}
	}
	else if (exitcode!=F7 && exitcode!=F10 && exitcode!=F5) {
        delete_window(wnd2);
        goto AttrInterrupt;
    }
	for (x=0;x<16;x++) {
		if (attr[x][0]=='X') msg.attr = (msg.attr | (1<<x));
		else msg.attr = (msg.attr & (~(1<<x)));
	}
	for (x=0;x<10;x++) {
		if (mattr[x][0]=='X') msg.m_attr = (msg.m_attr | (1<<x));
		else msg.m_attr = (msg.m_attr & (~(1<<x)));
	}
QuitAttr:
    delete_window(wnd2);
	if(exitcode!=F5) {
		inattr=0;
	}
	else {
		exitcode=F10;
		goto AttrInterrupt;
	}
	goto SameMess;
}


void help_date (char *bf) {

	strcpy(bf,fidodate());
}
void myname (char *bf) {
	sprintf(bf,"%-35s",name);
}
void myzone (char *bf) {
	sprintf(bf,"%-5u",curaddress.zone);
}
void mynet (char *bf) {
	sprintf(bf,"%-5u",curaddress.net);
}
void mynode (char *bf) {
	sprintf(bf,"%-5u",curaddress.node);
}
void mypoint (char *bf) {
	sprintf(bf,"%-5u",curaddress.point);
}
void mydomain (char *bf) {
	strcpy(to_domain,curaddress.domain);
}

