{

Converts the Bible, King James Version to .NG Compilable Source Files

Version 1.00

(c) Copyright 1994, Michael Gallias

Target: Real

}

{$V-} {$B-}

{$M 8192,0,0}

Program KJV2NG;

Uses CRT,PasStr;

Const
  tot_OT         = 39;
  tot_NT         = 27;
  tot_Books      = tot_OT + tot_NT;

Type
  TBibRec        = Record
                     FileName   :String[3];
                     BookName   :String[30];
                     Words      :LongInt;
                     Chaps      :Word;
                     Verses     :Word;
                     Letters    :LongInt;
                   End;

  TBibDet        = Record
                     Words      :LongInt;
                     Chaps      :Word;
                     Verses     :Word;
                     Letters    :LongInt;
                   End;

  TBibArr        = Array [1..tot_Books] of TBibRec;     {Files}
  TBibStat       = Array [1..tot_Books] of TBibDet;     {Stats}

Const
  _Files         : TBibArr =
                   ( (FileName:'GEN';BookName:'Genesis'),
                     (FileName:'EXO';BookName:'Exodus'),
                     (FileName:'LEV';BookName:'Leviticus'),
                     (FileName:'NUM';BookName:'Numbers'),
                     (FileName:'DEU';BookName:'Deuteronomy'),
                     (FileName:'JOS';BookName:'Joshua (Josue)'),
                     (FileName:'JDG';BookName:'Judges'),
                     (FileName:'RTH';BookName:'Ruth'),
                     (FileName:'SA1';BookName:'1 Samuel (1 Kings)'),
                     (FileName:'SA2';BookName:'2 Samuel (2 Kings)'),
                     (FileName:'KI1';BookName:'1 Kings (3 Kings)'),
                     (FileName:'KI2';BookName:'2 Kings (4 Kings)'),
                     (FileName:'CH1';BookName:'1 Chronicles (1 Paralipomena)'),
                     (FileName:'CH2';BookName:'2 Chronicles (2 Paralipomena)'),
                     (FileName:'EZR';BookName:'Ezra (1 Esdras)'),
                     (FileName:'NEH';BookName:'Nehemiah (2 Esdras, Nehemias)'),
                     (FileName:'EST';BookName:'Esther'),
                     (FileName:'JOB';BookName:'Job'),
                     (FileName:'PSA';BookName:'Psalms'),
                     (FileName:'PRO';BookName:'Proverbs'),
                     (FileName:'ECC';BookName:'Ecclesiastes'),
                     (FileName:'SON';BookName:'Song Of Songs'),
                     (FileName:'ISA';BookName:'Isaiah (Isaias)'),
                     (FileName:'JER';BookName:'Jeremiah (Jeremias)'),
                     (FileName:'LAM';BookName:'Lamentations'),
                     (FileName:'EZE';BookName:'Ezekiel (Ezechiel)'),
                     (FileName:'DAN';BookName:'Daniel'),
                     (FileName:'HOS';BookName:'Hosea (Osee)'),
                     (FileName:'JOE';BookName:'Joel'),
                     (FileName:'AMO';BookName:'Amos'),
                     (FileName:'OBA';BookName:'Obadiah (Abdias)'),
                     (FileName:'JON';BookName:'Jonah (Jonas)'),
                     (FileName:'MIC';BookName:'Micah (Michaeas)'),
                     (FileName:'NAH';BookName:'Nahum'),
                     (FileName:'HAB';BookName:'Habakkuk (Habacuc)'),
                     (FileName:'ZEP';BookName:'Zephaniah (Sophonias)'),
                     (FileName:'HAG';BookName:'Haggai (Aggaeus)'),
                     (FileName:'ZEC';BookName:'Zechariah (Zacharias)'),
                     (FileName:'MAL';BookName:'Malachi (Malachias)'),
                     (FileName:'MAT';BookName:'Matthew'),
                     (FileName:'MAR';BookName:'Mark'),
                     (FileName:'LUK';BookName:'Luke'),
                     (FileName:'JOH';BookName:'John'),
                     (FileName:'ACT';BookName:'Acts'),
                     (FileName:'ROM';BookName:'Romans'),
                     (FileName:'CO1';BookName:'1 Corinthians'),
                     (FileName:'CO2';BookName:'2 Corinthians'),
                     (FileName:'GAL';BookName:'Galatians'),
                     (FileName:'EPH';BookName:'Ephesians'),
                     (FileName:'PHI';BookName:'Philippians'),
                     (FileName:'COL';BookName:'Colossians'),
                     (FileName:'TH1';BookName:'1 Thessalonians'),
                     (FileName:'TH2';BookName:'2 Thessalonians'),
                     (FileName:'TI1';BookName:'1 Timothy'),
                     (FileName:'TI2';BookName:'2 Timothy'),
                     (FileName:'TIT';BookName:'Titus'),
                     (FileName:'PHM';BookName:'Philemon'),
                     (FileName:'HEB';BookName:'Hebrews'),
                     (FileName:'JAM';BookName:'James'),
                     (FileName:'PE1';BookName:'1 Peter'),
                     (FileName:'PE2';BookName:'2 Peter'),
                     (FileName:'JO1';BookName:'1 John'),
                     (FileName:'JO2';BookName:'2 John'),
                     (FileName:'JO3';BookName:'3 John'),
                     (FileName:'JUD';BookName:'Jude'),
                     (FileName:'REV';BookName:'Revelation (Apocalypse)')
                   );

Procedure Pad(Total,WithChar:Byte);

Begin
  For Total:=1 to Total do      {As many times as requested}
      Write(Chr(WithChar));     {write the char}
End;  {Pad}

Procedure EditString(X,Y,MaxLets:Byte;Upper:Boolean;Var MainStr:String);

Var
  Ins             :Boolean;   {Boolean for the Insert Key Status}
  C               :Char;      {Current Character}
  CurXPos,
  Count           :Byte;      {Number Of Chars In String}

Begin
  Ins:=False;                {The Insert key has not yet been pressed}
  CurXPos:=1;                {Current Relative X Position+1}
  GotoXY(X,Y);
  UnPadVar(MainStr,MainStr);
  If Length(MainStr)>MaxLets Then
    MainStr:=Copy(MainStr,1,MaxLets);
  Write(MainStr);
  Pad(MaxLets-Length(MainStr),32);
  Count:=Length(MainStr)+1;  {How many letters in the string+1}

  Repeat                     {Repeat Until [Return] is Pressed}
    GotoXY(X+CurXPos-1,Y);   {Goto the Requested Area}
    If Upper Then
      C:=UpCase(ReadKey)
    Else
      C:=ReadKey;

    If C=Chr(0) Then         {Check for a cursor key}
    Begin
      C:=ReadKey;            {Which cursor key}         {Numeric Keypad Value}
      If (C='O') Then CurXPos:=Count;                            {1}
      If (C='P') And (CurXPos>=3) Then Dec(CurXPos,2);           {2}
      If (C='Q') And (CurXPos>=4) Then Dec(CurXPos,3);           {3}
      If (C='K') And (CurXPos>1) Then Dec(CurXPos);              {4}
      If (C='M') And (CurXPos<Count) Then Inc(CurXPos);          {6}
      If (C='G') Then CurXPos:=1;                                {7}
      If (C='H') And (CurXPos<=Count-2) Then Inc(CurXPos,2);     {8}
      If (C='I') And (CurXPos<=Count-3) Then Inc(CurXPos,3);     {9}
      If (C=#7 ) Then MainStr[0]:=Chr(CurXPos-1);                {Shift-Del}
      If (C='S') And (Count>1) Then                              {Del}
      Begin
        Delete(MainStr,CurXPos,1);
        GotoXY(X,Y);
        Write(MainStr,' ');
        Dec(Count);
        GotoXY(X-1+CurXPos,Y);
      End;
      If (C='R') Then                                            {Ins}
      Begin
        Ins:=Not Ins;
      End;
      GotoXY(X-1+CurXPos,Y);
    End  {End Extended Key}
    Else
    Begin

      If (C=#17) Then                           {^Q}
      Begin
        C:=ReadKey;
        If C=#0 Then
          C:=ReadKey
        Else
        If C in ['y','Y',#25] Then
        Begin
          MainStr[0]:=Chr(CurXPos-1);
          Count:=CurXPos;
          GotoXY(X,Y);
          Write(MainStr);
          Pad(MaxLets-Length(MainStr),32);
        End;
      End
      Else
      If (C=#27) Then
      Begin
        GotoXY(X,Y);
        Pad(MaxLets,32);
        MainStr:='';
        C:=#13;
      End
      Else
      If (C=#8) Then                     {Was BackSpace Presssed?}
      Begin
        If (CurXPos>1) Then              {Can I BackSpace?}
        Begin
          Delete(MainStr,CurXPos-1,1);   {Delete the char}
          GotoXY(X,Y);
          Write(MainStr,' ');            {Redisplay the String}
          Dec(Count);                    {One less char}
          Dec(CurXPos);                  {Move Back}
          GotoXY(X-1+CurXPos,Y);         {Goto Position}
        End;                             {End 'Can I BackSpace?'}
      End                                {End 'Was BackSpace Pressed?'}
      Else                               {No Not BackSpace - A Normal Letter}
        If (CurXPos<=MaxLets) And (C<>#13) Then    {Is there Space?}
        Begin
          If Ins Or (CurXPos>=Count) Then   {Must I Insert the Char?}
          Begin
            If Count<=MaxLets Then
              Begin
                Insert(C,MainStr,CurXPos);  {Insert the Char}
                Inc(Count);                 {Add 1 to Count}
                Inc(CurXPos);               {Move Cursor}
              End;                          {End Check for Space in String}
          End                               {End Check to see if Ins was True}
          Else                              {No, Do not Insert, Overwrite}
          Begin
            MainStr[CurXPos]:=C;      {Overwrite char}
            Inc(CurXPos);             {Move Cursor}
          End;                        {End Insert / Overwrite}

          If CurXPos<Count Then       {If the char was Inserted, Rewrite}
          Begin                       {the entire String to the screen}
            GotoXY(X,Y);
            Write(MainStr);
            GotoXY(X-1+CurXPos,Y);
          End                         {End Rewrite the String to the screen}
          Else                        {Need Not Rewrite the entire String}
             Write(C);                {Just Display the new char}
        End;
    End;                              {End Area which accepts a BackSpace or a Letter}
  Until C=#13;
End;

Procedure GetChapVerse(S:String;Var Chap,Verse:Word);

Var
  Code  :Integer;
  SpPos :Byte;

Begin
  Delete(S,1,5);
  SpPos:=Pos(':',S);
  Val(Copy(S,1,SpPos-1),Chap,Code);
  If Code<>0 Then Halt;
  Delete(S,1,SpPos);
  SpPos:=Pos(' ',S);
  Val(Copy(S,1,SpPos-1),Verse,Code);
  If Code<>0 Then Halt;
End;

Procedure GetPaths(Var InPath,OutPath:String);

Var
  C     :Char;

Begin
  ClrScr;
  WriteLn;
  WriteLn('King James Version Text Format to .NG Source Format           Version  1.00');
  WriteLn('Copyright (c) Michael Gallias, 1994');
  WriteLn;
  WriteLn('Note that this program does NOT convert directly to .NG format, it converts');
  WriteLn('the files to a new text format so that they can be compiled with the Norton');
  WriteLn('Guides Compiler.  You thus require the Norton Guides Compiler to convert the');
  WriteLn('files.');
  WriteLn;
  WriteLn('Also note that the process requires 15 megabytes of free disk space.');
  WriteLn('The program will run about 10 times faster if you use the SmartDrv write cache.');
  WriteLn('For further details, please see the documentation.');
  WriteLn;
  WriteLn('* This program has only been tested on the KJV text released with K Bible.');
  WriteLn('  If you find this program useful, please send me a postcard.');
  WriteLn;
  Write('Do you want to continue  (Y)es (N)o  ?');
  C:=UpCase(ReadKey);
  If C<>'Y' Then Halt;
  ClrScr;
  WriteLn;
  WriteLn('Specify the directory where this program and the original text files');
  WriteLn('are to be found.');
  WriteLn;
  EditString(1,WhereY,60,True,InPath);
  If Length(InPath)>2 Then
    If InPath[Length(InPath)]<>'\' Then InPath:=InPath+'\';
  WriteLn;
  WriteLn;
  WriteLn;
  WriteLn('Specify the output directory for the new text files which need compiling.');
  WriteLn;
  EditString(1,WhereY,60,True,OutPath);
  If Length(OutPath)>2 Then
    If OutPath[Length(OutPath)]<>'\' Then OutPath:=OutPath+'\';
  WriteLn;
  WriteLn;
  WriteLn;
  WriteLn;
  WriteLn('Press [Esc] to abort, any other key continues.');
  WriteLn;
  C:=ReadKey;
  If C=#27 Then Halt;
  ClrScr;
End;

Var
  Stats          :TBibStat;
  CurrentBook    :Byte;

Procedure DoCount(NewLine:String);      {NewLine = Outputted Line of Text}

Var
  X,                            {Counter}
  PnCnt,                        {Punctuation Count}
  SpCnt,                        {Space (Word-1) Count}
  LtCnt   :Byte;                {Letter Count, exl. Spaces}

Begin
  SpCnt:=0;
  PnCnt:=0;
  LtCnt:=Length(NewLine);

  For X:=1 to LtCnt do
  Begin
    If NewLine[X]=' ' Then Inc(SpCnt);
    If Not (NewLine[X] in ['a'..'z','A'..'Z']) Then Inc(PnCnt);
  End;

  Inc(Stats[CurrentBook].Words,SpCnt+1);
  Inc(Stats[CurrentBook].Letters,LtCnt - PnCnt);
End;

Procedure ControlEOL(Var OutF:Text; NewLine:String; NChap, NVerse:Word);
{Outputs Bible Text, No Line Overflows}

Const
  S     :String  = '';          {Buffer}
  PadB  :Boolean = False;       {Needs padding? (no verse number)}
  Chap  :Word    = 0;
  Verse :Word    = 0;

Var
  SpPos   :Byte;                {Space Position}
  DoneSet :Boolean;             {Set Chapter}

Begin
  If (NChap>0) And (Chap=0) Then
  Begin
    Chap:=NChap;
    Verse:=NVerse;
    DoneSet:=True;
  End
  Else
    DoneSet:=False;

  If (Length(S)>0) And (S[Length(S)]<>' ') And
     (Length(NewLine)>0) And (NewLine[1]<>' ') Then
    WriteLn('Spacing Error.');

  S:=S+NewLine;

  While Length(S)>68 do
  Begin
    SpPos:=RevPosFrom(' ',S,68);
    NewLine:=Copy(S,1,SpPos-1);
    If NewLine[1]=' ' Then Delete(NewLine,1,1);
    Delete(S,1,SpPos);

    If Chap=0 Then
      Write(OutF,'         ')
    Else
    Begin
      Write(OutF,Chap:3,':',Verse:3,'  ');
      Chap:=0;
    End;

    WriteLn(OutF,NewLine);
    DoCount(NewLine);
  End;

  If (NewLine='') And (S<>'') Then
  Begin
    If Chap=0 Then
      Write(OutF,'         ')
    Else
    Begin
      Write(OutF,Chap:3,':',Verse:3,'  ');
      Chap:=0;
    End;

    If S[1]=' ' Then Delete(S,1,1);
    WriteLn(OutF,S);            {Flush Buffer}
    DoCount(S);
    S:='';
  End;


  If (Not DoneSet) And (NChap>0) And (Chap=0) Then
  Begin
    Chap:=NChap;
    Verse:=NVerse;
  End;

End;

Var
  InF,                          {Bible}
  OutF           :Text;         {NG}
  S              :String;
  InPath         :String;       {Path to Bible}
  OutPath        :String;       {Path to NG}
  LastVerse,
  LastChap,
  Chap,                         {Current Chapter}
  Verse          :Word;         {Current Verse}
  Total          :LongInt;      {Statistics}

Begin
  FillChar(Stats,SizeOf(Stats),0);

  OutPath:='C:\TEMP\';
  InPath:='D:\KBIBLE\KJV\';
  GetPaths(InPath,OutPath);

  For CurrentBook:=1 to tot_Books do
  Begin
    FormatVar(_Files[CurrentBook].BookName,S,30,LeftText);
    Write(CurrentBook:2,'. ',S);

    Assign(InF,InPath+_Files[CurrentBook].FileName+'.TXT');
    Reset(InF);

    Assign(OutF,OutPath+_Files[CurrentBook].FileName+'.NGS');
    Rewrite(OutF);
    Chap:=0;
    Verse:=0;

    While Not EOF(InF) do
    Begin
      ReadLn(InF,S);
      If S[1]=#$1F Then
      Begin
        ControlEOL(OutF,'',0,0);       {Flush Buffer}
        LastChap:=Chap;
        LastVerse:=Verse;
        GetChapVerse(S,Chap,Verse);
        If LastChap<>Chap Then
        Begin
          Inc(Stats[CurrentBook].Verses,LastVerse);
          WriteLn(OutF);
          WriteLn(OutF,'!Short: ',_Files[CurrentBook].BookName,', Chapter ',Chap:3);
          WriteLn(OutF);
          WriteLn(OutF,'^U',_Files[CurrentBook].BookName,', Chapter ',Chap:3,'^U');
          WriteLn(OutF);
        End;
        Delete(S,1,Pos('  ',S));
        ControlEOL(OutF,S,Chap,Verse);                  {Buffer Next Line}
      End
      Else
        ControlEOL(OutF,S,0,0);                  {Buffer Next Line}
    End;
    ControlEOL(OutF,'',0,0);     {Flush Buffer}
    Inc(Stats[CurrentBook].Verses,Verse);

    Close(InF);
    Close(OutF);

    Stats[CurrentBook].Chaps:=Chap;
    If Stats[CurrentBook].Chaps=1 Then
      Write(Stats[CurrentBook].Chaps:3,' Chapter,  ')
    Else
      Write(Stats[CurrentBook].Chaps:3,' Chapters, ');
    WriteLn(Stats[CurrentBook].Verses:6,' Verses.');
  End;

  Assign(OutF,OutPath+'KJV.NGS');
  Rewrite(OutF);

  WriteLn(OutF,'!Name: The Bible, King James Version');
  WriteLn(OutF);
  WriteLn(OutF,'!Credits:');
  WriteLn(OutF);
  WriteLn(OutF,'This file was created by converting the public domain King James');
  WriteLn(OutF,'Version text files into Norton Guides format using KJV2NG,');
  WriteLn(OutF,'(c) Copyright, 1994, Michael Gallias.  This file may be freely');
  WriteLn(OutF,'distributed.');
  WriteLn(OutF);
  WriteLn(OutF,'!Menu: Bible');
  WriteLn(OutF);
  WriteLn(OutF,'       Old Testament    OT.NGO');
  WriteLn(OutF,'       New Testament    NT.NGO');
  WriteLn(OutF,'       Statistics       ST.NGO');
  WriteLn(OutF);

  Close(OutF);

  Assign(OutF,OutPath+'OT.NGS');
  Rewrite(OutF);

  For CurrentBook:=1 to tot_OT do
  Begin
    WriteLn(OutF,'!Short: ',_Files[CurrentBook].BookName);
    WriteLn(OutF,'!File: ',_Files[CurrentBook].FileName+'.NGO');
  End;

  Close(OutF);

  Assign(OutF,OutPath+'NT.NGS');
  Rewrite(OutF);

  For CurrentBook:=tot_OT + 1 to tot_OT + tot_NT do
  Begin
    WriteLn(OutF,'!Short: ',_Files[CurrentBook].BookName);
    WriteLn(OutF,'!File: ',_Files[CurrentBook].FileName+'.NGO');
  End;

  Close(OutF);

  Assign(OutF,OutPath+'ST.NGS');
  Rewrite(OutF);

  WriteLn(OutF);
  WriteLn(OutF,'!Short: Statistics');
  WriteLn(OutF);
  WriteLn(OutF,'^UStatistics^U');
  WriteLn(OutF);
  WriteLn(OutF,'^BChapters^B     The total number of chapters in the book.');
  WriteLn(OutF,'^BVerses^B       The total number of verses in the book.');
  WriteLn(OutF,'^BWords^B        The total number of words in the book.');
  WriteLn(OutF,'^BLetters^B      The total number of letters in the book, excluding');
  WriteLn(OutF,'             spaces, verse numbers and punctuation.');
  WriteLn(OutF);
  WriteLn(OutF,'^BBook names^B   are spelled according to the NIV, with the Knox Translation');
  WriteLn(OutF,'             spellings in parenthesis.');
  WriteLn(OutF);
  WriteLn(OutF,'^BBook name                     Chapters  Verses   Words    Letters^B');
  WriteLn(OutF);
  For CurrentBook:=1 to tot_Books do
  Begin
    FormatVar(_Files[CurrentBook].BookName,S,30,LeftText);
    WriteLn(OutF,S,'  ',
                 Stats[CurrentBook].Chaps:3,'    ',
                 Stats[CurrentBook].Verses:6,'   ',
                 Stats[CurrentBook].Words:6,'   ',
                 Stats[CurrentBook].Letters:8
           );
  End;

  WriteLn(OutF);
  FormatVar('^BTotal',S,32,LeftText);
  Write(OutF,S);
  Total:=0;
  For CurrentBook:=1 to tot_Books do
    Inc(Total,Stats[CurrentBook].Chaps);
  Write(OutF,Total:5,'  ');

  Total:=0;
  For CurrentBook:=1 to tot_Books do
    Inc(Total,Stats[CurrentBook].Verses);
  Write(OutF,Total:8,' ');

  Total:=0;
  For CurrentBook:=1 to tot_Books do
    Inc(Total,Stats[CurrentBook].Words);
  Write(OutF,Total:8,' ');

  Total:=0;
  For CurrentBook:=1 to tot_Books do
    Inc(Total,Stats[CurrentBook].Letters);
  WriteLn(OutF,Total:10,'^B');

  WriteLn(OutF);
  WriteLn(OutF,'Numbers should be accurate, but I do not guarantee they are accurate.');
  WriteLn(OutF,'If you find any mistakes in this file, please contact me:');
  WriteLn(OutF);
  WriteLn(OutF,'Michael Gallias');
  WriteLn(OutF,'P O Box 51231');
  WriteLn(OutF,'Musgrave Road');
  WriteLn(OutF,'4062');
  WriteLn(OutF,'South Africa');
  WriteLn(OutF);
  WriteLn(OutF,'Internet EMail: gallias@ph.und.ac.za');
  WriteLn(OutF);
  Close(OutF);

  Assign(OutF,OutPath+'KJV.BAT');
  Rewrite(OutF);

  WriteLn(OutF,'@echo off');
  For CurrentBook:=1 to tot_Books do
    WriteLn(OutF,'call ngc ',_Files[CurrentBook].FileName+'.NGS');

  WriteLn(OutF,'call ngc ot.ngs');
  WriteLn(OutF,'call ngc nt.ngs');
  WriteLn(OutF,'call ngc st.ngs');
  WriteLn(OutF,'call ngml kjv.ngs');

  Close(OutF);
End.
