		page	66,80
	TITLE	REBOOT.COM  3.3 reboots the system

	.model	tiny		; this is a COM file

comment 
	by Roedy Green
	works with MASM 5.0, 6.0 and Optasm

	For MASM 5.0 use:
	Masm	%1.Asm,%1.Obj,%1.Lst,Nul.Crf/Z/B60/N %2 %3 %4 %5
	link	%1.Obj,%1.Exe,%1.Map,/MAP

	for MASM 6.0 use:
	ML.EXE /AT /c /Fl /VM /Zf /Zm %2 %3 %4 %5 %1.Asm
	LINK.EXE /TINY /MAP %2 %3 %4 %5 %1.Obj,%1.com,%1.map;

	For Optasm use:
	Optasm	 %1.Asm,%1.Obj,%1.Lst/L/N/G/S %2 %3 %4 %5
	OLINK	 %1.Obj,%1.COM,/MAP/TINY;

  USAGE:

  for a warm boot (no ram test):
  Reboot
  Reboot /W
  Reboot /Warm

  for cold boot (with ram test):
  Reboot /C
  Reboot /Cold

Version 3.3 1996 October 25
- embed POB 707 Quathiaski Cove address
- make work under Win95.
- embed simplified version of the DESQview @xxx macros
  so DVAPI.INC no longer needed.
- improved prompts when reboot under Windown, DESQ, OS/2, Win95.
- message about reset button for machines that freeze.

Version 3.2
   - OS/2 aware
   - uses keyboard controller to reset for AT, jmp F000:FFF0 for 8086

Version 3.1
   - reset video to regen page 0.

Version 3.0
    - displays new phone and address
    - we skipped version 2.9 because version cannot be encoded as time.

Version 2.8

    - code to handle Norton Cache -- forces flush before reboot,
      rather than just waiting.

Version 2.7

    - warning about getting 4DOS reboot instead of this one.

Version 2.6

    - code now assembles without tweaking under OPTASM, MASM 5.0 and MASM 6.0.

Version 2.5

    - extra time for Norton Cache to flush, in case using delayed writes.

Version 2.4

   - added 1992 copyright notice

Version 2.3

   - Stealth aware.  In case BIOS is mapped out, no longer jumps
     to FFFF:0, but rather sets up an interrupt to point to it
     and then interrupts.  This gives programs like 386MAX and
     QEMM warning BIOS code will be needed.  We use int 11h equipment
     determine, since Stealth would expect such an interrupt to examine
     high BIOS.  Further, this makes it more likely full BIOS will be
     visible AFTER the reboot when the new incarnation of DOS starts up.

Version 2.2

  - more time with interrupts turned on in "breath" after
    disk reset.

  - bypass bug in Norton Cache 6.01, ignores disk reset.
    Now 11-seconds of "breaths", to give Norton
    NCACHE 1 second to start writes, and three to complete.

  - bypass bug fixed in PC Tools Cache, version 6. something.
    It to failed to flush the cache on disk reset.

Version 2.1
  - fast reboot in DESQ if there is only one window open.
  - now uses DVAPI.INC -- DESQ api interface.

Version 2.0
  - improved DESQview Awareness
  - Windows 3.0 enhanced awareness

Version 1.9
  - added DESQview Awareness

Version 1.8
  - added clear of all serial ports to stop interrupts during reboot
  - mice or modems could interfere.

Version 1.7
  - added Disk Reset

Version 1.6
  - added both Warm and Cold boot options.

Note:
  - Jumping to INT 19 does not work. This leaves old vectors in place.
  - jumping to F000:FFF0 only works on the 8086.
  - using system control port 92h only works on MCA and same EISA
  - sending at FE command to the keyboard controller port works on AT
    machines, but not the 8086.

Futures:
- /A command to avoid keyboard controller reset.

  ; end of comment

;	include C:\DV\dvapi.inc ; DESQ macros
;	part of DESQ Application Programmer Interface
;	Simplified version of DESQview macros

open	equ	0C03h
erase	equ	0E03h
pause	equ	1000h
sizeof	equ	803h
write	equ	501h
mailme	equ	12h
me	equ	12h

@send	macro	function,recipient
	mov	bx,&function
	mov	ah,&recipient
	int	15h
	ENDM

@call	macro	function
	mov	ax,&function
	int	15h
	ENDM
BIOSDATA    segment AT 40h	; dummy segment in low RAM
	org	0h
BIOSComAddrs	dw	?	; 4 words of COM1: .. COM4:
		dw	?	; device addresses
		dw	?
		dw	?
		org	72h
BIOSWarmFlag	dw	?
BIOSDATA	ends

ROMBIOS 	segment AT 0f000h	; dummy segment inside ROM BIOS
		org	0fff0h
BIOSReset	label	far		; reset code at FFFF:0000
					; better represented as F000:FFF0
					; If used in tiny model, setting
					; to DWORD ? tends to freak MASM out
					; less, but we are ok here.
		org	0fffEh
BIOSMachineId	db	?		; BIOS machine type code
ROMBIOS 	ends

CODE	segment public

DATA	segment

ToBiosReset	label dword
	dw	offset BIOSReset	; FFF0:FFF0
	dw	ROMBIOS 		; for indirect jump

DATA	ends

cgroup	group	Code,Data
	assume	cs:cgroup,ss:cgroup,ds:cgroup,es:cgroup
	org	100h
;==========================

Start	proc	far
	lea	dx,BannerMsg	; display banner
	Call	Say

	call	Parse		; parse the command line

	call	Analyze 	; analyze the /parameter

	call	DiskReset	; Make DOS flush the buffers

	Call	NCACHE		; handle bug in Norton NCACHE.
				; It fails to flush the buffers.

	Call	PCTOOLS 	; handle flushing Central Point
				; PCTOOLS cache.

	call	Breath		; wait one breath
				; to give the world time to settle
				; and allow time to admire the banner.
				; interrupts are still on to allow windup.

	Call	BootDESQ	; reboot DESQ if needed

	Call	BootOS2 	; reboot OS/2 if needed

	Call	BootWIN 	; reboot Windows if needed

	lea	dx,FinalMsg
	call	Say

	call	Breath

	call	KillComs	; kill interrupts on all com ports
				; don't do this for DESQ, OS/2, Windows

	Call	SetWarmCold	; choose a warm or cold boot

	Call	VideoReset	; clear video

	Call	BootViaKbd	; reboot via keyboard controller for AT

	Call	Boot8086	; jump to BIOS reset


	; Will not come back, but just in case
	jmp	$		; loop to allow user to manually reboot

;==============================================================
;  V A R I A B L E S

;  We put variables in this odd place so that MASM will not get
;  phase errors.  It cannot handle forward references well.

QuitTime	DD	0	; time in ticks to quit waiting

MyWarmFlag	DW	01234h	; 1234h if warm boot
				; 0	if cold boot


BannerMsg	label	byte
	DB	' Reboot 3.3 ۲',13d,10d
	DB	13d,10d
	DB	'Copyright (c) 1990-1996 Roedy Green Canadian Mind Products',13,10
	DB	'POB 707 Quathiaski Cove, Quadra Island, BC Canada V0P 1N0',13,10
	DB	'Telephone: (250) 285-2954          Internet:roedy@bix.com',13,10
	DB	'May be freely distributed and used for any purpose except military.',13,10,'$'

Usage		db 'Error in command line.',13,10
		db 'Try Reboot /W or plain Reboot for a warm boot or Reboot /C for a cold boot.',13,10,'$'

NCACHEMsg	db 13,10
		db 'Norton NCACHE Active.  Waiting for disk cache to flush.',13,10,'$'

PCTOOLSMsg	db 13,10
		db 'PC Tools Cache Active.  Waiting for disk cache to flush.',13,10,'$'

DESQMsg 	db 13,10
		db 'DESQview Active.  Close all other windows then reboot with Ctrl-Shift-Del.',13,10
		db 'Or use Ctrl-Break, EXIT to close just this session.',13,10,'$'

WIN3Msg 	db 13,10
		db 'Windows DOS emulation.',13,10
		db 'Use Ctrl-Break, EXIT to close this session.',13,10
		db 'Then use Ctrl-Esc to close all other tasks.',13,10
		db 'Then shutdown Windows.',13,10
		db 'Then reboot with Ctrl-Alt-Del.',13,10,'$'

WIN95Msg	db 13,10
		db 'Windows 95 DOS emulation.',13,10
		db 'Use Ctrl-Break, EXIT to close this session.',13,10
		db 'Then use task bar to close all other tasks.',13,10
		db 'Then shutdown Windows.',13,10,'$'

OS2Msg		db 13,10
		db 'OS/2 DOS emulation.',13,10
		db 'Use Shutdown to close all of OS/2 or use Close to exit just this session.',13,10,'$'

FinalMsg	db 13,10
		db 'If reboot freezes, use the RESET button.',13,10,'$'

;===============================================================

Say	Proc
;	on entry DX points to a string to display
	MOV	AH,9
	Int	21h
	ret
Say	EndP

;===============================================================

MLeading	PROC	Near
;	on entry BX is addr of string, CX its length
;	trims off any leading blanks, leaving result in BX CX
;	length may also be 0 or 1, but not -ve
;	If the entire string is blank the result is the null string
	mov	di,bx
	mov	al,20H		; AL = blank  -- the search char
	jcxz	mleading2	; jump if null string
	repe	scasb		; scan ES:DI forwards till hit non blank
				; DI points just after it (wrap ok)
				; cx IS ONE TOO SMALL, OR 0 IF NONE FOUND
	je	mleading1	; jump if entire string was blank
	inc	cx		; CX is length of remainder of string
mleading1:
	dec	di		; DI points to non-blank
mleading2:
	mov	bx,di		; put address back
	ret
MLeading	ENDP

;========================================

MTrailing	PROC	Near
;	on entry BX is addr of string, CX its length
;	trims off any trailing blanks, leaving result in BX CX
;	length may also be 0 or 1, but not -ve
;	If the entire string is blank the result is the null string
	mov	di,bx
	add	di,cx		; calc addr last char in string
	dec	di
	mov	al,20H		; AL = blank  -- the search char
	jcxz	mtrailing1	; jump if null string
	std
	repe	scasb		; scan ES:DI backwards till hit non blank
				; DI points just ahead of it (wrap ok)
				; CX is one too small, or 0 if none found
	cld
	je	mtrailing1	; jump if whole string was blank
	inc	cx
mtrailing1:
	ret
MTrailing	ENDP

;========================================

Parse	PROC	NEAR
;	Parse the command line to remove lead/trail blanks
;
;	sample inputs
;	Reboot /Cold
;	Reboot /W
;	Reboot
;
;	When Done DS:BX points to start of string.
;	CX counts bytes in string
				; counted string at HEX 80 PSP
				; contains command line.
				; Preceeded by unwanted spaces.
				; possibly followed by unwanted spaces.
	xor	ch,ch
	mov	cl,ds:80H
	mov	bx,81H
	call	Mleading	; get rid of leading blanks
	call	MTrailing	; get rid of trailing blanks
	ret
Parse	ENDP

;======================================

Analyze PROC	NEAR
;	analyses the /C or /W parameter
;	On entry DS:BX points to start of string.
;	CX counts bytes in string
;	lead/trail spaces are gone.

	jcxz	AnalDone	; was no /parm, treat as warm
	cmp	cx,2
	jl	BadCmd		; kick out plain /
	mov	ax,[bx] 	; get chars AL<-/  AH<-C
	cmp	al,'/'		; make sure first char is /
	jne	BadCmd
	mov	al,ah
	call	ToUc
	cmp	al,'C'
	je	WasCold
	cmp	al,'W'
	je	WasWarm
BadCmd: lea	dx,Usage
	Call	Say
	Jmp	Abort
WasCold:
	Mov	MyWarmFlag,0
WasWarm:
AnalDone:
	RET
Analyze ENDP

;======================================

ToUC	PROC	NEAR
;	converts char in AL to upper case
	cmp	al,'a'
	jb	FineAsIs
	cmp	al,'z'
	ja	FineAsIs
	sub	al,20H		; convert a to A
FineAsIs:
	ret
ToUc	ENDP

;======================================

KillComs	Proc	Near

;	Clear any serial ports, so they will stop interrupting
;	i.e. clear the modem control registers
;	e.g. 3FC on COM1 .. 4
	push	DS
	mov	ax,BIOSDATA
	mov	DS,ax
	xor	bx,bx
	assume	DS:BIOSDATA
	lea	si,BIOSComAddrs ; 4 words of device address
	mov	cx,4

KillLoop:
	lodsw			; ax = next device address
	cmp	ax,bx		; is it zero?
	je	NoCom		; yes, then there is nothing to do.
	mov	dx,ax		; dx=port base
	add	dx,4		; dx=port of modem control reg
	mov	ax,bx		; ax=0
	out	dx,al		; clear modem control device reg
NoCom:
	loop	KillLoop	; repeat for 4 com ports
	pop	DS
	ret
KillComs	EndP

;===============================================================

DiskReset	Proc	Near

;	Ask DOS to flush her buffers.
;	Presumably, cachers will intercept this and flush their
;	buffers too.

	mov	ah,0dh		; disk reset function
	int	021h		; call DOS
	ret
DiskReset	EndP

;===============================================================

NCACHE	Proc	Near

;	Ensure Norton cache flushes its buffers.
;	It does not complete the flush on Disk Reset the way other caches do.

;	Detect if Norton Cache 6.01 is present
	mov	ax,0FE00h	; set up mux interrupt signature
				; function 00 --is NCACHE present?
	mov	di,04E55h	; "NU"
	mov	si,04346h	; "CF"
	stc			; set carry to indicate failure
	push	ES		; wrecks AX,BX,ES,CX.  Only ES important
	int	02fh		; multiplex interrupt
	pop	ES

	jc	NoNCache	; carry means not present
	cmp	si,06366h	; "cf" signature
	jne	NoNCache	; False hit
	lea	dx,NCACHEMsg	; explain the delay
	call	Say

	mov	ax,0FE02h	; flush then disable Norton Cache.
	mov	di,04E55h	; "NU"
	mov	si,04346h	; "CF"
	push	ES		; wrecks AX,BX,ES,CX.  Only ES important
	int	02fh		; multiplex interrupt
	pop	ES

	mov	ax,0FE01h	; reenable Norton Cache.
				; We do this only because some user
				; might ABORT reboot.
	mov	di,04E55h	; "NU"
	mov	si,04346h	; "CF"
	push	ES		; wrecks AX,BX,ES,CX.  Only ES important
	int	02fh		; multiplex interrupt
	pop	ES

NoNcache:
	ret

NCACHE	EndP

;===============================================================

PCTOOLS Proc	Near

;	Handle flushing a PCTools cache

;	Detect if Central Point Cache is present
	mov	ax,0FFA5h	; signature, NOT INT 2f!!
				; is PCTOOLS present?
	mov	cx,01111h	;
	int	016h		; KEYBOARD interrupt of all things!
	test	ch,ch
	jnz	NoPCTOOLS	; non zero means not present

	lea	dx,PCTOOLSMsg	; explain the delay
	call	Say

	mov	ax,0FFAFh	; signature
				; FLUSH CACHE.
	mov	cx,0FFFFh
	int	016h		; KEYBOARD interrupt of all things!

NoPCTOOLS:
	ret

PCTOOLS EndP

;===============================================================

Breath	Proc	Near

;	Waste 20 ticks (about a second) to give the world time to settle down
;	A delayed write cache has time to flush etc.
;	Preserves CX, so can create longer pauses with
;	loop cx.

	push	cx
	Call	GetTicks		; time in cx:dx
	add	dx,020d
	adc	cx,0
	mov	word ptr QuitTime+0,dx	; Ptr needed because QuitTime is DWORD
	mov	word ptr QuitTime+2,cx
KeepWaiting:
	sub	cx,cx			; CX:DX has mics to wait
	mov	dx,1000d		; wait a 10th of a second

	mov	ah,086h
	int	015h			; idle loop, give up CPU
					; ignored by XT BIOS
	Call	GetTicks
	cmp	cx,word ptr QuitTime+2	; quitting time yet?
	ja	PauseDone
	cmp	dx,word ptr QuitTime+0
	jb	KeepWaiting
PauseDone:
	pop	cx
	ret

Breath	EndP

;===============================================================

GetTicks	PROC	Near
;	Get time of day in 1/18.2 second clock ticks since midnight.
;	leaves tick count in cx:dx

	mov	ah,0
	int	1Ah		; BIOS ticks since midnight
				; cx:dx is count
	ret
GetTicks	EndP

;==============================================================

BootDESQ	Proc	Near

;	reboot Desqview if present

	;; check if DESQview present e.g. @CALL DVPRESENT
	push	bx
	push	cx
	push	dx
	mov	ax,2B01h
	xor	bx,bx
	mov	cx,'DE'
	mov	dx,'SQ'
	int	21h			; DOS Services	ah=function 2Bh
					; set date, cx=year, dx=mon/day
					; deliberately invalid
	mov	ax,bx
	cmp	ax,2
	jne	NotOldDESQ
	xchg	ah,al
NotOldDESQ:
	pop	dx
	pop	cx
	pop	bx
	test	ax,ax
	jnz	DESQPresent
DESQAbsent:
	ret

DESQPresent:
	call	Alone
	test	ax,ax
	jz	ManualClose
				; We are alone, we can safely auto-reboot
	ret			; fall through and handle as normal.

ManualClose:			; must ask user to manually close windows
				; or manually reboot.
	lea	dx,DESQMsg
	call	Say

NowIsTheEnd:
;				; loop till he reboots
	@Call	PAUSE		; give up rest of slice
				; we CANNOT call Alone and autoreboot when
				; all windows closed, because Alone twitches
				; the windows making it impossible to close them.
	jmp	NowIsTheEnd

BootDESQ	Endp

;==============================================================

Alone	Proc	Near

Comment 

Returns AX=0 if we are not alone, AX=1 if alone.

Determine if 1, or more than 1 window is currently open under
DESQview.  Note that we assume that we are running under DV and
do not test for it.

Program works by asking DV to notify when window goes to
background, then asks to be put in the background.  If there are
no other windows open, there is no background, hence no message.
I am unable to think of an easy way to count the number of
windows.

Unfortunately, a side effect of this method is the windows
rapidly swap on the screen making the screen unreadable as Alone
executes.

Code based on the ONEWIN program by Phil Graham [BIXname
pgraham] of Dynamic Data.  He restricts this code to
non-commerical use.


End Comment 

Data	Segment

make_bottom	db	1Bh,10h,2,0,04Bh,0C9h
	; makes receiving application bottommost and notify when background
make_bottom_length equ $-make_bottom

make_fore	db	1Bh,10h,1,0,0C1h ; makes receiving application for
make_fore_length equ $-make_fore

Data	EndS

	@send	open,mailme		; open my mailbox for notification
	@send	erase,mailme		; clear out any old messages
	lea	di,make_bottom		; address of make-bottom stream
	push	DS			; push address as 1st parm
	push	di			; push ds push di
	mov	cx,make_bottom_length	; length of stream
	xor	dx,dx			; convert to dword
	push	dx
	push	cx
	@send	write,me		; move me to bottom of window list
	@call	pause			; be sure notify message gets send
	@send	sizeof,mailme		; any messages in my mailbox?
	pop	si			; # of messages in SI
	pop	ES
	lea	di,make_fore		; address of make-foreground stream
	push	DS			; push address as 1st parm
	push	di
	mov	cx,make_fore_length	; length of stream
	xor	dx,dx			; convert to dword
	push	dx
	push	cx
	@send	write,me		; move me to bottom of window list
	test	si,si			; did I get move-to-bottom message
	jz	OnlyOne 		; NO! I must be the only window open
	mov	ax,0			; There are other windows active
	ret

OnlyOne:
	mov	ax,1			; we are alone, -- the only window
	ret

Alone	EndP

;==============================================================

BootOS2 Proc	Near
;	reboot OS/2 if present

	mov	ax,3000h
	int	21h		; get version number
				; AL=major AH=minor
	cmp	al,10d		; test for OS/2 - DOS 10+
	jge	OS2Present

OS2Absent:
	ret

OS2Present:
	lea	dx,OS2Msg
	call	Say
	Call	WaitForTheEnd
	ret			; won't come back.

BootOS2 Endp

;==============================================================

RoughWindowsVersion	Proc	Near

; Get Detect presence of Windows
; returns 0 in ax if not present, 3 if version 2..3.11, 5 if Win95

; Technique from Ralf Brown's intrlist.
; also Microsoft Journal March 1991

	mov	ax,1600h
	int	2fh		; BEWARE: this code fails on single step
				; when debugging.  You must set a breakpoint
				; afterward, and run at full speed.

	and	ax,07fh 	; AL = 00 if nothing, WIN3r, or WIN3s
				;      01 if WIN 2.x
				;      03 if WIN3e, WFWG
				;      04 if WIN95
				;      7F if WIN 2.x
				;      else treat as nothing
	cmp	al,04
	je	Win95IsPresent
	test	al,al
	jnz	Win3IsPresent
				; discriminate between [WIN3R, WIN3S] and [0]
	mov	ax,4680h
	int	2fh		; AL = 00 if WIN3r or WIN3s
				;      80 if nothing
	test	al,al
	jz	Win3IsPresent
WinIsAbsent:
	mov	ax,0
	ret
Win3IsPresent:
	mov	ax,3
	ret
Win95IsPresent:
	mov	ax,5
	ret
RoughWindowsVersion	EndP

; = = = = = = = = = = = = = = = = = = = = = =

BootWIN Proc	Near
;	special reboot Windows if present
	call	RoughWindowsVersion
	cmp	ax,5
	je	RebootWin95
	cmp	ax,3
	je	RebootWin3
	ret

RebootWin3:
	lea	dx,WIN3Msg
	call	Say
	jmp	WaitForTheEnd

RebootWin95:
	lea	dx,Win95Msg
	call	Say
	jmp	WaitForTheEnd

BootWIN Endp

;==============================================================

WaitForTheEnd	Proc	Near
				; loop endlessly till he reboots
	mov	ah,0bH		; check if char waiting
	int	21h		; this should give Windows a hint we are idling
				; This loop lets us accept a Ctrl-Break
	jmp	WaitForTheEnd

WaitForTheEnd	Endp

;==============================================================

VideoReset     Proc  Near
	mov	ah,5		; select usual active regen page
	mov	al,0
	int	10h
	ret
VideoReset	EndP

;==============================================================

SetWarmCold	Proc

;	set warm or cold boot flag in BIOS area

;	set system reset flag at 0040:0072 to 01234 for warm or 0 for cold
	mov	ax,BIOSDATA
	mov	ds,ax
	assume	ds:BIOSDATA
	mov	ax,MyWarmFlag
	mov	BIOSWarmFlag,ax
	ret

SetWarmCold	EndP

;==============================================================
BootViaKbd		Proc	Near
;	reboot my sending reset command to the keyboard controller
;	This only works on the 80286 and later.
	push	sp		; older processors will push
	pop	ax		; SP-2 instead of SP
	cmp	ax,sp
	jz	Is_286Plus	; if equal, SP was pushed
	ret

Is_286Plus:
	mov	bl,0FEh
	call	KeyboardCmd
				; should not return
	ret

BootViaKbd		EndP

;==============================================================

Boot8086	Proc	Near

; effectively we do JMP BIOSReset to reboot the system
; However, Stealth might have BIOS hidden, so we use a more indirect
; Method.

	mov	ax,ROMBIOS	; set DS:dx to FFFF:0000
				; MASM freaks on SEG BIOSReset
	mov	DS,ax
	assume	ds:ROMBIOS
	mov	dx,offset BIOSReset
				; MASM 5.0 would have trouble had we
				; written lea dx,BIOSReset

	mov	ax,02511h	; set vector int 11h, equipment determine
				; Stealth would expect his vector to look at
				; high BIOS
	int	021h		; set the vector, with DOS

	int	011h		; trigger the vector, effectively
				; far jump to FFFF:0000 alias F000:FFF0
				; SHOULD NOT RETURN, but just in case
;;	jmp	BIOSReset	; MASM 5 and 6 have trouble with this
				; so we use an indirect jump to humour
				; them
	jmp	ToBiosReset
	assume	ds:code

Boot8086	Endp

;==============================================================
IODelay Proc	Near
;	Waste a little time so we don't hit on ports faster than
;	every microsecond:
;	We are very conservative:
;	assume a 1000 MHz cpu, and one loop iteration per cycle
	push	cx
	mov	cx,1000
self:	loop	self
	pop	cx
	ret
IODelay EndP

;==============================================================
KeyboardCmd proc near
;	send command in BL to the keyboard controller
;	(port 64h).
;	Must have ds = cs
;	If the routine times out due to the buffer remaining
;	full, ah is non-zero.
;
;	Returns:	if ah = 0, successful
;			if ah = 1, failed
;	From Frank van Gilluwe's book, The Undocumented PC

	xor	cx, cx		   ; counter for timeout (64K)
cmd_wait:
	in	al, 64h 	   ; get controller status
	call	IODelay
	test	al, 2		   ; is input buffer full?
	jz	cmd_send	   ; ready to accept command ?
	loop	cmd_wait	   ; jump if not
				   ; fall through, still busy
	jmp	cmd_error

cmd_send:			   ; send command byte
	mov	al, bl
	out	64h, al 	   ; send command
	call	IODelay

	xor	cx, cx		   ; counter for time	out (64K)
cmd_accept:
	in	al, 64h 	   ; get controller status
	call	IODelay
	test	al, 2		   ; is input buffer full?
	jz	cmd_ok		   ; jump if command accepted
	loop	cmd_accept	   ; try again
				   ; fall through, still busy
cmd_error:
	mov	ah, 1		   ; return status - failed
	jmp	cmd_exit
cmd_ok:
	xor	ah, ah		   ; return status ok
cmd_exit:
	ret

KeyboardCmd  Endp

;=============================================

Abort:
				; error exit
	mov	ax, 4c04h	; ERRORLEVEL = 4
	int	21h		; DIE
				; we do not reboot.

;==============================================================

Start	endp

;==========================
CODE	ends			; end of code segment
	end	Start
