#!/bin/sh
###############################################################################
# FILE: install_DB_mysql.sh
#
# Version 2.1
#
# DESCRIPTION: This sript is used to create MySQL database
#
# Copyright (c) 2003 Webplus, Inc. ALL RIGHTS RESERVED
#
#
# MAINTENANCE LOG
#3/18/2003: On the first line, if [ "$#" -lt 10 ] was changed to if [ "$#" -lt 11 ]. 
#           Added elif [ "$ADMPASS" = "none" ] and the following line to allow having 
#           admin user without password.    --CL
#
#
###############################################################################


if [ "$#" -lt 11 ]; then
   echo
   echo "Usage: $0 <dbpath> <uninstfile> <dbuser> <dbpass> <dbport> <wphost> <admuser> <admpass> <dbhost> <db cnt> <db1> \[<db2>\]"
   exit 1
fi

DBPATH=$1
shift
FUNINST=$1
shift
DBUSER=$1
shift
DBPASS=$1
shift
DBPORT=$1
shift
WPHOST=$1
shift
ADMUSER=$1
shift
ADMPASS=$1
shift
DBHOST=$1
shift
NUMDB=$1
shift
DB1=$1
if [ "$NUMDB" -eq 2 ]; then
	shift
	DB2=$1
fi

if [ "$ADMUSER" = "none" ]; then
	ADMSTR=""
elif [ "$ADMPASS" = "none" ]; then
	ADMSTR="-u $ADMUSER"
else
	ADMSTR="-u $ADMUSER -p$ADMPASS"
fi

# Try and use some which-craft to get the location of MySQL
MYSQLLOC=`which mysqladmin`
if [ ! $? = 0 ]; then
	echo Error executing which, install will try and find MySQL manually...
else
	# Some older systems (sun) won't like some of this expr syntax, so redirect
	# errors to null, and it'll find it manually later on
	LEN=`expr length $MYSQLLOC 2>/dev/null`
	LEN=`expr $LEN - 11 2>/dev/null`
	MYSQLLOC=`expr substr $MYSQLLOC 1 $LEN 2>/dev/null`
fi
POSSDIRS="$MYSQLLOC /mysql /usr/mysql /usr/local/mysql /opt/mysql /usr/bin /usr/local"
for i in $POSSDIRS
do
	if [ -x "$i/mysqladmin" ]; then
		MYSQLDIR="$i"
		break
	fi
	if [ -x "$i/client/mysqladmin" ]; then
		MYSQLDIR="$i/client"
		break
	fi

	if [ -x "$i/bin/mysqladmin" ]; then
		MYSQLDIR="$i/bin"
		break
	fi
done

if [ -z "$MYSQLDIR" ]; then
	echo
	echo "I could not locate the mysql 'bin' directory which is"
	echo "the directory containing the programs 'mysqladmin' and 'mysql'"
	echo
	
	while true; do
		echo "Please enter the mysql 'bin' directory: "
		read MYSQLDIR
		if [ -x "$MYSQLDIR/mysqladmin" ]; then
			break
		else
			echo "Directory $MYSQLDIR does not have 'mysqladmin'."
		fi
	done
fi

if [ "$DBHOST" = "localhost" ]; then
	CREATECMD="$MYSQLDIR/mysqladmin -P $DBPORT $ADMSTR create"
	DROPCMD="$MYSQLDIR/mysqladmin -f -P $DBPORT $ADMSTR drop"
	SQLCMD="$MYSQLDIR/mysql -P $DBPORT $ADMSTR"
	RELOADCMD="$MYSQLDIR/mysqladmin -P $DBPORT $ADMSTR reload"
else
	CREATECMD="$MYSQLDIR/mysqladmin -h $DBHOST -P $DBPORT $ADMSTR create"
	DROPCMD="$MYSQLDIR/mysqladmin -f -h $DBHOST -P $DBPORT $ADMSTR drop"
	SQLCMD="$MYSQLDIR/mysql -h $DBHOST -P $DBPORT $ADMSTR"
	RELOADCMD="$MYSQLDIR/mysqladmin -h $DBHOST -P $DBPORT $ADMSTR reload"
fi

COUNT=1
					
while true
do
        eval DB=$`echo DB$COUNT`
        CREATE="$CREATECMD $DB"
        POPULATE="$SQLCMD $DB < $DBPATH/$DB.sql"
        echo $CREATE
        OK=`$CREATE`
	RES=$?
        echo $OK
	if [ $RES = 0 ]; then
#               for MySQL 3.23 + , no success message is displayed, just check the return value
                echo $POPULATE
                eval $POPULATE
        elif [ "$OK" = "Database \"$DB\" created." ] || [ "$OK" = "" ]; then
                echo $POPULATE
                eval $POPULATE
	elif [ "$OK" = "mysqladmin: connect to server at '$DBHOST' failed" ]; then
		echo "Connection to database failed. Check to make sure the mysql daemon is running. You may need to start it using the command: mysql.server start"
		exit 1
	elif [ "$OK" = "error: 'Access denied for user:" ]; then
		echo "Unable to create the database. Please check the following:1) Make sure that you are user 'root' 2) You have provided the mysql admin password, if you have set one."  
		exit 1
	elif [ "$OK" = "error: 'Can't create database '$DB'. Database exists'" ]; then
		echo "The database '$DB' already exists. If you are upgrading from a previous version of WebPlus please run the patch."
	else
		echo "Unable to create the database. There may be a problem with your MySQL configuration. Please consult the HOWTO_DATABASE file for possible causes."
		exit 1
	fi

	if [ "$COUNT" -lt "$NUMDB" ]; then
                COUNT=`expr $COUNT + 1`
	else
		break
	fi
done

# write a sql script to set up the needed permissions on the database
# and then run it
cat >perm.sql <<ENDOFSQL
insert into user (host,user,password)
       values('$WPHOST','$DBUSER',password('$DBPASS'));
insert into db
        (host,db,user,Select_priv,Insert_priv,Update_priv,Delete_priv,
        Create_priv,Drop_priv)
        values('$WPHOST','$DB1','$DBUSER','Y','Y','Y','Y','Y','Y');
ENDOFSQL

if [ "$NUMDB" -eq 2 ]; then

cat >>perm.sql <<ENDOFSQL
insert into db
        (host,db,user,Select_priv,Insert_priv,Update_priv,Delete_priv,
        Create_priv,Drop_priv)
        values('$WPHOST','$DB2','$DBUSER','Y','Y','Y','Y','Y','Y');
ENDOFSQL


fi


GRANT="$SQLCMD mysql < perm.sql"
echo $GRANT
eval $GRANT
#command to force mysql to reload new permissions
echo $RELOADCMD
eval $RELOADCMD
#Clean up
rm -f perm.sql

######
# Add entries to uninstall script 
######
if [ "$NUMDB" = 1 ]; then
cat >>$FUNINST <<ENDOFSQL
echo 
echo "This UNINSTALL script can drop the Web+ Shop database, $DB1."
echo "Please type 'yes' to confirm or anything else to skip: "
read ans
if [ "\$ans" = "yes" ] || [ "\$ans" = "YES" ]; then
	DROPCMD="$MYSQLDIR/mysqladmin -f -P $DBPORT $ADMSTR drop $DB1"
	echo \$DROPCMD
	OK=\`\$DROPCMD\`
	echo "\$OK"
	echo "delete from db where db='$DB1' and user = '$DBUSER' and host = '$WPHOST';" > tmp.sql
	echo "delete from user where user = '$DBUSER' and host = '$WPHOST';" >> tmp.sql
	DELCMD="$SQLCMD mysql < tmp.sql"
	echo \$DELCMD
	eval "\$DELCMD"
fi
ENDOFSQL

else

cat >>$FUNINST <<ENDOFSQL
echo 
echo "This UNINSTALL script can drop Web+Shop databases $DB1 and $DB2."
echo "Please type 'yes' to confirm or anything else to skip: "
read ans
if [ "\$ans" = "yes" ] || [ "\$ans" = "YES" ]; then
	DROPCMD="$MYSQLDIR/mysqladmin -f -P $DBPORT $ADMSTR drop $DB1"
	echo \$DROPCMD
	OK=\`\$DROPCMD\`
	echo "\$OK"
	DROPCMD="$MYSQLDIR/mysqladmin -f -P $DBPORT $ADMSTR drop $DB2"
	echo \$DROPCMD
	OK=\`\$DROPCMD\`
	echo "\$OK"
	echo "delete from db where db='$DB1' and user = '$DBUSER' and host = '$WPHOST';" > tmp.sql
	echo "delete from db where db='$DB2' and user = '$DBUSER' and host = '$WPHOST';" >> tmp.sql
	echo "delete from user where user = '$DBUSER' and host = '$WPHOST';" >> tmp.sql
	DELCMD="$SQLCMD mysql < tmp.sql"
	echo \$DELCMD
	eval "\$DELCMD"
fi
ENDOFSQL

fi

echo ok>db_okay

exit

