#!/bin/sh
##############################################################################
# FILE: editconf.sh
#
# Version 2.0
#
# DESCRIPTION: This sript is used to add Web+Shop configs to webpsvr.conf 
#
# Copyright (c) 2000 TalentSoft. ALL RIGHTS RESERVED
#
#
# MAINTENANCE LOG
#
#
##############################################################################



##
# if editconf_sh.okay exists then delete it
##

if [ -f ./editconf_sh.okay ]
then
     rm -r ./editconf_sh.okay > /dev/null
fi


##
# Check that the correct parameters are passed
##

if [ $# -ne 9 ]
then
     	echo "    Wrong number of parameters passed to editconf.sh"
        echo "    Usage : editconf.sh p1 p2 p3 p4 p5 p6 p7 p8 p9 p10 p11"
	echo "    Parameters : "
	echo "			p1	--- 	Web+ Configuration File "
	echo " 			p2	---	WebpShop Store html dir" 
	echo "			p3	---	Database Type"
	echo "			p4	---	WebpShop Database User"
	echo "			p5	---	WebpShop Database Password"
	echo "			p6	---     Database Host Name"
	echo "			p7	---	Database Port Number"
	echo "			p8	---	WebpShop script dir"
	echo "			p9	---	WebpShop File IO passwd"
	exit
elif [ ! -f $1 ]
then
     echo "    Configuration File $1 not found"
     exit
elif [  ! -d $2 -o ! -d $8 ]
then
      	echo  "    One or more of the required parameters is/are "
      	echo  "    not directory(ies)."
	echo  "    Web+ Home Directory   	$1"
	echo  "	   WebpShop Store Directory	$2"
	echo  "    WebpShop Script Directory    $8"
        exit	
elif [ -z "$9" ]
then 
        echo "    File IO password can not be null "
	exit
fi	

CONFFILE=$1
NEWFILE=$1.new
OLDFILE=$1.old
cp -rp $CONFFILE $NEWFILE
cp -rp $NEWFILE $OLDFILE 


WS_STOREDIR=$2
DBTYPE=$3
DBUSER=$4
DBPASS=$5
DBHOST=$6
DBPORT=$7
SCRIPTPATH=$8
FILEIO_PASSWD=$9
WEBPSHOP_LOGICAL_PATH="\/webpshop"
STORE_LOGICAL_PATH="\/webpshopHTML"
DBNAME2="webpshop"
DBSRCNAME="webpshop"


OS=`uname -s`
ECHO=echo
if [ "$OS" = "SunOS" ]; then
	ECHO="/usr/ucb/echo"
fi



SED_SCRIPTPATH=`$ECHO $SCRIPTPATH |   sed 's/\//\\\\\//g'`
SED_WS_STOREDIR=`$ECHO $WS_STOREDIR | sed 's/\//\\\\\//g'`

##
#
# Check for [template] section
#
##

if [ ` cat $NEWFILE | grep -i "LastTemplate=" | wc -l ` -gt 0 ]
then
      OLD_LASTTEMP=`cat $NEWFILE | grep -i "LastTemplate=" | head -1 | cut -f2 -d"="` 
      NEW_LASTTEMP_1=`expr $OLD_LASTTEMP + 1 `
      NEW_LASTTEMP_2=`expr $OLD_LASTTEMP + 2 `
      sed "s/LastTemplate=${OLD_LASTTEMP}/;webpshop template setup \\
TmpLogicalPath${NEW_LASTTEMP_1}=${WEBPSHOP_LOGICAL_PATH} \\
TmpPhysicalPath${NEW_LASTTEMP_1}=${SED_SCRIPTPATH} \\
TmpLogicalPath${NEW_LASTTEMP_2}=${STORE_LOGICAL_PATH} \\
TmpPhysicalPath${NEW_LASTTEMP_2}=${SED_WS_STOREDIR} \\
LastTemplate=${NEW_LASTTEMP_2}/" $NEWFILE  > $OLDFILE
       cp -rp $OLDFILE $NEWFILE

else
    $ECHO "[template]" >> $NEWFILE
    $ECHO ";webpshop template setup" >> $NEWFILE
    $ECHO "TmpLogicalPath1=${WEBPSHOP_LOGICAL_PATH}" | sed 's/\///'| cat  >> $NEWFILE
    $ECHO "TmpPhysicalPath1=${SCRIPTPATH}" >> $NEWFILE
    $ECHO "TmpLogicalPath2=${STORE_LOGICAL_PATH}" | sed 's/\///'| cat  >> $NEWFILE
    $ECHO "TmpPhysicalPath2=${WS_STOREDIR}" >> $NEWFILE
    $ECHO "LastTemplate=2" >> $NEWFILE
fi


###
#
# Check for [FILE IO] section
#
###


if [ ` cat $NEWFILE | grep -i "LastFile=" | wc -l ` -gt 0 ]
then
      OLD_LASTFILE=`cat $NEWFILE | grep -i "LastFile=" | head -1 | cut -f2 -d"="` 
      NEW_LASTFILE_1=`expr $OLD_LASTFILE + 1 `
      NEW_LASTFILE_2=`expr $OLD_LASTFILE + 2 `
      sed "s/LastFile=${OLD_LASTFILE}/;webpshop file io setup \\
FileIOLogicalPath${NEW_LASTFILE_1}=${WEBPSHOP_LOGICAL_PATH} \\
FileIOPhysicalPath${NEW_LASTFILE_1}=${SED_SCRIPTPATH}  \\
FileRead${NEW_LASTFILE_1}=1 \\
FileWrite${NEW_LASTFILE_1}=1  \\
FileReadPassword${NEW_LASTFILE_1}=${FILEIO_PASSWD} \\
FileWritePassword${NEW_LASTFILE_1}=${FILEIO_PASSWD} \\
FileIOLogicalPath${NEW_LASTFILE_2}=${STORE_LOGICAL_PATH} \\
FileIOPhysicalPath${NEW_LASTFILE_2}=${SED_WS_STOREDIR} \\
FileRead${NEW_LASTFILE_2}=1 \\
FileWrite${NEW_LASTFILE_2}=1 \\
FileReadPassword${NEW_LASTFILE_2}=${FILEIO_PASSWD} \\
FileWritePassword${NEW_LASTFILE_2}=${FILEIO_PASSWD} \\
LastFile=${NEW_LASTFILE_2}/" $NEWFILE > $OLDFILE
       cp -rp $OLDFILE $NEWFILE
else
    $ECHO "[FILE IO]" >> $NEWFILE
    $ECHO ";webpshop file io  setup" >> $NEWFILE
    $ECHO "FileIOLogicalPath1=${WEBPSHOP_LOGICAL_PATH}"  | sed 's/\///'| cat >> $NEWFILE
    $ECHO "FileIOPhysicalPath1=${SCRIPTPATH}" >> $NEWFILE
    $ECHO "FileRead1=1" >> $NEWFILE
    $ECHO "FileWrite1=1" >> $NEWFILE
    $ECHO "FileReadPassword1=${FILEIO_PASSWD}" >> $NEWFILE
    $ECHO "FileWritePassword1=${FILEIO_PASSWD}" >> $NEWFILE
    $ECHO "FileIOLogicalPath2=${STORE_LOGICAL_PATH}"  | sed 's/\///'| cat >> $NEWFILE
    $ECHO "FileIOPhysicalPath2=${WS_STOREDIR}" >> $NEWFILE
    $ECHO "FileRead2=1" >> $NEWFILE
    $ECHO "FileWrite2=1" >> $NEWFILE
    $ECHO "FileReadPassword2=${FILEIO_PASSWD}" >> $NEWFILE
    $ECHO "FileWritePassword2=${FILEIO_PASSWD}" >> $NEWFILE
    $ECHO "LastFile=2" >> $NEWFILE
fi


###
#
# Check for [ODBC] section
#
###

if [ ` cat $NEWFILE | grep -i "^LastODBC=" | wc -l ` -gt 0 ]
then
      OLD_LASTODBC=`cat $NEWFILE | grep -i "^LastODBC=" | head -1 | cut -f2 -d"="` 
      NEW_LASTODBC=`expr $OLD_LASTODBC + 1 `
      sed "s/^LastODBC=${OLD_LASTODBC}/;webpshop odbc io setup \\
SQLDataSource${NEW_LASTODBC}=webpshop \\
DataSourceType${NEW_LASTODBC}=${DBTYPE} \\
Database${NEW_LASTODBC}=webpshop \\
Host${NEW_LASTODBC}=${DBHOST} \\
SQL_Select${NEW_LASTODBC}=1 \\
SQL_Insert${NEW_LASTODBC}=1 \\
SQL_Update${NEW_LASTODBC}=1 \\
SQL_Delete${NEW_LASTODBC}=1 \\
SQL_SP${NEW_LASTODBC}=1 \\
SQLUserID${NEW_LASTODBC}=${DBUSER} \\
SQLPassword${NEW_LASTODBC}=${DBPASS} \\
Port${NEW_LASTODBC}=${DBPORT} \\
LastODBC=${NEW_LASTODBC}/" $NEWFILE > $OLDFILE
       cp -rp $OLDFILE $NEWFILE
else
    $ECHO "[ODBC]" >> $NEWFILE
    $ECHO ";webpshop odbc  setup" >> $NEWFILE
    $ECHO "SQLDataSource1=webpshop" >> $NEWFILE
    $ECHO "DataSourceType1=${TYPE}" >> $NEWFILE
    $ECHO "Database1=webpshop" >> $NEWFILE
    $ECHO "Host1=$DBHOST" >> $NEWFILE
    $ECHO "SQL_Select1=1" >> $NEWFILE
    $ECHO "SQL_Insert=1" >> $NEWFILE
    $ECHO "SQL_Update=1" >> $NEWFILE
    $ECHO "SQL_Delete=1" >> $NEWFILE
    $ECHO "SQL_SP1=1" >> $NEWFILE
    $ECHO "SQLUserID1=$DBUSER" >> $NEWFILE
    $ECHO "SQLPassword1=$DBPASS" >> $NEWFILE
    $ECHO "Port1=$DBPORT" >> $NEWFILE
    $ECHO "LastODBC=1" >> $NEWFILE
fi

if [ ! -s  $NEWFILE ]
then
    $ECHO 
    $ECHO "    There appears to be an error in this script, editconf.sh"
    $ECHO "    Please, kindly inform talentsoft support about this."
else
     cp -rp $NEWFILE $CONFFILE
     $ECHO > editconf_sh.okay
fi
rm $NEWFILE 2>&-
rm $OLDFILE 2>&-
