#!/bin/sh
############################################################
# FILE NAME: INSTALL_SHOP
#
# VERSION: 2.1
#
# Copyright (c) 2003 Webplus, Inc. All rights reserved.
#
# DESCRIPTION: 
# This script is used to install Web+ Shop5.0.0
#
# MAINTENANCE LOG:
# 12/13/2001
# Slight changes on the script from Web+Shop4.6.1r5
# 4/2/2003
# Slight changes on the script from Web+Shop4.7.2
#
############################################################
TECH_SUPPORT="Webplus Tech Support http://www.talentsoft.com"
FPRODID="productid"
THISPROD="webpshop"
THISPROD_BLANKSPACE=
STARTINDEX=1
THISPROD_LEN=`expr $THISPROD : '.*'`
while [ $STARTINDEX -le $THISPROD_LEN ]
do
   THISPROD_BLANKSPACE="*"$THISPROD_BLANKSPACE
   STARTINDEX=`expr $STARTINDEX + 1`
done
ABORTED="$THISPROD installation  aborted !!!"
THISPROD_VER="5.0.0"
DBS_SUPPORTED="\"MySQL 3.22.39 or higher\""
DEFWEBP="/webplus"
APPLIC_SRV="Web+"
APPLIC_SRV_VER="4.6"
MALL_ADMIN_USER_NAME="malladmin"
MALL_ADMIN_USER_PASWD="password"
STORE_ADMIN_USER_NAME="storeadmin"
STORE_ADMIN_USER_PASWD="password"
APPLIC_DB_UNINSTALL="uninstall_$THISPROD"
STORE_LOGICAL_PATH="/webpshopHTML"
APPLIC_LOGICAL_PATH="/webpshop"
OS=`uname -s`
ECHO=echo
if [ "$OS" = "SunOS" ]
then
	ECHO="/usr/ucb/echo"
fi

###################
#
# this function prompts the user to quit the installation or not
# it accepts as input a variable in the format YES_FORMAT 
#
# syntax : confirm_abort var_1
# 	   var_1 in YES_FORMAT
#
##################

confirm_abort()
{
   if [ $# -eq 0 ]
   then
      $ECHO "    confirm_abort : Wrong syntax."
      $ECHO "		         confirm_abort var1"
      $ECHO "                    var1 in YES|yes|y|Y"
   else
   	case $1 in
	 QUIT|quit|Q|q )
					$ECHO
                                     	$ECHO -n "    Do you really want to quit (Y/N)? [N]:  "
                                        read ans
					$ECHO
                                        case $ans in
                                        	YES|yes|y|Y )
								abort_install;
                                        esac;;
	esac
   fi
}

############
#
# This is a generic function to abort the installation process
# it displays the arguments, if any , passed to it 
#
# syntax : abort_install [[-n] mesg_1 , ... , [-n] mesg_n]
#          mesg_n -- Message to be displayed
#          n      -- Don't force a new line after displaying mess_n
#
###########

abort_install()
{
  $ECHO
  while [ $# -gt 0 ]
  do
   
     # displays the first argument, if any, and  shift the
     # next argument to the left, if any
   
     DISP_WORD=
     USE_SPACE=
     DO_DASHN=

     if [ "$1" = "-n" ]
     then
        while [ $# -gt 0 -a "$1" = "-n" ]
        do
          shift 1
        done      
        DISP_WORD=
        DO_DASHN="YES"
        USE_SPACE="YES"
     fi
     if [ "$USE_SPACE" = "YES" ]
     then
          DISP_WORD=$DISP_WORD"    $1"
          USE_SPACE=
     else
          DISP_WORD="$1"
     fi
  
     if [ "$DO_DASHN"="YES" ]
     then
          $ECHO -n "$DISP_WORD "
     else
          $ECHO "$DISP_WORD "
     fi

     shift 1
  done
  $ECHO; $ECHO "    *****"; $ECHO
  $ECHO "    $ABORTED"
  $ECHO;$ECHO "    *****";$ECHO
  exit 1
}
clear

#######
#
# Verify that required installation dir is okay and necessary files okay
#
########
if [ ! -f ./license -o ! -d ./script -o ! -d ./html -o ! -d ./database -o ! -f productid -o  ! -f editconf.sh  -o ! -f ueditconf.sh   ]
then
    abort_install "    One or more required files not found." "    Try and get a complete installation tar ball."
fi

$ECHO    "   *********************************"$THISPROD_BLANKSPACE"*****************"
$ECHO    "   *       WELCOME  TO  $THISPROD INSTALLATION SCRIPT        *" 
$ECHO    "   *********************************"$THISPROD_BLANKSPACE"*****************"
$ECHO;$ECHO;$ECHO
$ECHO "   This script will attempt to install $THISPROD "
$ECHO "   on your $OS machine" 
$ECHO;$ECHO;$ECHO
$ECHO "    In order to succesfully install $THISPROD you need to :"
$ECHO
$ECHO "    1) Have $APPLIC_SRV $APPLIC_SRV_VER or higher installed and running."
$ECHO "    2) Be Logged in as 'root'."
$ECHO "    3) Have installed, with same or higher versions, one or more of the"
$ECHO "       following databases : ( $DBS_SUPPORTED )"
$ECHO;$ECHO;$ECHO
$ECHO "    *** Note *** : You can either purchase or download a bannerware"
$ECHO "                   version of $APPLIC_SRV at http://www.talentsoft.com"
$ECHO;$ECHO
while true
do
      $ECHO -n "    Press the ENTER key to continue or any other key to quit :  "
      read ans
      if [ ! -z "$ans" ]
      then
	  confirm_abort "Q"
      else
        break
      fi
done
 
$ECHO;$ECHO

####
#
# Verify that Web+ is currently running
#
####

# I had to add the OS detection stuff here to get it to work on Solaris
#    jimb
MY_OS=`uname -s`
if [ "$MY_OS" = "SunOS" ]; then
	PS="/usr/ucb/ps"
	PS_OPTION="-ax"
elif [ "$MY_OS" = "Linux" ]; then
	PS="ps"
	PS_OPTION="ax"
elif [ "$MY_OS" = "FreeBSD" ]; then
	PS="ps"
	PS_OPTION="ax"
else
	PS="ps"
	PS_OPTION="-e"
fi
TEMP_RESULT=`$PS $PS_OPTION | grep "webpsvr" | grep -v "grep"`
if [ -z "$TEMP_RESULT" ] 
then

    abort_install "It does not appear that $APPLIC_SRV is running." " "                                                         "Can you please make sure that $APPLIC_SRV is installed and"                                                  "running before continuing with this installation"
fi  

#####
#
# Check if the user is logged in as 'root'
#
#####

if [ "$OS" = "SunOS" ]; then
	ME=`/usr/ucb/whoami`
else
	ME=`whoami`
fi
if [ "${ME}" != "root" ]; then
        abort_install "You have to log in as 'root' to install $THISPROD."
fi

####
#
# Read the license agreement
#
####

while true 
do
    more   ./license
  while true
  do
    $ECHO
    $ECHO -n "    Do you agree with the contents of the license agreement  (Y/N)? [N]:  "
    read ans
    case $ans in
         YES|yes|y|Y ) break;;
         ""|NO|no|N|n   ) $ECHO -n "    Do you want to read the license agreement again (Y/N)? [Y]:  "
                          read second_ans
                          case $second_ans in
                                ""|YES|yes|y|Y ) break;;
                                   *           ) abort_install "-n" "You need to agree with"                                                                  "the contents of the license" "agreement for  you to install $THISPROD";;
                       esac;;
	QUIT|quit|Q|q) confirm_abort $ans ;;
	*	    ) $ECHO "    (Y)es, (N)o or (Q)uit required."
    esac
  done
  case  $ans in
      YES|yes|Y|y ) break;;
  esac
  
done

#####
#
# Get product name,  version and minimum Web+ version
#
#####

if [ ! -f $FPRODID ]; then
       abort_install	 "File $FPRODID is missing from this package."                                                 "Please contact $TECH_SUPPORT."
fi

# Extract product  information 

tmpvar=`cat  $FPRODID`
PRODNAME=`$ECHO "$tmpvar" | cut -d";" -f1`
WSHOP_V=`$ECHO "$tmpvar" | cut -d";" -f2`
MINWP_V=`$ECHO "$tmpvar" | cut -d";" -f3`

# Abort installation if product name not found in product information

if [ "$PRODNAME" != "$THISPROD" ]; then
       abort_install 	 "This install script is used to install $THISPROD."                                                           "But the $FPRODID file indicates $PRODNAME."                                                                  "Please contact $TECH_SUPPORT."
fi

# Abort installation if version number not found in product information


####
#
# Confirm Web+ directory and existence of webp.conf
#
#####


while true
do

        WEBP_DIR=
        # Find out where Web+ is installed

	while [ ! -d "${WEBP_DIR}" ] 
	do
      		$ECHO 
      	      	$ECHO      "    Please enter $APPLIC_SRV home directory "
                $ECHO -n   "    [e.g. $DEFWEBP] or Q to Quit :  " 
      		read WEBP_DIR
      		if [ -z "$WEBP_DIR" ]
		then
			WEBP_DIR="$DEFWEBP"
      		fi

      		case  "${WEBP_DIR}" in  
         		QUIT|quit|q|Q ) confirm_abort $WEBP_DIR ;;
      		esac

  		 if [ ! -d "${WEBP_DIR}" ]
 		 then
			$ECHO -n "    Directory ${WEBP_DIR} does not exist."
                        $ECHO " Please enter another one."
			continue
   		fi

	done

        # Find out if configuration file exists

   	if [ ! -f "${WEBP_DIR}/bin/webpsvr.conf" ]
      	then
		$ECHO  "    Directory ${WEBP_DIR}/bin"
		$ECHO  "    does not have webpsvr.conf file."
		$ECHO  "    Please check and make sure ${WEBP_DIR} is Web+ directory."
		continue
   	else
       		break
   	fi

       # Find out if normalize_cfg file exists
       
       if [ ! -f "${WEBP_DIR}/bin/normalize_cfg" ]
       then
             $abort_install "    Required file , normalize_cfg, not found" "    Please contact Webplus, Inc. for an upgrade of this file"
      fi

done


####
#
# normalize the configuration file 
###

$ECHO -n "    Attempting to normalize configuration file ..."
NORMALIZE_OK="rename ${WEBP_DIR}/bin/~tmp\.0 to ${WEBP_DIR}/bin/webpsvr\.conf"
if [ `${WEBP_DIR}/bin/normalize_cfg ${WEBP_DIR}/bin/webpsvr.conf | grep -i '$NORMALIZE_OK' | wc -l` -eq 1 ]
then
      $ECHO
      abort_install "    Normalization of the configuration file"  "${WEBP_DIR}/bin/webpsvr.conf failed."
else
   $ECHO " Done."
fi



#####
# Get Web+ version and see if Web+Shop is supported
#####

WEBP_V=`grep "Version=" ${WEBP_DIR}/bin/webpsvr.conf`
WEBP_V=`$ECHO "$WEBP_V" | cut -d"=" -f2`
tmpv=`$ECHO $WEBP_V | sed 's/\.//g'`
tmpmv=`$ECHO $MINWP_V | sed 's/\.//g'`
vercheck=`expr $WEBP_V \>= $MINWP_V`
if [ $vercheck = "0" ]; then
	abort_install "    The minimum version of Web+ for Web+Shop is $MINWP_V."
fi



######
# Obtain HTML document root directory from webpsvr.conf
######

$ECHO
$ECHO  "    Checking for the HTML document root directory ..."
tmpvar=`grep "WSHTMLRoot=" ${WEBP_DIR}/bin/webpsvr.conf | grep -v "grep"`
if [ -z "${tmpvar}" ]; then
   abort_instll  "Your HTML document directory cannot be found in" "${WEBP_DIR}/bin/webpsvr.conf."                             "File ${WEBP_DIR}/bin/webpsvr.conf may be corrupted."
fi

HTML_ROOT=`$ECHO $tmpvar | cut -d"=" -f2`

if [ -z "${HTML_ROOT}" ]; then
   abort_install  "Your HTML document directory cannot be found in" "${WEBP_DIR}/bin/webpsvr.conf."                             "File ${WEBP_DIR}/bin/webpsvr.conf may be corrupted."
fi

if [ ! -d "${HTML_ROOT}" ]; then
   abort_install "${HTML_ROOT} specified in " "${WEBP_DIR}/bin/webpsvr.conf does not exist."                                      "Please check and make sure ${WEBP_DIR} is Web+ directory."
else
  $ECHO "    $HTML_ROOT ... Okay"
fi


#####
# Get user account that Web+ server runs as from webpsvr.conf
#####

WEBP_USER=`grep "WebpRunAsUser=" ${WEBP_DIR}/bin/webpsvr.conf | grep -v "grep"`
WEBP_USER=`$ECHO $WEBP_USER | cut -d"=" -f2`

#######################################################
#
#   Initialize default values
#
#####################################################

CF_FILE="$WEBP_DIR/bin/webpsvr.conf"
CF_SDTS="sqldatasource"
CF_PROD="webpshop"
CF_DTS="datasourcetype"
CF_DB_UID="SQLUserId"
CF_DB_PASWD="SQLPassword"
CF_HOST="Host"
CF_PORT="Port"
CF_WSPPATH="TmpPhysicalPath"
CF_WSLPATH="TmpLogicalPath"
DBUSER=
DBHOST=
DBPASS=
DBTYPE="MySQL"
DBPORT=
DEFWSPATH=
DTS_NAME=
DEFSTRPATH=
APPLIC_UNINSTALL="${WEBP_DIR}/UNINSTALL_${THISPROD}"

###
#
# Verify that no Previous Version of Web+Shop is running
###
 while [ `cat ${CF_FILE} | grep -i 'tmplogicalpath' | grep -i '${STORE_LOGICAL_PATH}'    | wc -l ` -gt 0 -o    `cat ${CF_FILE} | grep -i 'tmplogicalpath'    | grep -i '${APPLIC_LOGICAL_PATH}' | wc -l ` -gt 0 -o           `cat ${CF_FILE} | grep -i 'fileiologicalpath' | grep -i '${STORE_LOGICAL_PATH}'    | wc -l ` -gt 0 -o         `cat ${CF_FILE} | grep -i 'fileiologicalpath' | grep -i '${APPLIC_LOGICAL_PATH}' | wc -l ` -gt 0 -o                         `cat ${CF_FILE} | grep -i 'sqldatasource'     | grep -i 'webpshop' | wc -l ` -gt 0 ]
do
       $ECHO
       $ECHO    "    A previous copy/version of $THISPROD is still configured as installed."
       $ECHO    "    Do you want to Manually de-install this copy/version (recommended) or "
       $ECHO -n "    you want this installation to Automatically de-install it (M/A)? [M] :  " 
       read ans
       if [ -z "$ans" ] 
       then
            ans=M
       fi
       case $ans in
           QUIT|quit|Q|q|M|m ) abort_install "De-Install existing $THISPROD completely before installing a new one"
                         ;;
           A|a )
                      while true
                      do
                                  $ECHO
		                  $ECHO    "    Do you want this installation to de-install the existing"
				  $ECHO -n "    copy/version (Y/N)? [N] :  "
                                  read ans
                                  if  [ -z $ans ]
                                  then
                                       ans=Y
                                  fi
                                  case $ans in
                                       YES|yes|Y|y)
                                             $ECHO  "    Attempting to de-install existing $THISPROD ..." 
                                             ./ueditconf.sh $WEBP_DIR ${WEBP_DIR}/webpadmin 
                                             break
                                                    ;;
                                       NO|no|N|n ) abort_install                                                                                                 "    De-Install existing $THISPROD completely before installing a new one"
                                                    ;;
                                                 *)  
				                      $ECHO
				                      $ECHO "    Yes or No Required. Please try again."
                                                      continue
			                        	;;
			          esac
                        done
			;;
		* )  $ECHO
		     $ECHO "   M(anual) or A(utomatic) Required. Please try again."
                     continue
		     ;;
	esac
  done

#####
# Prompt For Where To Install Web+Shop
#####

v_everything_ok="FALSE"
while [ "$v_everything_ok" = "FALSE" ] 
do
      v_everything_ok="TRUE"
      WEBPSHOP_DIR="$WEBP_DIR/script/$THISPROD"
      $ECHO 
      $ECHO  "    Please enter $THISPROD home directory"
      $ECHO -n "    [e.g. $WEBPSHOP_DIR] or Q to Quit :  " 
      read WEBPSHOP_DIR

	#changed for solaris
      if [ -z "$WEBPSHOP_DIR" ]
      then
           WEBPSHOP_DIR="$WEBP_DIR/script/$THISPROD"
      fi

      case  $WEBPSHOP_DIR in 
         QUIT|quit|q|Q ) 
			confirm_abort $WEBPSHOP_DIR
                        ;;
      esac
   if [  -d "${WEBPSHOP_DIR}" ]
   then
        $ECHO
	$ECHO    "    Directory ${WEBPSHOP_DIR} exists already."
        $ECHO
 	$ECHO -n "    Do you want to overwrite it (Y/N)? [N]:  "
        read ans
        case $ans in
         YES|yes|Y|y ) 
		     rm -r $WEBPSHOP_DIR
		      ;;
	 QUIT|quit|q|Q )
			confirm_abort $ans
			;;
         *           )  v_everything_ok="FALSE" 
		       ;; 
        esac 
   fi
   if [  -d "$HTML_ROOT/$THISPROD" ]
   then
        $ECHO
	$ECHO    "    $THISPROD needs to install some files in $HTML_ROOT/$THISPROD"
	$ECHO    "    and directory $HTML_ROOT/$THISPROD exists already."
        $ECHO
        $ECHO -n "    Do you want to overwrite it (Y/N)? [N]:  "
        read ans
        case $ans in
         YES|yes|Y|y ) 
		     rm -r $HTML_ROOT/$THISPROD
                        ;;
	 QUIT|quit|q|Q )
			confirm_abort $ans
			;;
         *             ) v_everything_ok="FALSE" 
                         ;;
        esac 
   fi
done


##################################################
#
#  Get The Read/Write Passord
#
##################################################

while true
do
                $ECHO
  		$ECHO "    In order to ensure that other web+ scripts on your server are "
		$ECHO "    not able to access your web+shop.conf file or image directories"
		$ECHO "    unless you want to allow it, you need to specify a read/write"
		$ECHO "    password that will be verified for such a request to be processed."
		$ECHO
		$ECHO
		$ECHO    "    Please enter a password for $APPLIC_SRV"
		$ECHO -n "    to use for $THISPROD's file IO access :  "
		read filepassword
 		case $filepassword in
                  	QUIT|quit|q|Q )
					confirm_abort $filepassword 
					;;
			"")	
					$ECHO "    You need to specify a password"
					;;
		[0-9a-zA-Z]*)
				$ECHO
				$ECHO -n "    You have entered $filepassword, is this correct (Y/N)? [N]:  "
				read ans
 				case $ans in
				   YES|yes|y|Y ) 
						break
						;;
				   QUIT|quit|Q|q ) 
						   confirm_abort $ans
						   ;; 
				esac
					;;
                * )
                        $ECHO
			$ECHO "    Only alphnumeric characters allowed"
                        $ECHO "    Please try again."
		esac
done

#  Get Database Information


$ECHO
$ECHO "    *** Database setup information ***"
$ECHO
$ECHO "    In order to install the database objects for $THISPROD,"
$ECHO "    you need to :"
$ECHO 
$ECHO "    1) have one of $DBS_SUPPORTED installed"
$ECHO "    2) know the port the database is using. "
$ECHO "       e.g. the default port for MySQL is 3306 and PostgreSQL is 5432."
$ECHO "    3) know the  hostname if the database is on a remote machine."
$ECHO "    4) know the  DBA  user_name/password "
$ECHO;$ECHO
while true
do
       $ECHO -n "    Press the ENTER key to continue or any other key to quit :  "
       read ans
       if [ ! -z "$ans" ]
       then
            confirm_abort "Q"
       else
         break
       fi 
done

#######
# Database configuration: 
#
#     Web+shop  sample database username and password
#
#######

DBUSER=$THISPROD
DBPASS=$THISPROD


while true
do

    # Local or remote

	while true
     	do
     		$ECHO
     		$ECHO "    Please specify where your database is."
		$ECHO
     		$ECHO "    [L] Local machine"
     		$ECHO "    [R] Remote machine"
     		$ECHO "    [Q] Quit"
     		$ECHO
     		$ECHO -n "    Please make your choice [L]:  "
     		read DBHOW
		if [ -z "$DBHOW" ]
                then
                    DBHOW=L
		fi
     		case "$DBHOW" in
             		L|l|local|LOCAL     )
						DBHOW="local"
						DBHOST="localhost"
						WPHOST="localhost"
						break ;;
     			R|r|remote|REMOTE   )
						DBHOW="remote"
						WPHOST=`hostname`
						break ;;
     			QUIT|quit|q|Q	    )
						confirm_abort $DBHOW ;;
     			*                   )
        					$ECHO
        					$ECHO "    Please enter 'L', 'R' or 'Q'."
						continue ;;
        	esac
	done

	# If remote, what's the host name

	if [ "$DBHOW" = "remote" ]
       	then
	    while true
            do
    		$ECHO  "    Enter the hostname that hosts your database "
                $ECHO -n "    or enter Q to quit :  "          
    		read DBHOST
    		case  "$DBHOST" in
                  	QUIT|quit|q|Q ) confirm_abort $DBHOST 
					;; 
                        ""           )
					continue
					;;                          
			*	     )
					break
					;;
		esac
	    done

	else
   	    DBHOST='localhost'
            break
	fi
done
########
# For Now, Only mySQL is Supported with Web+Shop
########
while true
do
     DBTYPE="M"
     $ECHO
     $ECHO "    Please choose the database you are using."
     $ECHO
     $ECHO "    [M] MySQL 3.22.39 or higher"
     $ECHO "    [quit]"
     $ECHO
     $ECHO -n "    Enter a choice [$DBTYPE] :  "
     read DBTYPE
     case "$DBTYPE" in 
     	       ""|m|M)
         			DBTYPE="MySQL"
	 			DEFPORT="3306"
         			break
	   			;;

     		QUIT|quit|q|Q)
				confirm_abort $DBTYPE
				;;
     esac
done 
# end of database type

######
# Ask for database running port
######

while true
do
	DBPORT=$DEFPORT
	$ECHO -n "    Enter the port number that $DBTYPE uses [$DBPORT] :  "
	read DBPORT
	# change for solaris
        if [ -z "$DBPORT" ]
        then
            DBPORT=$DEFPORT
        fi
	case $DBPORT in
 	 QUIT|quit|q|Q )
				confirm_abort $DBPORT
				;;	
	   [0-9]* )
			$ECHO
			$ECHO "    If you have set sysadmin password, please enter the sysadmin user name"
			$ECHO "    and password. Otherwise, press ENTER to skip the following question."
			$ECHO
			$ECHO -n "    Please enter $DBTYPE sysadmin user name :  "
			read ADMUSER
			case $ADMUSER in
  				QUIT|quit|q|Q )
						confirm_abort $ADMUSER
						;;
				*)
						if [ -z "$ADMUSER" ]
  						then
							ADMUSER="none"
							ADMPASS="none"
						else
							$ECHO -n "    Enter $DBTYPE sysadmin password :  "
							read ADMPASS
							case $ADMPASS in
							   QUIT|quit|q|Q )
									  confirm_abort $ADMPASS
									  ;;
								""	 )
									  $ADMPASS="none"
							        	  ;;
							esac
						fi
            
						if [ $ADMUSER != "none" ]
            then
						    SHOW_ADMUSER=$ADMUSER
						else
						    SHOW_ADMUSER=
						fi
					  
						if [ $ADMPASS != "none" ]
						then
						   SHOW_ADMPASS=$ADMPASS
						else
						   SHOW_ADMPASS=
						fi	
					$ECHO
					$ECHO "    ********** V E R I F I C A T I O N ***********"
					$ECHO "    You have made the following choices about database:"
					$ECHO 
					$ECHO "    Database on local or remote machine: $DBHOW"
						if [ "$DBHOW" = 'remote' ]
						then
							$ECHO "    Database hostname: $DBHOST"
						fi
						$ECHO "    Database product: $DBTYPE"
						$ECHO "    $DBTYPE uses port number: $DBPORT"
						$ECHO "    Sysadmin user name: $SHOW_ADMUSER"
						$ECHO "    Sysadmin password: $SHOW_ADMPASS"
					$ECHO
					$ECHO
					$ECHO -n "    Press ENTER to confirm or anything else to change :  "
					read ans 
				        case $ans in
					 QUIT|quit|Q|q ) 		
							confirm_abort $ans
							;;
					esac
                                        if [ -z "$ans" ]
				 	then
						break
					fi
					;;
		    esac
		    ;;
             *     )
                    $ECHO
		    $ECHO "    Numeric input required. Please try again"
                    $ECHO
		    ;;
	esac

done 

			
$ECHO
$ECHO "    Starting $THISPROD installation ..."
$ECHO



####
# Create Web+Shop Home Directory
####
        $ECHO
	$ECHO  "    Creating directory $WEBPSHOP_DIR ..."
	mkdir $WEBPSHOP_DIR

SCRIPT_DIR="${WEBPSHOP_DIR}/script"
	$ECHO
        $ECHO  "    Copying $THISPROD scripts to $SCRIPT_DIR ..."
        cp -rp ./script $WEBPSHOP_DIR
###
# Update webp_global.wml
###
     $ECHO "    Checking for $SCRIPT_DIR/webp_global.wml ..." 
     if [ ! -f $SCRIPT_DIR/webp_global.wml ]
     then
         abort_install "    Required file, $SCRIPT_DIR/webp_global.wml" "not found".
     else
        $ECHO "<webset #readpasswd#=""$filepassword"">" >> $SCRIPT_DIR/webp_global.wml
        $ECHO "<webset #writepasswd#=""$filepassword"">" >> $SCRIPT_DIR/webp_global.wml
        $ECHO "    $SCRIPT_DIR/webp_global.wml successfully updated"
     fi


SHOPHTML_DIR="${HTML_ROOT}/${THISPROD}"
	$ECHO
	$ECHO  "    Creating directory $SHOPHTML_DIR ..."
	mkdir $SHOPHTML_DIR
        $ECHO  "    Copying $THISPROD html documents to ${SHOPHTML_DIR} ..."
        cp -rp ./html/* $SHOPHTML_DIR



#####
# Take care of permissions and ownership
#####
chown -R ${WEBP_USER} ${WEBPSHOP_DIR}
chown -R ${WEBP_USER} ${SHOPHTML_DIR}
chown ${WEBP_USER} ${WEBP_DIR}/bin/webpsvr.conf
chmod -R 744 ${WEBPSHOP_DIR}
chmod u+r ${SCRIPT_DIR}/webpshop.conf


#####
# Create database
#####

$ECHO
$ECHO "    Installing $DBTYPE database for $THISPROD ..."

if [ "$DBTYPE" = "MySQL" ]; then
	SCRIPT="install_DB_mysql.sh"
	DBPATH="./database/mysql"
else
	SCRIPT="install_DB_postgres.sh"
	DBPATH="./database/postgresql"
fi

if [ ! -f $DBPATH/$SCRIPT ]
then
   abort_install " Database installation script $DBPATH/$SCRIPT not found "
else
	# removed $DBPATH prefix to db_okay for solaris?
      EXESCRIPT="$DBPATH/$SCRIPT $DBPATH $APPLIC_DB_UNINSTALL $DBUSER $DBPASS $DBPORT $WPHOST $ADMUSER $ADMPASS $DBHOST 1 $THISPROD"
      if [ -f db_okay ] 
      then
           rm -r db_okay > /dev/null 
      fi
      eval $EXESCRIPT
      if [ ! -f db_okay ]
      then
          abort_install " Database creation for $THISPROD for $DBTYPE not okay"
      else
           rm -r db_okay > /dev/null 2>&-
      fi 
      
fi 

#####
# Update webpsvr.conf
#####

CONF_TMP=webpsvr.tmp
cp -p $CF_FILE $CONF_TMP

$ECHO 
$ECHO "    Updating webpsvr.conf file ..."
$ECHO
$ECHO "    If you encounter any problems, you can recover the original from"
$ECHO "    ${CF_FILE}.ssave    i.e. "
$ECHO "    cp $CF_FILE.ssave ${CF_FILE}"
$ECHO

   if [ -r "/var/lib/mysql/mysql.sock" ] && [ "$DBTYPE" = "MySQL" ]; then
        DBPORT="\/var\/lib\/mysql\/mysql.sock"
	 elif [ -r "/var/run/mysqld/mysqld.sock" ] && [ "$DBTYPE" = "MySQL" ]; then
				DBPORT="\/var\/run\/mysqld\/mysqld.sock"
   fi

if [ -f ./editconf_sh.okay ] 
then
    rm -r ./editconf_sh.okay > /dev/null
fi 

# $ECHO "sh editconf.sh $CONF_TMP $SHOPHTML_DIR $DBTYPE $DBUSER $DBPASS $DBHOST $DBPORT $SCRIPT_DIR $filepassword "
sh editconf.sh $CONF_TMP $SHOPHTML_DIR $DBTYPE $DBUSER $DBPASS $DBHOST $DBPORT $SCRIPT_DIR $filepassword  

if [ ! -f ./editconf_sh.okay ]
then
     if [ -f ./editconf_sh.okay ]
     then
          rm -r ./editconf_sh.okay
          rm -r $CONF_TMP
     fi
     abort_install "    Modification of Configuration File $CF_FILE not successful."   
else
     cp -p $CONF_TMP $CF_FILE
     rm -r ./editconf_sh.okay
     rm -r $CONF_TMP
     $ECHO "    Successfully Updated configuration file, $CF_FILE"
fi
 
$ECHO


######
# Generate uninstall script $APPLIC_UNINSTALL
######

$ECHO
$ECHO "    Generating an 'UNINSTALL' script in ${APPLIC_UNINSTALL} ..."
cat  > ${APPLIC_UNINSTALL} << END_OF_UNINSTALL
#!/bin/sh


############
#
# This is a generic function to abort the installation process
# it displays the arguments, if any , passed to it 
#
# syntax : abort_install [[-n] mesg_1 , ... , [-n] mesg_n]
#          mesg_n -- Message to be displayed
#          n      -- Don't force a new line after displaying mess_n
#
###########

abort_install()
{
  while [ $# -gt 0 ]
  do

     # displays the first argument, if any, and  shift the
     # next argument to the left, if any

     NO_BREAK=
     if [ "$1" = "-n" ]
     then
        while [ $# -gt 0 -a "$1" = "-n" ]
        do
          shift 1
        done      
        NO_BREAK="-n"
     fi
     $ECHO $NO_BREAK "    $1"
     shift 1
  done
  $ECHO; $ECHO "    *****"; $ECHO
  $ECHO "    $ABORTED"
  $ECHO;$ECHO "    *****";$ECHO
  exit 1
}
$ECHO
$ECHO "This script will remove all $THISPROD files from your system!"
echo "Please type 'yes' to proceed. Type anything else to abort. "
read ans
case "\$ans" in
        yes|YES|Yes|y|Y)
        ;;

	*)	
	$ECHO "You have chosen to abort uninstall."
	exit 1
esac


#####
#
# Check if the user is logged in as 'root'
#
#####

OS=\`uname -s\`
if [ "\$OS" = "SunOS" ]; then
	ME=\`/usr/ucb/whoami\`
else
	ME=\`whoami\`
fi
if [ "\${ME}" != "root" ]; then
        abort_install "You have to log in as 'root' to uninstall $THISPROD."
fi

$ECHO "Removing $THISPROD directories and files...."
cd /

rm -rf $WEBPSHOP_DIR
rm -rf $SHOPHTML_DIR

END_OF_UNINSTALL

###
#
# To remove the settings of webpshop in the configuration file,
# cat  ueditconf.sh into the UNISTALL script 
#
##
SED_WEBP_DIR=`$ECHO ${WEBP_DIR} |sed 's/\//\\\\\//g'`
sed "s/\$1/${SED_WEBP_DIR}/" ueditconf.sh > ueditconf_sh.tmp
sed "s/\$2/${SED_WEBP_DIR}\/webpadmin/" ueditconf_sh.tmp > ueditconf_sh.tmp.tmp 
cat  ueditconf_sh.tmp.tmp >> ${APPLIC_UNINSTALL} 
rm -r ueditconf_sh.tmp
rm -r ueditconf_sh.tmp.tmp

#####
#
#  cat the script to remove the DATABASE into the UNINSTALL script
#
#####

cat -u ${APPLIC_DB_UNINSTALL} >> ${APPLIC_UNINSTALL} 
rm -r ${APPLIC_DB_UNINSTALL} 2>&-

###
#
# Include the script to restart the webpsrv in the UNINSTALL script
#
###

cat -u >> ${APPLIC_UNINSTALL} << END_OF_RESTART

#####
# Restart Web+ to force new webpsvr.conf value to be read
#####

RESTARTCMD="${WEBP_DIR}/webpadmin restart"
$ECHO "    Atempting to restart $APPLIC_SRV, this may take a while, please wait ..."
if [ \`\$RESTARTCMD | grep -i "started" | wc -l \` -gt 0 ] 
then
	$ECHO "    $APPLIC_SRV successfully started"
else
	$ECHO "    $APPLIC_SRV does not appear to have been succesfully stopped and started"
	$ECHO "    You may need to manually restart $APPLIC_SRV."
fi 

END_OF_RESTART


chmod 711 ${APPLIC_UNINSTALL}
$ECHO "    Uninstall script generation done."

#####
# Restart Web+ to force new webpsvr.conf value to be read
#####
CF_TEMP=${CF_FILE}.temp
CF_OLD=${CF_FILE}.old
rm -r $CF_TEMP 2>&-
rm -r $CF_OLD 2>&-
cp -p $CF_FILE $CF_TEMP
cp -p $CF_TEMP $CF_OLD
if [ ! `cat ${CF_TEMP} | grep -i "[^.]*ThrowExceptionForWebpError=1" | wc -l ` -gt 0 ]
     then
            sed "s/\[Admin\]/\[Admin\] \\
ThrowExceptionForWebpError=1/" $CF_TEMP > $CF_OLD
fi

if [ ! -s $CF_OLD ]
then
    $ECHO
    $ECHO "    Error ascertaining ThrowExceptionForWebpError setting."
    $ECHO "    Try and manually verify this setting and set it to 1 (one) "
    $ECHO "    if not set already. Set it under the [Admin] section of the"
    $ECHO "    configuration file $CF_FILE "
else
    cp -p $CF_OLD $CF_FILE
fi

rm -r $CF_TEMP 2>&-
rm -r $CF_OLD 2>&-
          
         

RESTARTCMD="${WEBP_DIR}/webpadmin restart"
$ECHO "    Atempting to restart $APPLIC_SRV, this may take a while, please wait ..."
if [ ` $RESTARTCMD | grep -i "started" | wc -l ` -gt 0 ] 
then
	$ECHO "    $APPLIC_SRV successfully started"
else
	$ECHO "    $APPLIC_SRV does not appear to have been succesfully stopped and started"
	$ECHO "    You may need to manually restart $APPLIC_SRV."
fi 




$ECHO 
$ECHO "    -----------------------------------------------------"
$ECHO

$ECHO "    To enter the customer's view of the $THISPROD default store,"
$ECHO "    open a web browser to:"
$ECHO "    http://localhost/cgi-bin/webplus.cgi?script=/$THISPROD/store.wml"

$ECHO 
$ECHO "    To login to the administrative interface of $THISPROD,"
$ECHO "    open a web browser to:"
$ECHO "    http://localhost/cgi-bin/webplus.cgi?script=/$THISPROD/admin/login.wml"
$ECHO 

$ECHO "    The default administrative passwords are:"
$ECHO
$ECHO "    For Mall Administration:"
$ECHO "    username: $MALL_ADMIN_USER_NAME"
$ECHO "    password: $MALL_ADMIN_USER_PASSWD"
$ECHO 
$ECHO "    For Store Administration (of default store):"
$ECHO "    username: $STORE_ADMIN_USER_NAME"
$ECHO "    password: $STORE_ADMIN_USER_PASWD"
$ECHO 
$ECHO "    -----------------------------------------------------"
$ECHO
$ECHO "    $THISPROD $THISPROD_VERSION installation is complete."
$ECHO "    Thank you for using $THISPROD."

exit 0

