#!/bin/sh
###############################################################################
# FILE: ueditconf.sh
#
# Version 2.0
#
# DESCRIPTION: This sript is used to remove  Web+Shop configs to webpsvr.conf
#
# Copyright (c) 2000 TalentSoft. ALL RIGHTS RESERVED
#
#
# MAINTENANCE LOG
#
#
##############################################################################
ECHO=echo
OS=`uname -s`
if [ "$OS" = "SunOS" ]; then
	ECHO="/usr/ucb/echo"
fi	

APPLIC_LOGICAL_PATH="/webpshop"
STORE_LOGICAL_PATH="/webpshopHTML"
CONFPATH=$1
CONFFILE="$CONFPATH/bin/webpsvr.conf"
WEBPADMIN=$2
APPLIC_SRV="Web+"
SCRIPTPATH="$CONFPATH/script/webpshop"
SAVEFILE="$CONFFILE.usave"
NEWFILE="$CONFFILE.new"
OLDFILE="$CONFFILE.old"
if [ ! -f $CONFFILE  ]
then
    $ECHO " Configuration File ,$CONFFILE, not found" 
    exit
elif [ ! -f $WEBPADMIN ]
then
    $ECHO " Application server ,$WEBPADMIN, not found"
   exit
else
   cp $CONFFILE $SAVEFILE
fi

#
# Copy Configuration file to new file
#

cp -rf $CONFFILE $OLDFILE
cp -rf $CONFFILE $NEWFILE
if [ ! -s $OLDFILE -o ! -s $NEWFILE ]
then
     $ECHO " Can not make a copy of the configuration file."
     exit
fi

###
# Check for existence of webpshop in [template] section of  configuration file
# it is assumed that paths are labeled "TmpLogicalPath..." in that format                
###

# Find the occurrence of TmpLogicalPath=${APPLIC_LOGICAL_PATH} and delete it and its PhysicalPath and
# decrement the LastTemplate value by 1

	if  [ `grep  "TmpLogicalPath[0-9]*=${APPLIC_LOGICAL_PATH}"  $OLDFILE | wc -l` -gt 0 ]
	then
                NUMBER_PREFIX=`grep  "TmpLogicalPath[0-9]*=${APPLIC_LOGICAL_PATH}" $OLDFILE|head -1| cut -f1 -d"="`
                NUMBER_PREFIX=`$ECHO $NUMBER_PREFIX|sed s/TmpLogicalPath//g`
                sed "/TmpLogicalPath${NUMBER_PREFIX}=/d" $OLDFILE > $NEWFILE 
                sed "/TmpPhysicalPath${NUMBER_PREFIX}=/d" $NEWFILE > $OLDFILE
                OLD_LASTTEMPLATE=`grep -i 'LastTemplate=[0-9]*' $OLDFILE | cut -f2 -d"="` 
                NEW_LASTTEMPLATE=` expr $OLD_LASTTEMPLATE - 1 `
                sed "s/LastTemplate=${OLD_LASTTEMPLATE}/LastTemplate=${NEW_LASTTEMPLATE}/" $OLDFILE > $NEWFILE
                cp -rf $NEWFILE $OLDFILE
        fi
      
# Find the occurrence of TmpLogicalPath=/$STORE_LOGICAL_PATH and delete it and its PhysicalPath and
# decrement the LastTemplate value by 1

	if  [ `grep  "TmpLogicalPath[0-9]*=${STORE_LOGICAL_PATH}"  $OLDFILE | wc -l` -gt 0 ]
	then
                NUMBER_PREFIX=`grep  "TmpLogicalPath[0-9]*=${STORE_LOGICAL_PATH}" $OLDFILE|head -1| cut -f1 -d"="`
                NUMBER_PREFIX=`$ECHO $NUMBER_PREFIX|sed s/TmpLogicalPath//g`
                sed "/TmpLogicalPath${NUMBER_PREFIX}=/d" $OLDFILE > $NEWFILE 
                sed "/TmpPhysicalPath${NUMBER_PREFIX}=/d" $NEWFILE > $OLDFILE
                OLD_LASTTEMPLATE=`grep -i 'LastTemplate=[0-9]*' $OLDFILE | cut -f2 -d"="` 
                NEW_LASTTEMPLATE=` expr $OLD_LASTTEMPLATE - 1 `
                sed "s/LastTemplate=${OLD_LASTTEMPLATE}/LastTemplate=${NEW_LASTTEMPLATE}/" $OLDFILE > $NEWFILE
                cp -rf $NEWFILE $OLDFILE
          fi



# Find the occurrence of FileIOLogicalPath=${APPLIC_LOGICAL_PATH} and delete it and its PhysicalPath and
# decrement the LastFile value by 1

	if  [ `grep  "FileIOLogicalPath[0-9]*=${APPLIC_LOGICAL_PATH}"  $OLDFILE | wc -l` -gt 0 ]
	then
                NUMBER_PREFIX=`grep  "FileIOLogicalPath[0-9]*=${APPLIC_LOGICAL_PATH}" $OLDFILE|head -1| cut -f1 -d"="`
                NUMBER_PREFIX=`$ECHO $NUMBER_PREFIX|sed s/FileIOLogicalPath//g`
                sed "/FileIOLogicalPath${NUMBER_PREFIX}=/d" $OLDFILE > $NEWFILE 
                sed "/FileIOPhysicalPath${NUMBER_PREFIX}=/d" $NEWFILE > $OLDFILE
                sed "/FileRead${NUMBER_PREFIX}=/d" $OLDFILE > $NEWFILE
                sed "/FileWrite${NUMBER_PREFIX}=/d" $NEWFILE > $OLDFILE
                sed "/FileReadPassword${NUMBER_PREFIX}=/d" $OLDFILE > $NEWFILE
                sed "/FileWritePassword${NUMBER_PREFIX}=/d" $NEWFILE > $OLDFILE
                OLD_LASTFILE=`grep -i 'LastFile=[0-9]*' $OLDFILE | cut -f2 -d"="` 
                NEW_LASTFILE=` expr $OLD_LASTFILE - 1 `
                sed "s/LastFile=${OLD_LASTFILE}/LastFile=${NEW_LASTFILE}/" $OLDFILE > $NEWFILE
                cp -rf $NEWFILE $OLDFILE
        fi

        
# Find the occurrence of FileIOLogicalPath=${STORE_LOGICAL_PATH} and delete it and its PhysicalPath and
# decrement the LastFile value by 1

	if  [ `grep  "FileIOLogicalPath[0-9]*=${STORE_LOGICAL_PATH}"  $OLDFILE | wc -l` -gt 0 ]
	then
                NUMBER_PREFIX=`grep  "FileIOLogicalPath[0-9]*=${STORE_LOGICAL_PATH}" $OLDFILE|head -1| cut -f1 -d"="`
                NUMBER_PREFIX=`$ECHO $NUMBER_PREFIX|sed s/FileIOLogicalPath//g`
                sed "/FileIOLogicalPath${NUMBER_PREFIX}=/d" $OLDFILE > $NEWFILE 
                sed "/FileIOPhysicalPath${NUMBER_PREFIX}=/d" $NEWFILE > $OLDFILE
                sed "/FileRead${NUMBER_PREFIX}=/d" $OLDFILE > $NEWFILE
                sed "/FileWrite${NUMBER_PREFIX}=/d" $NEWFILE > $OLDFILE
                sed "/FileReadPassword${NUMBER_PREFIX}=/d" $OLDFILE > $NEWFILE
                sed "/FileWritePassword${NUMBER_PREFIX}=/d" $NEWFILE > $OLDFILE
                OLD_LASTFILE=`grep -i 'LastFile=[0-9]*' $OLDFILE | cut -f2 -d"="` 
                NEW_LASTFILE=` expr $OLD_LASTFILE - 1 `
                sed "s/LastFile=${OLD_LASTFILE}/LastFile=${NEW_LASTFILE}/" $OLDFILE > $NEWFILE
                cp -rf $NEWFILE $OLDFILE
        fi


# Find the occurrence of SQLDataSource=/webpshop and delete it and its PhysicalPath and
# decrement the LastTemplate value by 1

	if  [ `grep  'SQLDataSource[0-9]*=webpshop'  $OLDFILE | wc -l` -gt 0 ]
	then
                NUMBER_PREFIX=`grep  'SQLDataSource[0-9]*=webpshop' $OLDFILE|head -1| cut -f1 -d"="`
                NUMBER_PREFIX=`$ECHO $NUMBER_PREFIX|sed s/SQLDataSource//g`
                sed "/SQLDataSource${NUMBER_PREFIX}=/d" $OLDFILE > $NEWFILE 
                sed "/SQL_Select${NUMBER_PREFIX}=/d" 	$NEWFILE > $OLDFILE
                sed "/SQL_Insert${NUMBER_PREFIX}=/d" 	$OLDFILE > $NEWFILE
                sed "/SQL_Update${NUMBER_PREFIX}=/d" 	$NEWFILE > $OLDFILE
                sed "/SQL_Delete${NUMBER_PREFIX}=/d" 	$OLDFILE > $NEWFILE
                sed "/SQL_SP${NUMBER_PREFIX}=/d" 	$NEWFILE > $OLDFILE
                sed "/SQLUser_ID${NUMBER_PREFIX}=/d" 	$OLDFILE > $NEWFILE
                sed "/DataSourceType${NUMBER_PREFIX}=/d" $NEWFILE > $OLDFILE
                sed "/Database${NUMBER_PREFIX}=/d" 	$OLDFILE > $NEWFILE
                sed "/Host${NUMBER_PREFIX}=/d" 	$NEWFILE > $OLDFILE
                sed "/Port${NUMBER_PREFIX}=/d" 	$OLDFILE > $NEWFILE
                sed "/SQLPassword${NUMBER_PREFIX}=/d" 	$NEWFILE > $OLDFILE
                sed "/DriverDll${NUMBER_PREFIX}=/d" 	$OLDFILE > $NEWFILE
                cp $NEWFILE $OLDFILE
                OLD_LASTODBC=`grep -i '^LastODBC=[0-9]*' $OLDFILE | head -1 | cut -f2 -d"="` 
                NEW_LASTODBC=`expr $OLD_LASTODBC - 1 `
                sed "s/LastODBC=${OLD_LASTODBC}/LastODBC=${NEW_LASTODBC}/" $OLDFILE > $NEWFILE 
                cp -rf $NEWFILE $OLDFILE
        fi

###
## Remove any line with any reference to webpshop
##
##
sed '/webpshop/d' $OLDFILE > $NEWFILE
sed '/Web+Shop/d' $NEWFILE > $OLDFILE

if [ -s $OLDFILE ]
then
	cp $OLDFILE $CONFFILE
	#####
	# Restart Web+ to force new webpsvr.conf value to be read
	#####
	$ECHO "    Atempting to restart $APPLIC_SRV, this may take a while, please wait ..."
	if  [ ` ${WEBPADMIN} restart  | grep -i "started" | wc -l ` -gt 0 ] 
	then
		$ECHO "    $APPLIC_SRV successfully started"
	else
		$ECHO "    $APPLIC_SRV does not appear to have been succesfully stopped and started"
		$ECHO "    You may need to manually restart $APPLIC_SRV."
	fi 
else
       $ECHO
       $ECHO "    There appears to be an error in this script, ueditconf.sh."
       $ECHO "    Kindly inform talentsoft support about this"
fi

