#!/bin/sh
###############################################################################
# FILE: install_DB_postgres.sh
#
# Version 2.0
#
# DESCRIPTION: This script is used to create postgreSQL database
#
# Copyright (c) 2000 TalentSoft. ALL RIGHTS RESERVED
#
#
# MAINTENANCE LOG
#
#
###############################################################################


if [ "$#" -lt 10 ]; then
   echo
   echo "Usage: $0 <dbpath> <uninstfile> <dbuser> <dbpass> <dbport> <wphost> <admuser> <admpass> <dbhost> <db cnt> <db1> \[<db2>\]"
   exit 1
fi

DBPATH=$1
shift
FUNINST=$1
shift
DBUSER=$1
shift
DBPASS=$1
shift
DBPORT=$1
shift
WPHOST=$1
shift
ADMUSER=$1
shift
ADMPASS=$1
shift
DBHOST=$1
shift
NUMDB=$1
shift
DB1=$1
if [ "$NUMDB" -eq 2 ]; then
	shift
	DB2=$1
fi

if [ "$ADMUSER" = "none" ]; then
	ADMUSER="postgres"
fi

MY_OS=`uname -s`
if [ "$MY_OS" = "FreeBSD" ] || [ "$MY_OS" = "SunOS" ] 
then
	ADMSTR1="su - $ADMUSER -c"
	ADMSTR="su  $ADMUSER -c"
	else
	ADMSTR1="su - $ADMUSER -c"
	ADMSTR="su $ADMUSER -s /bin/sh -c"
fi
# guess where the postgres directory is

if [ -x "/usr/local/pgsql/bin/psql" ]; then 
	POSTGRES_BIN_DIR="/usr/local/pgsql/bin"
	POSTGRES_LIB_DIR="/usr/local/pgsql/lib"
elif [ -x "/usr/bin/psql" ]; then
	POSTGRES_BIN_DIR="/usr/bin"
	POSTGRES_LIB_DIR="/usr/lib/pgsql"
fi

if [ -z "$POSTGRES_BIN_DIR" ]; then
	echo
	echo "I could not locate the POSTGRESQL 'bin' directory which is"
	echo "the directory containing the programs 'psql', 'createuser' and 'createdb'"
	echo
	
	while true; do
		echo -n "Please enter the POSTGRESQL 'bin' directory: "
		read POSTGRES_BIN_DIR
		if [ -x "$POSTGRES_BIN_DIR/psql" ]; then
			break
		else
			echo "Directory $POSTGRES_BIN_DIR does not have 'psql'."
		fi
	done
fi

# export the postgres bin path
EXPORT_PATH="PATH=\$PATH:$POSTGRES_BIN_DIR; export PATH;"

# export the postgres lib path
EXPORT_LDPATH="LD_LIBRARY_PATH=$POSTGRES_LIB_DIR; export LD_LIBRARY_PATH;"

# create the Unix user "webplus" 
echo "Creating Unix user $DBUSER..."
if [ "$MY_OS" = "FreeBSD" ];
then
	eval "/usr/sbin/pw useradd $DBUSER -s '' -d ''"	
else
	eval "/usr/sbin/useradd $DBUSER"
fi

if [ "$DBHOST" = "localhost" ]; then
        CREATEUSER="createuser -p $DBPORT -i 999 -d -u"
        CREATEDB="createdb -p $DBPORT"
        SQLCMD="psql -p $DBPORT -q"
        DROPDB="destroydb -p $DBPORT $DB1"
        DROPUSER="destroyuser -p $DBPORT $DBUSER"
else
        CREATEUSER="createuser -h $DBHOST -p $DBPORT -i 999 -d -u"
        CREATEDB="createdb -h $DBHOST -p $DBPORT"
        SQLCMD="psql -h $DBHOST -p $DBPORT -q"
        DROPDB="destroydb -h $DBHOST -p $DBPORT $DB1"
        DROPUSER="destroyuser -h $DBHOST -p $DBPORT $DBUSER"
fi

# create a postgres user "webplus"
echo "Creating postgres user $DBUSER..."
eval "$ADMSTR1 '$EXPORT_PATH $EXPORT_LDPATH $CREATEUSER $DBUSER'"

COUNT=1
					
while true
do
        eval DB=$`echo DB$COUNT`
	
	echo "Creating database $DB..."
        CREATE="$CREATEDB $DB"
        eval "$ADMSTR1 '$EXPORT_PATH $EXPORT_LDPATH $CREATE'" 
        

       	echo "Populating database $DB..."
       	POPULATE="$SQLCMD $DB < $DBPATH/$DB.sql"
       	eval "$ADMSTR '$EXPORT_PATH $EXPORT_LDPATH $POPULATE'"

	if [ "$COUNT" -lt "$NUMDB" ]; then
                COUNT=`expr $COUNT + 1`
	else
		break
	fi
done


######
# Add entries to uninstall script 
######
if [ "$NUMDB" = 1 ]; then
cat >>$FUNINST <<ENDOFSQL
echo 
echo "This UNINSTALL script can drop Web+ sample table $DB1."
echo -n "Please type 'yes' to confirm or anything else to skip: "
read ans
if [ "\$ans" = "yes" ] || [ "\$ans" = "YES" ]; then
	echo "Dropping database $DB1..."
	eval "$ADMSTR1 '$EXPORT_PATH $DROPDB'"
        
	echo "Dropping user $DBUSER..."
        eval "$ADMSTR1 '$EXPORT_PATH $DROPUSER'"

	# delete the Unix user 
	MY_OS=`uname -s`
	if [ "\$MY_OS" = "FreeBSD" ]
	then
	        eval "/usr/sbin/pw userdel $DBUSER"
	else
	        eval "/usr/sbin/userdel $DBUSER"
	fi

fi
ENDOFSQL

else

cat >>$FUNINST <<ENDOFSQL
echo 
echo "This UNINSTALL script can drop Web+Shop tables $DB1 and $DB2."
echo -n "Please type 'yes' to confirm or anything else to skip: "
read ans
if [ "\$ans" = "yes" ] || [ "\$ans" = "YES" ]; then
	DROPCMD="$POSTGRESQLDIR/destroydb -P $DBPORT $ADMSTR drop $DB1"
	echo \$DROPCMD
	OK=\`\$DROPCMD\`
	echo "su postgres -c '\$OK'"
	DROPCMD="$POSTGRESQLDIR/destroydb -P $DBPORT $ADMSTR drop $DB2"
	echo \$DROPCMD
	OK=\`\$DROPCMD\`
	echo "su postgres -c '\$OK'"
fi
ENDOFSQL

fi

exit

