typedef void* HWEBPQUERY;
typedef void* HWEBPROW;
typedef struct _HWEBP {
	void *object;
	int (* GetLengthOfVarValue) (void *object, char *varName);
	int (* GetVarValue) (void *object, char *varName, char *value, int sizeOfvalue);
	int (* SetVarValue) (void *object, char *varName, char *value);
	int (* GetLengthOfParamValue) (void *object, char *paramName);
	int (* GetParamValue) (void *object, char *paramName, char *value, int sizeOfvalue);
	int (* SetParamValue) (void *object, char *paramName, char *value);
    int (* SendHttpText) (void *object, char *text);
	int (* SendHttpData) (void *object, char *Data, int bytesOfData);

	HWEBPQUERY (* CreateQuery) (void *object, char *QueryName, int NumberOfFields);
	HWEBPROW (* CreateNewRow) (HWEBPQUERY qhandle);
	int (* SetFieldName) (HWEBPQUERY qhandle, int column, char *name);
	int (* SetCellValue) (HWEBPROW rowhandle, int column, char *value);
	int (* SetQueryString) (HWEBPQUERY qhandle, char *QueryString);
	int (* SetQueryTime)(HWEBPQUERY qhandle, long milliseconds);
	void (*EnterGuardedSection)(void *object);
	void (*LeaveGuardedSection)(void *object);
} HWEBP;

#define webpGetLengthOfVarValue(pwebpEnv,varName)	(pwebpEnv->GetLengthOfVarValue(pwebpEnv->object, varName))
#define webpGetVarValue(pwebpEnv,varName, value, sizeOfvalue)	(pwebpEnv->GetVarValue(pwebpEnv->object, varName, value, sizeOfvalue))
#define webpSetVarValue(pwebpEnv,varName, value)	(pwebpEnv->SetVarValue(pwebpEnv->object, varName, value))
#define webpGetLengthOfParamValue(pwebpEnv,paramName)	(pwebpEnv->GetLengthOfParamValue(pwebpEnv->object, paramName))
#define webpGetParamValue(pwebpEnv,paramName, value, sizeOfvalue)	(pwebpEnv->GetParamValue(pwebpEnv->object, paramName, value, sizeOfvalue))
#define webpSetParamValue(pwebpEnv,paramName, value)	(pwebpEnv->SetParamValue(pwebpEnv->object, paramName, value))
#define webpSendHttpData(pwebpEnv, Data, bytesOfData)	(pwebpEnv->SendHttpData(pwebpEnv->object, Data, bytesOfData))
#define webpSendHttpText(pwebpEnv, text)	(pwebpEnv->SendHttpText(pwebpEnv->object, text))

#define webpCreateQuery(pwebpEnv, queryName, numberOfFields)	(pwebpEnv->CreateQuery(pwebpEnv->object, queryName, numberOfFields))
#define webpCreateNewRow(pwebpEnv, qhandle)	(pwebpEnv->CreateNewRow(qhandle))
#define webpSetFieldName(pwebpEnv, qhandle, column, name)	(pwebpEnv->SetFieldName(qhandle, column, name))
#define webpSetCellValue(pwebpEnv, rowhandle, column, value)	(pwebpEnv->SetCellValue(rowhandle, column, value))
#define webpSetQueryString(pwebpEnv, qhandle, queryString)	(pwebpEnv->SetQueryString(qhandle, queryString))
#define webpSetQueryTime(pwebpEnv, qhandle, milliseconds)	(pwebpEnv->SetQueryTime(qhandle, milliseconds))

#define webpEnterGuardedSection(pwebpEnv) (pwebpEnv->EnterGuardedSection(pwebpEnv->object))
#define webpLeaveGuardedSection(pwebpEnv) (pwebpEnv->LeaveGuardedSection(pwebpEnv->object))

#define _WIN32_
#ifdef _WIN32_
#ifdef __cplusplus
#define WEBPLUS_PUBLIC extern "C" __declspec(dllexport)
#else
#define WEBPLUS_PUBLIC __declspec(dllexport)
#endif
#else
#ifdef __cplusplus
#define WEBPLUS_PUBLIC extern "C"
#else
#define WEBPLUS_PUBLIC
#endif
#endif