/* atob: version 4.0
 * stream filter to change printable ascii from "btoa" back into 8 bit bytes
 * if bad chars, or Csums do not match: exit(1) [and NO output]
 *
 *  Paul Rutter		Joe Orost
 *  philabs!per		petsd!joe
 *
 *  This version PC-specific - MSC/TC compatible
 *  rj berry bellevue wa 1/21/89 
 *  CS 73407,3152  uucp ...uw-beaver!tikal!ole!ray
 */
/* TAB 4 */

#include <stdio.h>
#include <fcntl.h>
#include <io.h>
#include <stdlib.h>
#include <string.h>

#ifdef TURBO
#include <dir.h>
#endif

char vers[]="[RJB 1/21/89]";

char tmp_name[40];
unsigned long Ceor = 0;
unsigned long Csum = 0;
unsigned long Crot = 0;
unsigned long word = 0;
int bcount=0;

union	{
	unsigned long word;
	unsigned char uchar[4];
	} ublock;


fatal(char * msg) {
	fprintf(stderr, "atob: ERROR: %s\n", msg);
	exit(1);
}

#define DE(c) ((c) - '!')

decode(unsigned char c) 
{
	if (c == 'z') {
		if (bcount != 0)
			fatal("bcount synchronization error");
		else {
			byteout(0);
			byteout(0);
			byteout(0);
			byteout(0);
		}
	} 
	else if ((c >= '!') && (c < ('!' + 85))) {
		if (bcount == 0) {
		ublock.word = DE(c);
		++bcount;
		} 
		else if (bcount < 4) {
				ublock.word *= 85;
				ublock.word += DE(c);
				++bcount;
				} 
			  else {
				ublock.word = ublock.word*85 + DE(c);
				byteout(ublock.uchar[3]);
				byteout(ublock.uchar[2]);
				byteout(ublock.uchar[1]);
				byteout(ublock.uchar[0]);
				ublock.word = 0;
				bcount = 0;
			  }
	} 
	else
		fatal("illegal character in input stream");
}

FILE *tmp_file;

byteout(int c)
{
	Ceor ^= c;
	Csum += c;
	Csum += 1;
	if ((Crot & 0x80000000)) {
		Crot <<= 1;
		Crot += 1;
	}
	else
		Crot <<= 1;
	Crot += c;
	if((putc(c, tmp_file))==EOF)
		fatal(strcat("write error on file ", tmp_name));
}

main(int argc, char *argv[])
{
	int c;
	char buf[100];
	char *tmppath;
	unsigned long n1, n2, oeor, osum, orot;

	if (argc != 1) {
		fprintf(stderr,"bad args to %s\n", argv[0]);
		exit(2);
	}

	/* place tmp file in TMP (presumably a ramdisk?) if possible */

	if((tmppath=getenv("TMP"))==NULL)
		if((tmppath=getenv("TMPDIR"))==NULL)
			tmppath="";
	strcpy(tmp_name,strcat(tmppath, mktemp("XXXXXX")));
	
	tmp_file = fopen(tmp_name, "wb+");
	if (tmp_file == NULL)
		fatal(strcat("couldn't open tmp file ", tmp_name));

	/*search for header line*/
	for (;;) {
	if (fgets(buf, sizeof buf, stdin) == NULL)
		fatal("empty input stream");
	if ((strcmp(buf, "xbtoa Begin\n"))==0)
		break;
	}

	while ((c = getchar()) != EOF) {
		if (c == '\n')
			continue;
		else if (c == 'x')
			break;
		else
			decode(c);
	}
	if (scanf("btoa End N %ld %lx E %lx S %lx R %lx\n",
		&n1, &n2, &oeor, &osum, &orot) != 5)
			fatal("scanf failure on sumcheck line");
	if ((n1 != n2) || (oeor != Ceor) || (osum != Csum) || (orot != Crot))
		fatal("sumcheck values don't match");
	else {

    	/*copy OK tmp file to stdout*/;
		setmode(fileno(stdout), O_BINARY);
		rewind(tmp_file);
		while ((c=getc(tmp_file))!=EOF)
			putchar(c);

		fclose(tmp_file);
 		unlink(tmp_name);
	}
	exit(0);
}

