#Makefile.g
#Global include makefile for entire project

DEBUG_YES=1
DEBUG_NO=0
CLIBC_16_FN_CALL_NEARCALL=0
CLIBC_16_FN_CALL_FARCALL=1
CLIBC_16_FN_CALL_FARCALL_SEG_SINGLE=0
CLIBC_16_FN_CALL_FARCALL_SEG_MULTIPLE=1
CLIBC_16_FN_CALL_FARCALL_SEG_UNDEFINED=2
CLIBC_16_EXTERN_PTRS_NO=0
CLIBC_16_EXTERN_PTRS_YES=1

# some general settings

# ===========================================================================
# supported configurable parameters
# ---------------------------------

# ============================================================================
# DIR_C_INCLUDE
#  set to location to copy *.h files into
#  will create directory clibc_16 in this directory
#  may be exactly equal to DIR_ASM_INCLUDE
#  no trailing backslash
DIR_C_INCLUDE=c:\dev\sharedide\include
# ----------------------------------------------------------------------------

# ============================================================================
# DIR_ASM_INCLUDE
#  set to location to copy *.inc files into
#  will create directory clibc_16 in this directory
#  may be exactly equal to DIR_C_INCLUDE
#  no trailing backslash
DIR_ASM_INCLUDE=c:\dev\sharedide\include
# ----------------------------------------------------------------------------

# ============================================================================
# DIR_LIB
#  the directory to copy built libraries into
#  no trailing backslash
DIR_LIB=c:\dev\sharedide\lib
# ----------------------------------------------------------------------------

# ============================================================================
# CLIBC_16_FN_CALL
#    the call type (distance) for each function in the library
#    CLIBC_16_FN_CALL_NEARCALL=0 (Default)
#	Each library member function call is NEAR16.
#	All functions are placed into a single segment, default _TEXT.
#	Do not define CLIBC_16_FN_CALL_FARCALL_SEG.
#    CLIBC_16_FN_CALL_FARCALL=1
#	Each library member function call is FAR16.
#	Must also specify/define CLIBC_16_FN_CALL_FARCALL_SEG.
#CLIBC_16_FN_CALL=0
CLIBC_16_FN_CALL=1
# ----------------------------------------------------------------------------

# ============================================================================
# CLIBC_16_FN_CALL_FARCALL_SEG
#   Determines far call functions segment.
#   Define only if CLIBC_16_FN_CALL==CLIBC_16_FN_CALL_FARCALL.
#   CLIBC_16_FN_CALL_FARCALL_SEG_SINGLE=0 (Default)
#	All the functions are placed into a single segment.
#	CLIBC_16_FUNCTION_SEG_NAME specifies the segment name.
#				   default _CLIBC_16
#   CLIBC_16_FN_CALL_FARCALL_SEG_MULTIPLE=1
#	Each group of functions are placed into their own segment.
#	CLIBC_16_FUNCTION_SEG_NAME specifies the segment base name.
#				   default _CLIBC_16
#   Note: define CLIBC_16_FUNCTION_SEG_NAME only to change default name.
#CLIBC_16_FN_CALL_FARCALL_SEG=0
CLIBC_16_FN_CALL_FARCALL_SEG=1
# ----------------------------------------------------------------------------

# ============================================================================
# CLIBC_16_EXTERN_PTRS
#   CLIBC_16_EXTERN_PTRS_NO=0 (Default)
#	Does not generate pointers to each function.
#	Do not define CLIBC_16_EXTERN_PTRS_SEG_NAME.
#   CLIBC_16_EXTERN_PTRS_YES=1
#	Generates pointers to each function.
#	Places pointers in _DATA segment.
#	Define CLIBC_16_EXTERN_PTRS_SEG_NAME only to change default name.
#   see pointers to functions in documentation
#CLIBC_16_EXTERN_PTRS=0
CLIBC_16_EXTERN_PTRS=1
# ----------------------------------------------------------------------------

# a little more tweeking, if necessary
# ============================================================================
# CLIBC_16_FUNCTION_SEG_NAME
#   Specifies the base name of the functions code segment.
#   Normally, no need to alter default value.
#   Defaults to _TEXT or _CLIBC_16.
#CLIBC_16_FUNCTION_SEG_NAME=_TEXT
#CLIBC_16_FUNCTION_SEG_NAME=_CLIBC_16
# ----------------------------------------------------------------------------

# ============================================================================
# CLIBC_16_EXTERN_PTRS_SEG_NAME
#   Specifies the name of the pointers segment.
#   Any only _DATA or CONST are directly supported.
#   Normally, no need to alter default value.
#   Defaults to _DATA.
#CLIBC_16_EXTERN_PTRS_SEG_NAME=_DATA
#CLIBC_16_EXTERN_PTRS_SEG_NAME=CONST
# ----------------------------------------------------------------------------

# ============================================================================
# end of supported configurable parameters
# ----------------------------------------------------------------------------

# Automatically set defaults, check defined values.
!IFNDEF CLIBC_16_FN_CALL
CLIBC_16_FN_CALL=$(CLIBC_16_FN_CALL_NEARCALL)
!ENDIF

!IFNDEF CLIBC_16_EXTERN_PTRS
CLIBC_16_EXTERN_PTRS=$(CLIBC_16_EXTERN_PTRS_NO)
!ENDIF

!IF $(CLIBC_16_FN_CALL)==$(CLIBC_16_FN_CALL_FARCALL)
!IFNDEF CLIBC_16_FUNCTION_SEG_NAME
CLIBC_16_FUNCTION_SEG_NAME=_CLIBC_16
!ENDIF
!IFNDEF CLIBC_16_FN_CALL_FARCALL_SEG
CLIBC_16_FN_CALL_FARCALL_SEG=$(CLIBC_16_FN_CALL_FARCALL_SEG_SINGLE)
!ELSEIF $(CLIBC_16_FN_CALL_FARCALL_SEG)!=$(CLIBC_16_FN_CALL_FARCALL_SEG_MULTIPLE)
CLIBC_16_FN_CALL_FARCALL_SEG=$(CLIBC_16_FN_CALL_FARCALL_SEG_SINGLE)
!ENDIF
!ELSEIF $(CLIBC_16_FN_CALL)==$(CLIBC_16_FN_CALL_NEARCALL)
!IFDEF CLIBC_16_FN_CALL_FARCALL_SEG
!UNDEF CLIBC_16_FN_CALL_FARCALL_SEG
!MESSAGE Undefined CLIBC_16_FN_CALL_FARCALL_SEG
!ENDIF
!IFNDEF CLIBC_16_FUNCTION_SEG_NAME
CLIBC_16_FUNCTION_SEG_NAME=_TEXT
!ENDIF
!ELSE
!ERROR CLIBC_16_FN_CALL invalid.
!ENDIF

!IF $(CLIBC_16_EXTERN_PTRS)==$(CLIBC_16_EXTERN_PTRS_NO)
!IFDEF CLIBC_16_EXTERN_PTRS_SEG_NAME
!UNDEF CLIBC_16_EXTERN_PTRS_SEG_NAME
!MESSAGE Undefined CLIBC_16_EXTERN_PTRS_SEG_NAME
!ENDIF
!ELSEIF $(CLIBC_16_EXTERN_PTRS)==$(CLIBC_16_EXTERN_PTRS_YES)
!IFNDEF CLIBC_16_EXTERN_PTRS_SEG_NAME
CLIBC_16_EXTERN_PTRS_SEG_NAME=_DATA
!ENDIF
!ELSE
!ERROR CLIBC_16_EXTERN_PTRS Invalid.
!ENDIF

# check on install directories
#!IF EXIST($(DIR_C_INCLUDE)\)!=1
#!ERROR DIR_C_INCLUDE=$(DIR_C_INCLUDE) Does not exist.
#!ENDIF

#!IF EXIST($(DIR_ASM_INCLUDE))==0
#!ERROR DIR_ASM_INCLUDE=$(DIR_ASM_INCLUDE) Does not exist.
#!ENDIF

#!IF EXIST($(DIR_LIB))==0
#!ERROR DIR_LIB=$(DIR_LIB) Does not exist.
#!ENDIF

# rest of global makefile
DIR_C_INCLUDE=$(DIR_C_INCLUDE)\clibc_16
DIR_ASM_INCLUDE=$(DIR_ASM_INCLUDE)\clibc_16

# assembler stuff
# do not place /Fl /Sa /Sc info here
# do not place any dynamic substitution macros inside these macros
ASM=ml.exe
AFLAGS_G  = /I$(DIR_PROJ) /W2 /WX
AFLAGS_D  = /Cx /Zi
AFLAGS_R  = /nologo

# compiler stuff
CC=cl.exe
#mem model SHOULD be irrelevant
!IF $(CLIBC_16_FN_CALL)==$(CLIBC_16_FN_CALL_NEARCALL)
CFLAGS_G=/AS
!ELSE
CFLAGS_G=/AM
!ENDIF

CFLAGS_G=/W2 /G2 /BATCH /Fc
CFLAGS_D=/f- /Od /FPi87 /Zi /Gs
CFLAGS_R=/f- /Ot /Ol /Og /Oe /Oi /Gs
