; isalnum
;   AAA=mis
;   BBB=001
;   F=
;   O=0
; str001.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_isalnum:FN_CALL PTR
p_fn_isalnum P_FN_CALL isalnum
EXTERNDEF C p_fn_fc_isalnum:FN_CALL PTR
p_fn_fc_isalnum P_FN_CALL @isalnum
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;isalnum() - Alphanumeric ('A'-'Z','a'-'z','0'-'9')
;int fn_call isalnum(const int);
; RETURNS:
;   0	    if NOT a alphanumeric character
;   1	    if	   a alphanumeric character
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
isalnum PROC FN_CALL C, num:WORD
    xor ax, ax
    mov bx, [num]
    cmp bl, '0'
    jb @@done
    cmp bl, '9'
    jbe @@yes
    cmp bl, 'A'
    jb @@done
    cmp bl, 'Z'
    jbe @@yes
    cmp bl, 'a'
    jb @@done
    cmp bl, 'z'
    ja @@done
@@yes:
    inc ax
@@done:
    ret
isalnum ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

;isalnum() - Alphanumeric ('A'-'Z','a'-'z','0'-'9')
;int __fastcall fn_call isalnum(const int);
; __fastcall
;   AX	    nchar
; RETURNS:
;   AX
;   0	    if NOT a alphanumeric character
;   1	    if	   a alphanumeric character
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
@isalnum PROC FN_CALL USES bx
    mov bl, al
    xor ax, ax
    cmp bl, '0'
    jb @@done
    cmp bl, '9'
    jbe @@yes
    cmp bl, 'A'
    jb @@done
    cmp bl, 'Z'
    jbe @@yes
    cmp bl, 'a'
    jb @@done
    cmp bl, 'z'
    ja @@done
@@yes:
    inc ax
@@done:
    ret
@isalnum ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS
END
