; isdigit
;   AAA=mis
;   BBB=007
;   F=
;   O=0
; str007.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_isdigit:FN_CALL PTR
p_fn_isdigit P_FN_CALL isdigit
EXTERNDEF C p_fn_fc_isdigit:FN_CALL PTR
p_fn_fc_isdigit P_FN_CALL @isdigit
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF


;isdigit() - Digit ('0'-'9')
;int fn_call isdigit(const int);
; RETURNS:
;   0	    if not a digit
;   1	    if	   a digit
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
isdigit PROC FN_CALL C, num:WORD
    xor ax, ax
    mov bx, num

    cmp bl, '0' ; digit?
    jb @@done
    cmp bl, '9'
    ja @@done
@@yes:
    inc ax
@@done:
    ret
isdigit ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

;isdigit() - Digit ('0'-'9')
;int __fastcall fn_call isdigit(const int);
; __fastcall
;   AX	    num
; RETURNS:
;   AX
;   0	    if not a digit
;   1	    if	   a digit
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
@isdigit PROC FN_CALL USES bx
    mov bx, ax
    xor ax, ax

    cmp bl, '0' ; digit?
    jb @@done
    cmp bl, '9'
    ja @@done
@@yes:
    inc ax
@@done:
    ret
@isdigit ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS
END
