; memset
;   AAA=str
;   BBB=017
;   F=
;   O=
; str017.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_memset:FN_CALL PTR
p_fn_memset P_FN_CALL memset
EXTERNDEF C p_fn_fc_memset:FN_CALL PTR
p_fn_fc_memset P_FN_CALL @memset
EXTERNDEF C p_fn_memset_sss:FN_CALL PTR
p_fn_memset_sss P_FN_CALL memset_sss
EXTERNDEF C p_fn_fc_memset:FN_CALL PTR
p_fn_fc_memset_sss P_FN_CALL @memset_sss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;memset() -- Set memory block
;void __near * fn_call memset(void __near * const, const int, const int);
;GIVEN:
;   p_m 	near pointer, (source) offset from ds
;   chr 	value to set to
;   cnt 	number of bytes to set to chr
;RETURNS:
;   pointer	near pointer, offset from ds (p_m)
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
memset PROC FN_CALL C uses es di, p_m:NEAR16 PTR, chr:WORD, cnt:WORD

	    mov ax, ds
	    mov es, ax

	    mov di, [p_m]	    ;es:DI = block
	    mov cx, [cnt]	     ;CX = count
	    mov ax, [chr]
	    xor ah, ah		     ;al = char

	    rep stos BYTE PTR es:[di]	   ;Set memory

	    mov ax, [p_m]
	    ret
memset ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

;memset() -- Set memory block
;void __near * __fastcall fn_call memset(void __near * const, const int, const int);
; __fastcall
; GIVEN:
;   BX	    p_m, (source) offset from ss
;   AX	    chr
;   DX	    cnt
; RETURNS:
;   AX		near pointer, offset from ds (p_m)
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
@memset PROC FN_CALL USES es si di bx cx dx

	    mov di, bx	    ;es:di = p_m
	    mov cx, dx	     ;cx = count
			    ; ax = char
	    mov dx, ds
	    mov es, dx

	    xor ah, ah	    ;al = char

	    rep stos BYTE PTR es:[di]	   ;Set memory

	    mov ax, bx	; return p_m
	    ret

@memset ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

;memset_sss() -- Set memory block
;void __near * fn_call memset_sss(void __near * const, const int, const int);
;GIVEN:
;   p_m 	near pointer, (source) offset from ss
;   chr 	value to set to
;   cnt 	number of bytes to set to chr
;RETURNS:
;   pointer	near pointer, offset from ss (p_m)
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
memset_sss PROC FN_CALL C uses es di, p_m:NEAR16 PTR, chr:WORD, cnt:WORD

	    mov ax, ss
	    mov es, ax

	    mov di, [p_m]	    ;es:DI = block
	    mov cx, [cnt]	     ;CX = count
	    mov ax, [chr]
	    xor ah, ah		     ;al = char

	    rep stos BYTE PTR es:[di]	   ;Set memory

	    mov ax, [p_m]
	    ret
memset_sss ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

;memset_sss() -- Set memory block
;void __near * __fastcall fn_call memset_sss(void __near * const, const int, const int);
; __fastcall
; GIVEN:
;   BX	    p_m, (source) offset from ss
;   AX	    chr
;   DX	    cnt
;RETURNS:
;   AX		near pointer, offset from ss (p_m)
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
@memset_sss PROC FN_CALL USES es si di bx cx dx

	    mov di, bx	    ;es:di = p_m
	    mov cx, dx	     ;cx = count
			    ; ax = char
	    mov dx, ss
	    mov es, dx

	    xor ah, ah	    ;al = char

	    rep stos BYTE PTR es:[di]	   ;Set memory

	    mov ax, bx	; return p_m
	    ret

@memset_sss ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS
END
