; skiptosr
;   AAA=str
;   BBB=011
;   F=
;   O=
; str011.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_skiptosr:FN_CALL PTR
p_fn_skiptosr P_FN_CALL skiptosr
EXTERNDEF C p_fn_fc_skiptosr:FN_CALL PTR
p_fn_fc_skiptosr P_FN_CALL @skiptosr
EXTERNDEF C p_fn_skiptosr_sss:FN_CALL PTR
p_fn_skiptosr_sss P_FN_CALL skiptosr_sss
EXTERNDEF C p_fn_fc_skiptosr:FN_CALL PTR
p_fn_fc_skiptosr_sss P_FN_CALL @skiptosr_sss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

; skiptosr - skip to white space reverse
; char __near * fn_call skiptosr(const char __near * const);
; GIVEN:
;   p_str	near pointer, (source) offset from ds
; RETURNS: (char __far *)
;   pointer	near pointer, offset from ds
;		to the last white space character in the string
;		to the terminating '\0' if no white space chars in string
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
skiptosr PROC FN_CALL C USES si, p_str:NEAR16 PTR BYTE
    mov si, [p_str] ; ds:[si] = p_str
    xor dx, dx	; dx = 0
    dec dx	; dx = -1

@@luup:
    lods BYTE PTR ds:[si]
    test al, al
    jz @@done
    cmp al, 20h
    je @@space
    cmp al, 09h
    jb @@luup
    cmp al, 0Dh
    ja @@luup
@@space:
    mov dx, si
    jmp @@luup
@@done:
    cmp dx, -1
    je @F
      mov si, dx
@@:
    dec si
    mov ax, si
    ret
skiptosr ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

; skiptosr - skip to white space reverse
; char __near * __fastcall fn_call skiptosr(const char __near * const);
; __fastcall
; GIVEN:
;   BX	    p_str, (source) offset from ds
; RETURNS:
;   AX		near pointer, offset from ds
;		to the last white space character in the string
;		to the terminating '\0' if no white space chars in string
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
@skiptosr PROC FN_CALL USES si dx
    mov si, bx ; ds:[si] = p_str
    xor dx, dx	; dx = 0
    dec dx	; dx = -1

@@luup:
    lods BYTE PTR ds:[si]
    test al, al
    jz @@done
    cmp al, 20h
    je @@space
    cmp al, 09h
    jb @@luup
    cmp al, 0Dh
    ja @@luup
@@space:
    mov dx, si
    jmp @@luup
@@done:
    cmp dx, -1
    je @F
      mov si, dx
@@:
    dec si
    mov ax, si
    ret
@skiptosr ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

; skiptosr_sss - skip to white space reverse
; char __near * fn_call skiptosr_sss(const char __near * const);
; GIVEN:
;   p_str	near pointer, (source) offset from ss
; RETURNS: (char __far *)
;   pointer	near pointer, offset from ss
;		to the last white space character in the string
;		to the terminating '\0' if no white space chars in string
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
skiptosr_sss PROC FN_CALL C USES ds si, p_str:NEAR16 PTR BYTE
    mov ax, ss
    mov ds, ax

    mov si, [p_str] ; ds/ss:[si] = p_str
    xor dx, dx	; dx = 0
    dec dx	; dx = -1

@@luup:
    lods BYTE PTR ds:[si]
    test al, al
    jz @@done
    cmp al, 20h
    je @@space
    cmp al, 09h
    jb @@luup
    cmp al, 0Dh
    ja @@luup
@@space:
    mov dx, si
    jmp @@luup
@@done:
    cmp dx, -1
    je @F
      mov si, dx
@@:
    dec si
    mov ax, si
    ret
skiptosr_sss ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS

; skiptosr_sss - skip to white space reverse
; char __near * __fastcall fn_call skiptosr_sss(const char __near * const);
; __fastcall
; GIVEN:
;   BX	    p_str, (source) offset from ss
; RETURNS:
;   AX		near pointer, offset from ss
;		to the last white space character in the string
;		to the terminating '\0' if no white space chars in string
CLIBC_16_FUNCTION_SEG_NAME SEGMENT
@skiptosr_sss PROC FN_CALL USES ds si dx
    mov ax, ss
    mov ds, ax

    mov si, bx ; ds/ss:[si] = p_str
    xor dx, dx	; dx = 0
    dec dx	; dx = -1

@@luup:
    lods BYTE PTR ds:[si]
    test al, al
    jz @@done
    cmp al, 20h
    je @@space
    cmp al, 09h
    jb @@luup
    cmp al, 0Dh
    ja @@luup
@@space:
    mov dx, si
    jmp @@luup
@@done:
    cmp dx, -1
    je @F
      mov si, dx
@@:
    dec si
    mov ax, si
    ret
@skiptosr_sss ENDP
CLIBC_16_FUNCTION_SEG_NAME ENDS
END
