; @strcpy
;   AAA=str
;   BBB=000
;   F=1
;   O=0
; str00010.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_fc_strcpy:FN_CALL PTR
p_fn_fc_strcpy P_FN_CALL @strcpy
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;strcpy() -- Copies string 2 to string 1, including null term char
;char __near * __fastcall fn_call strcpy(char const __near *, const char __near * const);
; __fastcall
; GIVEN:
;   BX		p_str1, offset from ds
;   AX		p_str2, offset from ds
; RETURNS:
;   AX		p_str1, offset from ds
BEGIN_CODE_SEGMENT <STRING>
@strcpy PROC FN_CALL USES si di es
	    mov di, bx	    ;es/ss:di = p_str1 = destination
	    mov si, ax	    ;ds:si = p_str2 = source

	    mov ax, ds
	    mov es, ax

	    cmp si,di
	    jne @@cont
	    mov ax, di
	    jmp @@exit	    ; they are equal, so done
@@cont:

@@loop:	    lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop
@@done:
	    mov ax, bx
@@exit:
	    ret 		    ;Return AX points to copied string
@strcpy ENDP
END_CODE_SEGMENT <STRING>
END
