; skipsp_sss
;   AAA=str
;   BBB=002
;   F=0
;   O=1
; str00201.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_skipsp_sss:FN_CALL PTR
p_fn_skipsp_sss P_FN_CALL skipsp_sss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

; skipsp_sss - skip white space
; char __near * fn_call skipsp_sss(const char __near * const);
; GIVEN:
;   p_str	near pointer, (source) offset from ss
; RETURNS: (char __near *)
;   pointer	near pointer, (source) offset from ss
;		to the first non white space character in the string
;		if no more non white space characters in the string,
;		   then points to ending 0
; NOTES:
;   see isspace for the definition of a white space character
BEGIN_CODE_SEGMENT <STRING>
skipsp_sss PROC FN_CALL C USES ds si, p_str:NEAR16 PTR BYTE
    mov ax, ss
    mov ds, ax
    mov si, [p_str]
@@luup:
    lods BYTE PTR ds:[si]
    cmp al, 20h
    je @@luup
    cmp al, 09h
    jl @@done
    cmp al, 0Dh
    jbe @@luup
@@done:
    dec si
    mov ax, si
    ret
skipsp_sss ENDP
END_CODE_SEGMENT <STRING>
END
