; @strcat_dss
;   AAA=str
;   BBB=004
;   F=1
;   O=2
; str00412.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_fc_strcat_dss:FN_CALL PTR
p_fn_fc_strcat_dss P_FN_CALL @strcat_dss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;strcat_dss() -- Concatenate strings
; appends string2 to end of string1
;char __near * __fastcall fn_call strcat_dss(char __near * const, const char __near * const);
; __fastcall
; GIVEN:
;   BX	    p_str1, (destination) offset from ss
;   AX	    p_str2, (source) offset from ds
; RETURNS:
;   AX	    p_str1, offset from ss
BEGIN_CODE_SEGMENT <STRING>
@strcat_dss PROC FN_CALL USES es si di cx

	    mov si, ax	; ds:si = p_str2, source
	    mov di, bx	; es:di = p_str1, destination

	    mov ax, ss
	    mov es, ax

	    mov cx, ds
	    cmp ax, cx
	    jne @@cont
	    cmp si, di	    ; equal strings?
	    jne @@cont

	    mov ax, di
	    jmp @@exit


@@cont:
	    ; find end of p_str1
	    xor ax, ax		    ; compare with zero
	    mov cx, ax
	    dec cx		    ; cx = -1

	    repne scas BYTE PTR es:[di]	;check for zero
	    dec di		    ; [es]:di = null of p_str1


@@loop:     lods BYTE PTR ds:[si]   ;Load char
	    stos BYTE PTR es:[di]   ;Store char
	    test al,al		    ;Loop while not zero
	    jnz @@loop

	    mov ax, bx
@@exit:
	    ret
@strcat_dss ENDP
END_CODE_SEGMENT <STRING>
END
