; strlwr_sss
;   AAA=str
;   BBB=012
;   F=0
;   O=1
; str01201.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_strlwr_sss:FN_CALL PTR
p_fn_strlwr_sss P_FN_CALL strlwr_sss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;strlwr_sss() -- Convert string to lowercase
;char __near * fn_call strlwr_sss(char __near * const);
; GIVEN;
;   p_str	near pointer, (source) offset from ss
; RETURNS: (char __near *)
;   pointer	near pointer, offset from ss (p_str)
BEGIN_CODE_SEGMENT <STRING>
strlwr_sss PROC FN_CALL C uses es ds di si, p_str:NEAR16 PTR BYTE

	    mov ax, ss
	    mov ds, ax
	    mov es, ax

	    mov si, [p_str]	    ;ds/ss:si = p_str
	    mov di, si		    ;es/ss:di = p_str

@@loop:	    lodsb BYTE PTR ds:[si]  ;load al with char
	    cmp al,'A'		    ;Check for uppercase
	    jb @F
            cmp al,'Z'
	    ja @F
	    add al,20h		    ;Convert to lowercase
@@:
	    stos BYTE PTR es:[di]
	    test al,al		    ;Check for null
	    jnz @@loop

	    mov ax, [p_str]
	    ret
strlwr_sss ENDP
END_CODE_SEGMENT <STRING>
END
