; @strlwr_sss
;   AAA=str
;   BBB=012
;   F=1
;   O=1
; str01211.asm

.xlist
INCLUDE CLIBC_16.INC
.list

IFDEF CLIBC_16_EXTERN_PTRS
 IF CLIBC_16_EXTERN_PTRS EQ CLIBC_16_EXTERN_PTRS_YES

CLIBC_16_EXTERN_PTRS_SEG_NAME SEGMENT
EXTERNDEF C p_fn_fc_strlwr:FN_CALL PTR
p_fn_fc_strlwr_sss P_FN_CALL @strlwr_sss
CLIBC_16_EXTERN_PTRS_SEG_NAME ENDS

 ENDIF
ENDIF

;strlwr_sss() -- Convert string to lowercase
;char __near * __fastcall fn_call strlwr_sss(char __near * const);
; __fastcall
; GIVEN:
;   BX	    p_str, (source) offset from ss
; RETURNS:
;   AX		near pointer, offset from ss (p_str)
BEGIN_CODE_SEGMENT <STRING>
@strlwr_sss PROC FN_CALL USES ds es si di

	    mov si, bx		    ;ds/ss:si = p_str
	    mov di, si		    ;es/ss:di = p_str
	    mov ax, ss
	    mov ds, ax
	    mov es, ax


@@loop:	    lodsb BYTE PTR ds:[si]  ;load al with char
	    cmp al,'A'		    ;Check for uppercase
	    jb @F
            cmp al,'Z'
	    ja @F
	    add al,20h		    ;Convert to lowercase
@@:
	    stos BYTE PTR es:[di]
	    test al,al		    ;Check for null
	    jnz @@loop

	    mov ax, bx
	    ret
@strlwr_sss ENDP
END_CODE_SEGMENT <STRING>
END
