/**************************************************************
* AFC.C - this program calculates the execution time of the   *
*   AFC -- the average function call.                         *
*                                                             *
* To compile: "cl /Od /Fa /Gs afc.c"                          *
* RHS 9/30/90																  *
**************************************************************/
#include<time.h>
#include<process.h>
#include<stdio.h>
#include<stdlib.h>

void cdecl main(void);

/**************************************************************
* The test functions used to generate an AFC                  *
**************************************************************/
void _cdecl empty1(void)                   {   }
void _cdecl empty11(int x)                 {   }
void _cdecl empty12(int x, int y)          {   }
void _far _cdecl empty1f(void)             {   }
void _far _cdecl empty11f(int x)           {   }
void _far _cdecl empty12f(int x, int y)    {   }

void _pascal empty2(void)                  {   }
void _pascal empty21(int x)                {   }
void _pascal empty22(int x, int y)         {   }
void _far _pascal empty2f(void)            {   }
void _far _pascal empty21f(int x)          {   }
void _far _pascal empty22f(int x, int y)   {   }

void _fastcall empty3(void)                {   }
void _fastcall empty31(int x)              {   }
void _fastcall empty32(int x, int y)       {   }
void _far _fastcall empty3f(void)          {   }
void _far _fastcall empty31f(int x)        {   }
void _far _fastcall empty32f(int x, int y) {   }

#define DEF_ITERATIONS   10000000L

/**************************************************************
* TimeFunc - this macro displays the string 's' and then      *
* calculates the calculates and displays the average          *
* execution time for the function call 'f'.                   *
**************************************************************/
#define TimeFunc(s,f)						\
	printf(s);									\
   iterations = setting;               \
	start = clock();							\
	for ( ; iterations; iterations--)   \
		f;											\
	end = clock();								\
	test = (float)(end-start);				\
   test /= (float)CLK_TCK;             \
	printf("AFC: %04.2f uSec.\n", test*(1E6/setting))


/**************************************************************
* main - calculates the average function call overhead for    *
* each of the specified functions.                            *
**************************************************************/
void _cdecl main(void)
    {
    long start, end = 0L;
    unsigned long iterations, setting = DEF_ITERATIONS;
    float test = (float)0;
    int x, y;

 	 TimeFunc("void _cdecl empty1(void).....................",empty1());
    TimeFunc("void _cdecl empty11(int x)...................",empty11(x));
    TimeFunc("void _cdecl empty12(int x, int y)............",empty12(x,y));
    TimeFunc("void _far _cdecl empty1f(void)...............",empty1f());
    TimeFunc("void _far _cdecl empty11f(int x).............",empty11f(x));
    TimeFunc("void _far _cdecl _empty12f(int x, int y).....",empty12f(x,y));

    printf("\n");

    TimeFunc("void _pascal empty2(void)....................",empty2());
    TimeFunc("void _pascal empty21(int x)..................",empty21(x));
    TimeFunc("void _pascal empty22(int x, int y)...........",empty22(x,y));
    TimeFunc("void _far _pascal empty2f(void)..............",empty2f());
    TimeFunc("void _far _pascal empty21f(int x)............",empty21f(x));
    TimeFunc("void _far _pascal empty22f(int x, int y).....",empty22f(x,y));

    printf("\n");

    TimeFunc("void _fastcall empty3(void)..................",empty3());
    TimeFunc("void _fastcall empty31(int x)................",empty31(x));
    TimeFunc("void _fastcall _empty32(int x, int y)........",empty32(x,y));
    TimeFunc("void _far _fastcall empty3f(void)............",empty3f());
    TimeFunc("void _far _fastcall empty31f(int x)..........",empty31f(x));
    TimeFunc("void _far _fastcall empty32f(int x, int y)...",empty32f(x,y));

    }
