/*******************************************************************
* Customizing the graphics mouse cursor: code from Figure 4I   	*
*******************************************************************/
#include <conio.h>  /* kbhit(), getch()     */
#include <dos.h>    /* int86(), union REGS  */
#include <stdio.h>  /* puts()               */
#include <stdlib.h> /* exit(), EXIT_FAILURE */
#include <graph.h>

void main(void)
    {
    union REGS regs;
	unsigned int bullseye[]=
	    {
    	/* Screen Mask */
    	0x0000, 0x0000, 0x0000, 0x0000,
    	0x0000, 0x0000, 0x03c0, 0x03c0,
    	0x0000, 0x0000, 0x0000, 0x0000,
    	0x0000, 0x0000, 0xffff, 0xffff,
    	/* Cursor Mask */
    	0xaaaa, 0xaaaa, 0x9556, 0x9556,
    	0x9ff6, 0x9ff6, 0x9ff6, 0x9ff6,
    	0x9ff6, 0x9ff6, 0x9556, 0x9556,
    	0xaaaa, 0xaaaa, 0x0000, 0x0000
    	};
	char fred[100];

	_setvideomode(_MRES4COLOR);
    _selectpalette(0);

    /* Initialize the mouse */
    regs.x.ax = 0x00;
    int86(0x33, &regs, &regs);
    if (!regs.x.ax)
        {
        puts("ERROR-can't initialize mouse");
        exit(EXIT_FAILURE);
        }

    /* Show the mouse */
    regs.x.ax = 0x01;
    int86(0x33, &regs, &regs);

    /* Wait for the user to quit */
	_setcolor(0); _rectangle(_GFILLINTERIOR,10,10,20,20);
	_setcolor(1); _rectangle(_GFILLINTERIOR,20,20,30,30);
	_setcolor(2); _rectangle(_GFILLINTERIOR,30,30,40,40);
	_setcolor(3); _rectangle(_GFILLINTERIOR,40,40,50,50);
    puts("You can now see the mouse");
    puts("Press RETURN key to quit");

	/* Set the shape of the mouse */
	regs.x.ax = 9;
	regs.x.bx = 7;
	regs.x.cx = 7;
	regs.x.dx = (int) bullseye;
	int86(0x33,&regs,&regs);

	/* Wait for a carriage return */
	gets(fred);
	
	/* Hide the mouse */
    regs.x.ax = 0x02;
    int86(0x33, &regs, &regs);

	_setvideomode(_DEFAULTMODE);
    }
