/* timer.c - use BIOS time-of-day interrupt */
static long stime ;		       /* time-of-day from last call*/

int jztimer()				 /* count elapsed time since */
 {				       /* last call (in ticks) */
    struct REGS sreg , dreg ;
    long etime , delta ;

    sreg.x.ax = 0 ;		     /* operation = get time count */
    int86(0x1a,&sreg,&dreg);	    /* do software interrupt */
				       /* assemble 32-bit TOD value */
    etime = ( ((long) dreg.x.cx) << 16 ) + dreg.x.dx;
    delta = etime - stime ;
    if( (dreg.x.ax & 0xff) != 0)       /* new day since last call? */
	delta = delta + 0x01800B0L ;   /* yes-add 1 day in ticks*/
    stime = etime ;		       /* save TOD for next call */
    return( (int) (delta / 18 )) ;	      /* return as an integer */
 }
