/* xgj.h                    freeware                   xhunga@tiscali.fr  */


/* ------------------------------------- FUNCTION --------------------------  */
/* Do    : On a fraction.                                                     */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :  printf("%.0f/%.0f,",x.numer,x.denom);                             */
/* -------------------------------------------------------------------------- */
fraction gfpivotF(
pmatrix  m,
int      rowpivot,
int      colpivot,
int      colp,
int      rown_mns
)
{
fraction f;

fraction fn;
fraction fn_mns;

fraction fp;
fraction fpivot;

  fpivot.numer =  (*(m->pblock+rowpivot  *m->cols+colpivot*TWOCOL  ));
  fpivot.denom =  (*(m->pblock+rowpivot  *m->cols+colpivot*TWOCOL+1));

      fp.numer =  (*(m->pblock+rowpivot  *m->cols+colp*TWOCOL  ));
      fp.denom =  (*(m->pblock+rowpivot  *m->cols+colp*TWOCOL+1));

   fn_mns.numer = -(*(m->pblock+rown_mns *m->cols+colpivot*TWOCOL  ));
   fn_mns.denom =  (*(m->pblock+rown_mns *m->cols+colpivot*TWOCOL+1));

      fn.numer =  (*(m->pblock+rown_mns  *m->cols+colp*TWOCOL  ));
      fn.denom =  (*(m->pblock+rown_mns  *m->cols+colp*TWOCOL+1));

  if(fn_mns.numer)
     {
      f = addF( multF(fpivot,fn), multF(fp,fn_mns));
     }
  else
     {
      f.numer =  (*(m->pblock+rown_mns  *m->cols+colp*TWOCOL  ));
      f.denom =  (*(m->pblock+rown_mns  *m->cols+colp*TWOCOL+1));
     }

  miniF(f);

/*
printf("\n\nfn_mns   %6.0f/%.0f fn       %.0f/%.0f\n",
        fn_mns.numer, fn_mns.denom,
        fn.numer,     fn.denom);
printf("fpivot   %6.0f/%.0f fp       %.0f/%.0f\n",
        fpivot.numer, fpivot.denom,
            fp.numer,     fp.denom);

printf("\n\n(fpivot*fn) + (fp*fn_mns) = f = %.0f/%.0f\n\n",
        f.numer,      f.denom);
printf("\n\n(%.0f/%.0f)*(%.0f/%.0f) + (%.0f/%.0f)*(%.0f/%.0f);  \n\n",
         fpivot.numer, fpivot.denom,
             fn.numer,     fn.denom,
             fp.numer,     fp.denom,
         fn_mns.numer, fn_mns.denom);


getchar();
        printmF3(m);
*/
 return(f);
}




/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :  On a row.                                                         */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void grpivotF(
pmatrix  m,
int      rowpivot,
int      colpivot,
int      rown_mns
)
{
     int colp;
fraction f;

    if((*(m->pblock+rowpivot  *m->cols+colpivot*TWOCOL)))
     {
      for(colp = (m->cols/2)-1 ; colp > -1 ; colp--)
        {
         f = gfpivotF(m, rowpivot, colpivot, colp, rown_mns);

         (*(m->pblock+rown_mns  *m->cols+colp*TWOCOL  )) = f.numer;
         (*(m->pblock+rown_mns  *m->cols+colp*TWOCOL+1)) = f.denom;
        }
      }

      frowminiF(m,rown_mns);
      growminiF(m,rown_mns);
}


/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
int gcpivotnt0F(
pmatrix mA,
int rowpivot,
int colpivot)
{
int rowunderp;
int coeff0 = 1;

  if(!(*(mA->pblock+rowpivot *mA->cols+colpivot*TWOCOL)))
  {
      coeff0 = 0;
   rowunderp = rowpivot + 1;
   do
   {
    if(*(mA->pblock+rowunderp *mA->cols+colpivot*TWOCOL))
    {
     swaprowF(mA,rowpivot,rowunderp);
     rowunderp = mA->rows;
     coeff0 = 1;
    }
    rowunderp++;
   }
   while(rowunderp < mA->rows);
  }

return(coeff0);
}

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :  On a column.                                                      */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void gcpivotF(
pmatrix  m,
int      rowpivot,
int      colpivot
)
{
int      rown_mns;

     gcpivotnt0F(m,rowpivot,colpivot);


     for(rown_mns = rowpivot+1; rown_mns < (m->rows); rown_mns++)
        {
          while( !(*(m->pblock+rowpivot  *m->cols+colpivot*TWOCOL)) &&
                  (colpivot < m->cols/2)
               )
               {
                colpivot++;
               };

         grpivotF(m, rowpivot, colpivot,rown_mns);
        }
}


/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :  .                                                                 */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void gdpivotF(
pmatrix  m
)
{
int      rowpivot;

     for(rowpivot = 0; rowpivot < (m->rows)-1  ;rowpivot++)
     {

      gcpivotF(m, rowpivot,rowpivot);
     }
}




