/*  finder.c
**
**  Searches for modem, which must be connected
**  to the serial port and tuned on.
*/


#include <stdio.h>
#include <stdlib.h>
#include <malloc.h>
#include <dos.h>
#include <string.h>
#include <conio.h>

#include "pcl4c.h"

#define FirstCOM COM1
#define LastCOM  COM8

#define FALSE 0
#define TRUE !FALSE
#define QUOTE 0x22

/*** Global Variables ***/

static char RxBuffer[256+16];
static char TxBuffer[256+16];
static char Expect[] = "OK";     /* expect OK */
static int  Next = 0;            /* index into Expect[] */

/*** main ***/

void main(int argc, char *argv[])
{char c;
 int  i, rc;
 char far *Ptr;
 int  Port;
 int  RxSeg;
 int  TxSeg;
 int  Code;
 long TimeMark;
 if(argc!=1)
   {printf("Usage: FINDER\n");
    exit(1);
   }
 /* create 256 byte receive buffer */
 Ptr = (char far *)RxBuffer;
 RxSeg = FP_SEG(Ptr) + ((FP_OFF(Ptr)+15)>>4);
 /* create 256 byte transmit buffer */
 Ptr = (char far *)TxBuffer;
 TxSeg = FP_SEG(Ptr) + ((FP_OFF(Ptr)+15)>>4);

 printf("\n*** Searching COM%d to COM%d for connected modem.\n",
   1+FirstCOM, 1+LastCOM);
 /* enter search loop */
 for(Port=FirstCOM;Port<=LastCOM;Port++)
   {if(SioBrkKey())
      {/* restore COM port status & exit */
       printf("BREAK\n");
       SioDone(Port);
       exit(2);
      }
    /* setup buffers */
    SioRxBuf(Port,RxSeg,Size256);
    SioTxBuf(Port,TxSeg,Size256);
    /* set port parmameters */
    SioParms(Port,NoParity,OneStopBit,WordLength8);

    /* reset the port */
    Code = SioReset(Port,Baud2400);
    if(Code<0) continue;
    /* found UART. set DTR and RTS */
    SioDTR(Port,'S');
    SioRTS(Port,'S');
    /* modem should set DSR */
    SioPutc(Port,'\r');
    if(SioDSR(Port)==0)
      {/* modem must set DSR */
       printf("COM%d: DSR is not set (DSR=0)\n",1+Port);
       continue;
      }
    printf("COM%d: DSR is set, transmitting %cAT%c...\n",1+Port,QUOTE,QUOTE);
    /* send AT */
    SioPutc(Port,'\r');
    SioDelay(5);
    SioPutc(Port,'A');
    SioDelay(5);
    SioPutc(Port,'T');
    SioDelay(5);
    SioPutc(Port,'\r');
    /* expect OK back */
    Next = 0;
    TimeMark = SioTimer() + 60;
    /*printf("\n[%lx:%lx]\n", SioTimer(), TimeMark);*/
    while(SioTimer() < TimeMark)
      {/* any incoming over serial port ? */
       i = SioGetc(Port,10);
       if(i>-1)
         {/* got character */
          putch((char)i);
          if((char)i==Expect[Next])
            {Next++;
             if(Next==2)
               {printf("\nModem found on COM%d\n",1+Port);
                SioDone(Port);
                exit(0);
               }
            }
         }
      } /* end while */
    /* no modem on this port */
    SioDone(Port);
    printf("No response.\n");
   } /* end-for */
} /* end main */

