/* session.c */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <ctype.h>
#include "pcl4c.h"
#include "session.h"
#include "modem_io.h"

#define FALSE    0
#define TRUE     !FALSE
#define CR       13
#define LF       10
#define ONE_SEC  18

static char UserName[40];      /* caller's user name */
static char PassName[40];      /* caller's password */
static char WorkBuf[80];       /* work buffer */

/*** send string to both display and serial port ***/

void PutString(int Port,char *String)
{int i;
 int Len;
 char c;
 Len = strlen(String);
 for(i=0;i<Len;i++)
   {c = String[i];
    if(c=='!')
      {putch(CR);
       SioPutc(Port,CR);
       c = LF;
      }
    putch(c);
    SioPutc(Port,c);
   }
}

/*** get string from serial port, echoing if requested ***/

void GetString(int Port,char *Buffer,int BufSize,int Echo)
{int i;
 int Len = 0;
 while(1)
   {i = SioGetc(Port,0);
    if(i>=0)
      {if(Echo)
         {/* echo character */
          putch((char)i);
          SioPutc(Port,(char)i);
         }
       else
         {/* echo dot */
          putch('.');
          SioPutc(Port,'.');
         }
       if(i==CR) break;
       Buffer[Len++] = (char)i;
       if(Len==BufSize-1) break;
      }
   }
 Buffer[Len] = '\0';
}

/*** process user's session from logon to logoff ***/

int Session(int Port)
{int i;
 int Code;
 /* answer RING */
 printf("<<Answering RING>>\n");
 ModemSendTo(Port,ONE_SEC/5,"!ATA!");
 printf("<<Awaiting CONNECT>>\n");
 Code = ModemWaitFor(Port,60*ONE_SEC,FALSE,"CONNECT");
 if(Code) printf("<<CONNECT is seen>>\n");
 else
   {printf("<<CONNECT is NOT seen>>\n");
    return FALSE;
   }
 /* send CR & then wait for line to clear */
 SioPutc(Port,CR);
 ModemQuiet(Port,3*ONE_SEC);
 PutString(Port,"!HOST program!");
 /* get user name */
 PutString(Port,"Logon: ");
 GetString(Port,UserName,sizeof(UserName),TRUE);
 PutString(Port,"!");
 ModemQuiet(Port,ONE_SEC/4);
 /* get password */
 PutString(Port,"Password: ");
 GetString(Port,PassName,sizeof(PassName),FALSE);
 PutString(Port,"!");
 /* OK */
 while(1)
   {ModemQuiet(Port,ONE_SEC/5);
    PutString(Port,"Q)uit B)ulletins M)essages F)iles : ");
    /* get response character */
    while(1)
      {/* check carrier */
       if(SioDCD(Port)==0)
         {printf("<<No carrier>>");
          return FALSE;
         }
       /* get next incoming */
       i = SioGetc(Port,1);
       if(i!=-1) break;
      }
    switch( toupper((char)i) )
       {case 'Q': /* Exit */
          PutString(Port,"Logging off");
          return TRUE;
        case 'B': /* Bulletins */
        case 'M': /* Messages */
        case 'F': /* Files */
          sprintf(WorkBuf,"Hello '%s'.!",UserName);
          PutString(Port,WorkBuf);
       } /* end switch */
   } /* end while */
} /* end Session */
