/***********************************************************/
/* File Id.                  Pckern.C                      */
/* Author.                   Stan Milam.                   */
/* Date Written.             01/29/89.                     */
/* Date Modified.            05/26/89.                     */
/*                                                         */
/*           (c) Copyright 1989-90 by Stan Milam           */
/*                                                         */
/* Modification Notes:  Rewrote initialization logic.  Add-*/
/* ed global variables, _monitor, _adaptor, _video_ram.    */
/* Added function to check video state & return max row &  */
/* columns.                                                */
/*                                                         */
/* Comments:  This file will be the kernal of the Pcscrn   */
/* library functions.  It will contain code to deal with   */
/* the video environment.  Most important is the start up  */
/* initialization code.  This code will determine the      */
/* video adaptors on board.                                */
/***********************************************************/

#ifdef MSC
#  include <conio.h>
#  define MK_FP(seg,off) ((void far *)(((long)(seg)<<16) | (off)))
#  define outportb outp
#  define inportb inp
#endif

#include <dos.h>
#include <stdlib.h>

#define TRUE  1
#define FALSE 0

#define COLORSEG  0XB800
#define MONOSEG   0XB000
#define MONO      0
#define COLOR     1

#define MDA      1
#define CGA      2
#define EGA      3
#define VGA      4

char PCWRKSTR[151];

void vgetmode(int *cols, int *mode, int *apage);
void _pcw_exit(void);

/* Global Variables */

int      CheckSnow;                    /* Do we need to check for snow? */
int      Vbump;                        /* Vertical increment in quick writes */
int      _monitor;                     /* The kind of monitor we are using */
int      _adaptor;                     /* The video adaptor we are using */
int      _video_ram;                   /* How much video memory */

/*  Some pointers to low memory where vital info is to be found */

static char far *ega_byte;
static int  far *regen_len;
static char far *ega_rows;
static char *_pcw_copyright;

/*  Values stored in this file to be used throughout the library */

static unsigned ScrnSeg;
static int      VideoPage;             /* Active Video page for library */
static int      SavedMode;             /* Video Mode when called */
static char     Init_Called= 0;        /* Was initialization done? */

/***********************************************************/
/* Functions in this file:                                 */
/* pcwinit() - Initializes the library.                    */
/* getpage() - Returns video page library function use.    */
/* setpage() - Sets library video page                     */
/* switchpage() - Uses BIOS to switch active video page    */
/* getscrnseg() - Returns active screen segment.           */
/* getpagesize()- Returns current size of video page       */
/***********************************************************/


/***********************************************************/
/*                           PCWINIT                       */
/*                                                         */
/* This function must be called to use any of the quick    */
/* screen writing functions or the window functions. This  */
/* is because we have to determine some basic info about   */
/* the video environment.                                  */
/* If called with a zero value before any other PCW call   */
/* the automatic exit will not be established.  Automatic  */
/* exit is the default.                                    */
/***********************************************************/

void pcwinit(int action) {

     union REGS regs;                       /* For video interrupts */

     Init_Called    = (char) TRUE;
     ega_byte       = (char far *) MK_FP(0x0000, 0x0487);
     regen_len      = (int  far *) MK_FP(0x0000, 0x044c);
     ega_rows       = (char far *) MK_FP(0x0000, 0x0484);
     _pcw_copyright = "PC Windows (c) Copyright 1989-90 by Stan Milam";

     regs.x.ax = 0x1a00;                         /* Check for VGA */
     int86(0x10, &regs, &regs);                  /* Invoke BIOS */
     if (regs.h.al == 0x1a) {                    /* If VGA BIOS supported */
        _adaptor  = VGA;                         /* Tell the world about it */
        CheckSnow = FALSE;                       /* Don't need this */
        if (regs.h.bl >= 7) {                    /* Determine the monitor */
           switch(regs.h.bl) {
              case  7 :
              case 11 :
                   _monitor = MONO;
                   ScrnSeg  = MONOSEG;
                   break;
              case  8 :
              case 10 :
              case 12 :
                   _monitor = COLOR;
                   ScrnSeg  = COLORSEG;
                   break;
           }
        }
        regs.x.ax = 0x1200;                      /* Get amount of video ram */
        regs.h.bl = 0x10;
        int86(0x10,&regs,&regs);                 /* Ask the BIOS */
        switch(regs.h.bl) {
          case 0 : _video_ram =  64; break;
          case 1 : _video_ram = 128; break;
          case 2 : _video_ram = 192; break;
          case 3 : _video_ram = 256; break;
        }
     }

     if (!_adaptor) {                            /* If no VGA */
        regs.x.ax = 0x1200;                      /* Check for EGA */
        regs.h.bl = 0x10;
        int86(0x10,&regs,&regs);                 /* EGA BIOS supported? */
        if (regs.h.bl == 0x10) {                 /* Not EGA or VGA */
           int86(0x11,&regs,&regs);              /* Get BIOS Equip List */
           if ((regs.x.ax & 0x0030) == 0x0030) { /* Check for MONO */
              ScrnSeg   = MONOSEG;
              _adaptor  = MDA;
              _monitor  = MONO;
              _video_ram= 4;
              CheckSnow = FALSE;
           }
           else {                                /* Must be CGA */
              ScrnSeg   = COLORSEG;
              _adaptor  = CGA;
              _monitor  = COLOR;
              CheckSnow = TRUE;
              _video_ram= 16;
           }
        }
        else {                                   /* Must be an EGA */
           CheckSnow = FALSE;
           _adaptor  = EGA;
           switch(regs.h.bh) {                   /* Which Monitor? */
             case 0 :                            /* Color */
                ScrnSeg = COLORSEG;
                _monitor= COLOR;
                break;
             case 1 :                            /* Mono */
                ScrnSeg = MONOSEG;
                _monitor= MONO;
                break;
           }
           switch(regs.h.bl) {                   /* How Much memory? */
             case 0 : _video_ram =  64; break;
             case 1 : _video_ram = 128; break;
             case 2 : _video_ram = 192; break;
             case 3 : _video_ram = 256; break;
           }
        }
     }
     if (_adaptor > CGA) {                        /* Set alternate print */
        regs.x.ax = 0x1200;                       /* screen to handle screen*/
        regs.x.bx = 0x0020;                       /* sizes > 25 lines */
        int86(0x10,&regs,&regs);
     }
     if (action) atexit(_pcw_exit);            /* Set up automatic exit */
     vgetmode(&Vbump, &SavedMode, &VideoPage); /* Get initial info */
     Vbump *= 2;                               /* Establish Vertical */
}

/***********************************************************/
/*                                                         */
/* Now some miscellanious functions that will be called    */
/* from the library functions to retrieve some of the      */
/* values stored here in this file.                        */
/*                                                         */
/***********************************************************/

/***********************************************************/
/*                      Chk_Video_State                    */
/*                                                         */
/* Determine if we are in a valid text mode to do screen   */
/* writes.  Also return the number of colums & rows.       */
/***********************************************************/


int chk_video_state(int *max_rows, int *max_cols) {

   static int cols, mode, ap, rc;

   if (!Init_Called) pcwinit(1);
   vgetmode(&cols, &mode, &ap);
   Vbump = cols * 2;
   rc = !((mode > 3 && mode < 7) || mode > 7);
   if (_adaptor < EGA) *max_rows = 25;
   else *max_rows = *ega_rows + 1;
   *max_cols = cols;
   return(rc);
}


/* Get the videopage the library is working in now  */

int getpage(void) {

    return(VideoPage);
}

/* Get the Screen Memory Segment */

unsigned getscrnseg(void) {

   return(ScrnSeg);
}

/* Return the pagesize to whoever wants to know */

int getpagesize(void) {

    return(*regen_len);
}

/* Function to return Init_Called - Used to determine if   */
/* initialization routine was called.  Library function    */
/* will not work if it returns NULL                        */

int ispcwinit(void) {

    return((int) Init_Called);
}

/***********************************************************/
/*                         SetPage                         */
/*                                                         */
/* Set the video page for the library functions to work in.*/
/* First edit to see if the specified page is legal.       */
/* Return NULL if the specified page was illegal.          */
/***********************************************************/

int setpage(int page) {

    int cols, mode, apage;

    if (!ispcwinit()) pcwinit(1);
    if (page < 0 || _adaptor == MDA) return(0); /* No Mono here! */
    vgetmode(&cols, &mode, &apage);         /* Get video Mode */
    if (mode > 3) return(0);                /* Not a valid text mode */
    if (mode < 2) {                         /* 40 column text mode */
       if (_adaptor > CGA) {                /* When EGA we have... */
          if (page > 15) return(0);         /* 15 pages-no more! */
          else VideoPage = page;            /* Set the page */
       }
       else {                               /* Else we are CGA */
          if (page > 7) return(0);          /* And we have 8 pages */
          else VideoPage = page;
       }
    }
    else {                                  /* Okay-80 column text mode */
       if (_adaptor > CGA) {                /* And when its an EGA */
          if (page > 7) return(0);          /* We have 8 pages */
          else VideoPage = page;
       }
       else {                               /* And when its CGA */
          if (page > 3) return(0);          /* 4 pages.         */
          else VideoPage = page;
       }
    }
    return(1);
}

/***********************************************************/
/*                         SwitchPage                      */
/*                                                         */
/* Use BIOS to switch the active display to another video  */
/* page.  First edit to see if we can.                     */
/***********************************************************/

void switchpage(int page) {

   union REGS regs;
   int cols, mode, apage;

   if (!ispcwinit()) pcwinit(1);
   if (page < 0 || _adaptor == MDA) return; /* No Mono here! */
   vgetmode(&cols, &mode, &apage);          /* Get the video mode */
   if (mode > 3) return;                    /* Not valid text mode */
   if (mode < 2) {                          /* 40 Column text mode */
      if (_adaptor > CGA) {                 /* If we are EGA we have... */
         if (page > 15) return;             /* 15 page in 40 col text mode */
      }
      else                                  /* Otherwise...40 col CGA */
         if (page > 7) return;              /* We have 8 pages */
   }
   else {                                   /* Otherwise...80 col text */
      if (_adaptor > CGA) {                 /* If we are EGA... */
         if (page > 7) return;              /* We have 8 pages to play with */
      }
      else                                  /* Otherwise...we are CGA and */
         if (page > 3) return;              /* We have 4 */
   }
   regs.h.ah = 5;                           /* Call BIOS to switch */
   regs.h.al = (char) page;                 /* To specified page */
   int86(0x10, &regs, &regs);               /* BIOS Video */
}
