/**********************************************************/
/* File Id.                  Pmenu.C                      */
/* Author.                   Stan Milam.                  */
/* Date Written.             03/10/89.                    */
/* Last Modified.                                         */
/*                                                        */
/*          (c) Copyright 1989, 1990 by Stan Milam        */
/*                                                        */
/* Comments:  This file contains the functions to make &  */
/* accept input from pop-up menus.                        */
/**********************************************************/

#include <stdio.h>
#include <ctype.h>
#include <conio.h>
#include "pcw.i"
#include "pcwproto.h"
#include "menu.h"
#include "keys.h"

static void chg_bar_pos(PMNUTYPE *menu, int new_pos);

/**********************************************************/
/*                         MakePmenu                      */
/*                                                        */
/* This function will take as an argument a pointer to a  */
/* variable of PMNUTYPE and use the information passed */
/* to build a pop-up menu. It will call wframe() to frame */
/* a window for the menu and return a normal window win-  */
/* dow pointer.                                           */
/**********************************************************/

WNDPTR *makepmenu(PMNUTYPE *menu) {

    int    row, cols;
    PMNUFLDS *temp;
    MENU_WND    *pwnd;

    pwnd = &menu->pwnd;
    setborder(pwnd->btype);                      /* Set border */
    titlecolor(pwnd->tfclr, pwnd->tbclr);        /* Menu title color */
    bordercolor(pwnd->bfclr, pwnd->bbclr);       /* Border color */

    pwnd->wnd = wframe(pwnd->urow,pwnd->ucol,    /* Frame the window */
                       pwnd->lrow,pwnd->lcol,
                       pwnd->fcolor,pwnd->bcolor);
    if (pwnd->wnd == (WNDPTR *) NULL)            /* Check for good */
       return(NULL);                             /* Return */

    pwnd->urow = pwnd->wnd->urow;                /* Adjust menu */
    pwnd->ucol = pwnd->wnd->ucol;
    pwnd->lrow = pwnd->wnd->lrow;
    pwnd->lcol = pwnd->wnd->lcol;

    wtitle(pwnd->wnd,pwnd->tvloc,pwnd->thloc,pwnd->title);
    temp = menu->plist;

    /* Write the menu items */

    row = 1;
    while (*temp->item != (char) NULL && temp->item != NULL) {
        wputs(pwnd->wnd, row, CENTER, temp->item);
        temp++;
        row++;
    }

    cols = (pwnd->lcol - pwnd->ucol) - 1;
    w_chg_attr(pwnd->wnd,1+menu->bar_pos,1,pwnd->cfclr,pwnd->cbclr,cols);
    return(pwnd->wnd);
}

/**********************************************************/
/*                        PmenuInput                      */
/*                                                        */
/* This function will take as an argument a pointer to    */
/* type PMNUTYPE and determine if a menu selection was */
/* made from the keyboard or from the mouse.  The up and  */
/* down arrow keys will move the selection bar thru the   */
/* menu selections.  Pressing the Enter Key will make the */
/* selection.  Pressing the Esc key will return to caller */
/* with the Esc character code.  Using the mouse: Left key*/
/* will select what was pointed to.  Right Key will be the*/
/* same as escape.                                        */
/**********************************************************/

int pmenuinput(PMNUTYPE *menu) {

   int  row, col, bstatus;
   int  select;
   int  select_count = 0;
   int  ch;
   PMNUFLDS *temp;
   MENU_WND *pwnd;

   temp = menu->plist;
   pwnd = &menu->pwnd;
   for (select=0;temp[select].select_key!='\0';select++);
   select_count = select - 1;

   if (mpresent) hide_mouse();
   re_order(pwnd->wnd, NORMAL);
   if (mpresent) show_mouse();
   for (;;) {                                    /* Loop forever */
       ch = keyin();
       switch(ch) {
          case ENTER :
          case BOTH_MOUSE_KEY :
             return(temp[menu->bar_pos].select_key);
          case ESC :
             return(ESC);
          case RITEARROW :
             return ( RITEARROW );
          case LEFTARROW :
             return ( LEFTARROW );
          case RITE_MOUSE_KEY :
             return ( ESC );
          case LEFT_MOUSE_KEY :
             get_mpos(&row,&col,&bstatus);
             if ((row >= pwnd->wnd->urow+1 && row <= pwnd->wnd->lrow-1) &&
                 (col >= pwnd->wnd->ucol+1 && col <= pwnd->wnd->lcol-1)) {
                  select = (row - pwnd->wnd->urow) - 1;
                  if (select > select_count) break;
                  if (select == menu->bar_pos)
                     return(temp[select].select_key);
                  hide_mouse();
                  chg_bar_pos(menu,select);
                  show_mouse();
                  return(temp[select].select_key);
             }
             break;
          case DOWNARROW :
          case TAB:
          case PGDN:
             select = menu->bar_pos + 1;
             if (select > select_count) select = 0;
             if (mpresent) hide_mouse();
             chg_bar_pos(menu,select);
             if (mpresent) show_mouse();
             break;
          case SHFTTAB :
          case UPARROW :
          case PGUP:
             select = menu->bar_pos - 1;
             if (select < 0) select = select_count;
             if (mpresent) hide_mouse();
             chg_bar_pos(menu,select);
             if (mpresent) show_mouse();
             break;
           default :
              if ( isalpha( ch ) ) ch = toupper(ch);
              for (select = 0;select <= select_count; select++) {
                  if (ch == toupper(menu->plist[select].select_key)) {
                     if (select == menu->bar_pos)
                        return(temp[select].select_key);
                     if (mpresent) hide_mouse();
                     chg_bar_pos(menu,select);
                     if (mpresent) show_mouse();
                     return(temp[select].select_key);
                  }
              }
        }
   }
#ifndef __TURBOC__
   return ( 0 );
#endif
}

/**********************************************************/
/*                       chg_bar_pos()                    */
/*                                                        */
/* Used to change the bar position on the pop-up menus    */
/**********************************************************/

static void chg_bar_pos(PMNUTYPE *menu, int new_pos) {

   int      cols;
   MENU_WND *pwnd;

   pwnd = &menu->pwnd;
   cols = (pwnd->wnd->lcol - pwnd->wnd->ucol) - 1;
   w_chg_attr(pwnd->wnd,1+menu->bar_pos, 1, pwnd->fcolor, pwnd->bcolor, cols);
   w_chg_attr(pwnd->wnd,1+new_pos, 1, pwnd->cfclr, pwnd->cbclr, cols);
   menu->bar_pos = new_pos;
}

