/************************************************************/
/* File Id.                  Qputs.C                        */
/* Author.                   Stan Milam.                    */
/* Date Written.             11/06/88.                      */
/* Date Last Modified.       01/29/89.                      */
/* Changed name to qputs and added function qvputs to file  */
/*                                                          */
/*           (c) Copyright 1989-90 by Stan Milam            */
/*                                                          */
/* Comments:  This routine will write a character string to */
/* the video screens memory.  Calls an Assembly routine,    */
/* Tputs, to do the actual screen writing.                  */
/************************************************************/

#include <string.h>
#include <dos.h>
#include "pcw.i"
#include "pcwproto.h"

int qputs(int row, int col, int fcolor, int bcolor, char *s) {

   int far *scrnptr;
   int page, pagesize, attr;
   int mx_rows, mx_cols;
   unsigned offset, scrnseg;

   if (!chk_video_state(&mx_rows,&mx_cols)) return(0);

   if (col == CENTER)
      col = ((mx_cols / 2) - (strlen(s) / 2));

   scrnseg = getscrnseg();
   page    = getpage();
   pagesize= getpagesize();

   attr    = MK_ATTR(fcolor,bcolor);
   offset  = MK_SCRNOFF(row,col);
   scrnptr = (int far *) MK_FP(scrnseg,offset);
   Tputs(scrnptr, (char far *) s, attr); return(1);
}

/************************************************************/
/*                            Qvputs                        */
/*                                                          */
/* This functions is basically the same as qputs except that*/
/* it writes to the screen vertically.  Calls assembler     */
/* routine Tvputs.                                          */
/*                                                          */
/************************************************************/

int qvputs(int row, int col, int fcolor, int bcolor, char *s) {

   int far *scrnptr;
   int attr, page, pagesize;
   int mx_rows, mx_cols;
   unsigned offset, scrnseg;

   if (!chk_video_state(&mx_rows,&mx_cols)) return(0);
   if (col == CENTER) col = (int) mx_cols / 2;

   scrnseg = getscrnseg();
   page    = getpage();
   pagesize= getpagesize();
   attr    = MK_ATTR(fcolor,bcolor);
   offset  = MK_SCRNOFF(row,col);
   scrnptr = (int far *) MK_FP(scrnseg,offset);
   Tvputs(scrnptr, (char far *) s, attr);
   return(1);
}
