/****************************************************************************
*
*						  Protected Mode Library
*
*                   Copyright (C) 1994 SciTech Software.
*							All rights reserved.
*
* Filename:		$RCSfile: altbrk.c $
* Version:		$Revision: 1.1 $
*
* Language:		ANSI C
* Environment:	any
*
* Description:  Test program to check the ability to install a C based
*				control C/break interrupt handler. Note that this
*				alternate version does not work with all extenders.
*
*				Functions tested:	PM_installAltBreakHandler()
*									PM_restoreBreakHandler()
*
* $Id: altbrk.c 1.1 1995/09/16 10:40:13 kjb release $
*
****************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <conio.h>
#include "pmpro.h"

volatile int breakHit = false;
volatile int ctrlCHit = false;

void PMAPI breakHandler(uint bHit)
{
	if (bHit)
		breakHit = true;
	else
		ctrlCHit = true;
}

int main(void)
{
	printf("Program running in ");
	switch (PM_getModeType()) {
		case PM_realMode:
			printf("real mode.\n\n");
			break;
		case PM_286:
			printf("16 bit protected mode.\n\n");
			break;
		case PM_386:
			printf("32 bit protected mode.\n\n");
			break;
		}

	PM_installAltBreakHandler(breakHandler);
	printf("Control C/Break interrupt handler installed\n");
	while (1) {
		if (ctrlCHit) {
			printf("Code termimated with Ctrl-C.\n");
			break;
			}
		if (breakHit) {
			printf("Code termimated with Ctrl-Break.\n");
			break;
			}
		if (kbhit() && getch() == 0x1B) {
			printf("No break code detected!\n");
			break;
			}
		printf("Hit Ctrl-C or Ctrl-Break to exit!\n");
		}

	PM_restoreBreakHandler();
	return 0;
}
