; 80286 ASSEMBLER

		PAGE		42, 132
		TITLE		prf.asm
		.286c


VERSION	EQU 0001
REVISION EQU 0000
MODIFICATION EQU 0000	
PRINT EQU 0000

;
; 
; File:
;		prf.asm	- PROFILING TOOL
;

;*******************************************************************************
;*                             INCLUDE FILES                                   *
;*******************************************************************************
		INCLUDE	prf.h

;*******************************************************************************
;*                               CONSTANTS                                     *
;*******************************************************************************
PRFInterrupt    equ	88H
PROFILE_DWORDS  equ	8192 

;*******************************************************************************
;*                             PUBLIC SYMBOLS                                  *
;*******************************************************************************

		PUBLIC  FirstByte		;used for TSR code
		PUBLIC  LastByte		;           "
		PUBLIC  TimerISR		;timer interrupt routine
		PUBLIC	_PRF_SWEntry		;prf software entry point
			     
;*******************************************************************************
;*                                                                             *
;*                                                                             *
;*                                                                             *
;*                        DATA    STRUCTURES                                   *
;*                                                                             *
;*                                                                             *
;*                                                                             *
;*******************************************************************************
	
;*******************************************************************************
;*                             SEGMENT STUFF                                   *
;*******************************************************************************

; Code and data segment (SAME)
CODE		SEGMENT PARA PUBLIC
		assume cs:CODE

;*******************************************************************************
;*                                                                             *
;*       ALL DATA BETWEEN  FirstByte:  AND  LastByte: REMAIN RESIDENT          *
;*                                                                             *
;*******************************************************************************
FirstByte:			  

;*******************************************************************************
;*                  PRF EXTERNAL FUNCTION CALL JUMP TABLE                      *
;*******************************************************************************
; jump table for prf Software functions
JumpTable	dw	OFFSET	PRF_START
		dw	OFFSET	PRF_STOP

;*******************************************************************************
;*                        PRF TIMER INTERRUPT VARIABLES                        *
;*******************************************************************************

TimerChain	dd	?
ProfileSegment	dw	0
		even
		dw	0
ProfileData	dd	PROFILE_DWORDS dup (0)

;*******************************************************************************
;*                                                                             *
;*                        PRF RESIDENT IDENTIFICATION			       *
;*             MUST BE PLACED JUST BEFORE PRF SOFTWARE ENTRY POINT             *
;*                                                                             *
;*******************************************************************************
		db	'P','R','F'
		dw	VERSION,REVISION,MODIFICATION,PRINT

;*******************************************************************************
;*                                                                             *
;*                       PRF FUNCTION CALL ENTRY POINT                         *
;*  ENTRY:               SS:BP -> PARAMETERS                                   *
;*  EXIT:                DX:AX == RETURN PARAMETER                             *
;*                                                                             *
;*******************************************************************************
_PRF_SWEntry:		
		sti
		push	ds			;save registers
		push	si
		push	di

; SS:BP --> parameters of call
		mov	ax, cs			;setup DS
		mov	ds, ax
		mov	es, ax
		cld			

; DS is PRF data segment (CS)
		assume	cs:CODE, ds:CODE, es:CODE, ss:nothing
		mov	bx, FunctionCode[bp]	;get function code

		call	JumpTable[bx]		;go to IT

PRF_SWBack:
		pop	di			;restore regs
		pop	si
		pop	ds				     
		iret		

;*******************************************************************************
;*                         PRF_START                                           *
;*******************************************************************************
		   
PRF_START         	proc	near
			mov     cs:ProfileSegment, 0

			mov	ax, cs
			mov	ds, ax

			mov	bx, OFFSET ProfileData
			mov	cx, PROFILE_DWORDS
			

			mov	word ptr [bx-2] , 0
CLEAR_LOOP:		mov	word ptr [bx], 0
			add	bx, 2	     
			mov	word ptr [bx], 0
			add	bx, 2
			loop	CLEAR_LOOP

			mov	ax, S0_CodeSegment[bp]
			mov	cs:ProfileSegment, ax

			ret

		
PRF_START         	endp

;*******************************************************************************
;*                         PRF_DEREGISTER_NAME                                 *
;*******************************************************************************
PRF_STOP            	proc	near

			mov	cs:ProfileSegment, 0
			mov	ax, cs
			mov	dx, ax
			mov	ax, OFFSET ProfileData
			ret

PRF_STOP             	endp
						
;*******************************************************************************
;*                                                                             *
;*                      PRF TIMER INTERRUPT ENTRY POINT                        *
;*                                                                             *
;*******************************************************************************

; decrement timeouts, leave at zero when reaches zero
TimerISR:			
		test	cs: ProfileSegment, -1
		je	TimerExit

		;	   FLAGS
		;	   SEGMENT OF INTERRUPTEE
		; SP --->  OFFSET  OF INTERRUPTEE

		push	bp
		mov	bp, sp

		;	   FLAGS
		;	   SEGMENT OF INTERRUPTEE
		;          OFFSET  OF INTERRUPTEE
		; BP --->  PUSHED BP

		pusha
		push	ds
		push	es

		; debug
		mov	ax, 0b800h
		mov	es, ax

		inc     WORD PTR cs:[ProfileData-2]

		mov	ax, cs:ProfileSegment
		cmp	ax, 4[bp]
		jne	SomeOneElse

Us:		mov	bx, 2[bp]
		shr	bx, 1
		and	bl, 0FCH
		add	word ptr cs:[bx+ProfileData], 1
		adc	word ptr cs:[2+bx+ProfileData], 0
		jnc	IntExit

		dec	word ptr cs:[2+bx+ProfileData]

		jmp	IntExit

SomeOneElse:

IntExit:
		pop	es
		pop	ds
		popa
		pop	bp

TimerExit:	jmp	cs:[TimerChain]					


LastByte:					   

;*******************************************************************************
;*                                                                             *
;*                            _InitPRF   				       *
;* Purpose:                                                                    *
;* Initialises PRF                                                             *
;*                                                                             *
;*******************************************************************************

		PUBLIC	main

main		proc	near
	
		mov	ax, cs
		mov	ds, ax			;Data Seg for PRF

		cld

		mov	dx, OFFSET sPRF_Ok
               	mov	ah, 9			;print string
		int	21h			;MSDOS

; See if PRF Sublayer is already loaded.

		mov	si, PRFInterrupt	;get interrupt number
		shl	si, 1
		shl	si, 1			;make into vector pointer
		xor	ax, ax			;will be segment zero
		mov	es, ax			;use ES
		mov	ax, es:[si]		;check vector is
		or	ax, es:2[si]		;zero (unused)
		mov	dx, OFFSET sPRF_Loaded
		je	PRFNotLoaded

PrintString:	mov	ah, 9			;print string
		int	21h			;MSDOS

		mov	ax, 4c01h
		int	21h			;end process


PRFNotLoaded:	

; Set up the PRF interrupt vector so that programs may call the PRF.

		mov	si, PRFInterrupt
		shl	si, 1
		shl	si, 1
		xor	ax, ax
		mov	es, ax
		mov	es:2[si], cs
		mov	word ptr es:[si], OFFSET _PRF_SWEntry

; Initialise timer interrupt chain
					
		mov	bx, 20h				       
		cli
		mov	ax, es:[bx]	
		mov	word ptr [TimerChain], ax
		mov	ax, OFFSET TimerISR
		mov	word ptr es:[bx], ax

		mov	ax, word ptr es:[bx+2]
		mov	word ptr [TimerChain+2], ax
		mov	ax, cs
		mov	word ptr es:[bx+2], ax
		sti

;
; Terminate and stay resident with minimal (PSP) wastage
;

; Calculate bytes to save

		mov	dx, ( ((OFFSET LastByte) - (OFFSET FirstByte)) + 256 + 16 ) / 16

		mov	ax, 03100h		;KEEP PROCESS, no error
		int	021h			;MSDOS
							   
sPRF_Loaded:	db	'INT88 already used.', 13, 10, '$'
sPRF_Ok:	db	"Profiling Tool            - "
		db	"Version "
		db	VERSION+'0'
		db	'.'
		db	REVISION+'0'
		db	':'
		db	MODIFICATION+'0'
		db	13, 10, '$'

main		endp

CODE		ends
		end	main
	

