/*
 * Decompiled with CFR 0.152.
 */
package de.admadic.calculator.modules.matrx.ui;

import de.admadic.calculator.modules.matrx.MatrxActions;
import de.admadic.calculator.modules.matrx.MatrxCfg;
import de.admadic.calculator.modules.matrx.core.DMatrix;
import de.admadic.calculator.modules.matrx.core.MatrixDimensionException;
import de.admadic.calculator.modules.matrx.core.MatrixOp;
import de.admadic.calculator.modules.matrx.ui.FloatingPointFormatter;
import de.admadic.calculator.modules.matrx.ui.ICfgHandler;
import de.admadic.calculator.modules.matrx.ui.MatrixPanel;
import de.admadic.calculator.modules.matrx.ui.MatrixUiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class BinaryOpPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public JSplitPane a;
    public JSplitPane b;
    public MatrixPanel a;
    public MatrixPanel b;
    public MatrixPanel c;
    public FloatingPointFormatter a;
    public MatrxCfg a;
    public ICfgHandler a;
    public JToolBar a;
    public CalcAddAction a;
    public CalcMulAction a;
    public DMatrix a;
    public DMatrix b;
    public DMatrix c;

    public BinaryOpPanel(FloatingPointFormatter floatingPointFormatter, MatrxCfg matrxCfg, ICfgHandler iCfgHandler) {
        this.a = floatingPointFormatter;
        this.a = matrxCfg;
        this.a = iCfgHandler;
        this.a();
    }

    private void a() {
        this.setLayout(new BorderLayout());
        this.a = new JSplitPane(0);
        this.add((Component)this.a, "Center");
        this.b = new JSplitPane(1);
        this.a = new MatrixPanel("First Input Matrix:", this.a);
        this.b = new MatrixPanel("Second Input Matrix:", this.a);
        this.c = new MatrixPanel("Result Matrix:", this.a);
        this.a.setPreferredSize(new Dimension(100, 100));
        this.b.setPreferredSize(new Dimension(100, 100));
        this.c.setPreferredSize(new Dimension(100, 100));
        this.b.setLeftComponent(this.a);
        this.b.setRightComponent(this.b);
        this.a.setTopComponent(this.b);
        this.a.setBottomComponent(this.c);
        this.a.setDividerLocation(0.5);
        this.b.setDividerLocation(0.5);
        this.a.setResizeWeight(0.5);
        this.b.setResizeWeight(0.5);
        this.a = new JToolBar();
        this.add((Component)this.a, "First");
        this.a.add(new JButton(new CreateNewAction()));
        this.a.add(new JButton(new CreateNewInputAction()));
        this.a.addSeparator();
        this.a.add(new JButton(new CreateNewSecondAction()));
        this.a.add(new JButton(new CreateNewInputSecondAction()));
        this.a.addSeparator();
        this.a = new CalcAddAction();
        this.a.add(new JButton(this.a));
        this.a = new CalcMulAction();
        this.a.add(new JButton(this.a));
        this.b();
    }

    public void setFirstInputMatrix(DMatrix dMatrix) {
        this.a = dMatrix;
        this.a.setMatrix(dMatrix);
        this.b();
        this.a.notifyCfgUpdate();
    }

    public void setSecondInputMatrix(DMatrix dMatrix) {
        this.b = dMatrix;
        this.b.setMatrix(dMatrix);
        this.b();
        this.a.notifyCfgUpdate();
    }

    public void setResultMatrix(DMatrix dMatrix) {
        this.c = dMatrix;
        this.c.setMatrix(dMatrix);
        this.a.notifyCfgUpdate();
    }

    private void b() {
        boolean bl = true;
        if (this.a == null) {
            bl = false;
        }
        if (this.b == null) {
            bl = false;
        }
        this.a.setEnabled(bl);
        this.a.setEnabled(bl);
    }

    public class CalcAddAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CalcAddAction() {
            this.putValue("Name", "Add");
            this.putValue("ShortDescription", "Add Matrices");
            this.putValue("SmallIcon", MatrxActions.loadIcon(this.getClass(), "btn-add.png"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DMatrix dMatrix = new DMatrix(BinaryOpPanel.this.a);
            try {
                MatrixOp.add(dMatrix, BinaryOpPanel.this.b);
            }
            catch (MatrixDimensionException matrixDimensionException) {
                JOptionPane.showMessageDialog(null, "Matrix dimensions must be identical for addition.\n(Error: " + matrixDimensionException.getMessage() + ")", "Matrix dimensions do not match", 0);
                return;
            }
            BinaryOpPanel.this.setResultMatrix(dMatrix);
        }
    }

    public class CalcMulAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CalcMulAction() {
            this.putValue("Name", "Mul");
            this.putValue("ShortDescription", "Multiply Matrices");
            this.putValue("SmallIcon", MatrxActions.loadIcon(this.getClass(), "btn-mul.png"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DMatrix dMatrix = null;
            try {
                dMatrix = MatrixOp.mul(BinaryOpPanel.this.a, BinaryOpPanel.this.b);
            }
            catch (MatrixDimensionException matrixDimensionException) {
                JOptionPane.showMessageDialog(null, "Matrix dimensions must be identical for multiplication.\n(Error: " + matrixDimensionException.getMessage() + ")", "Matrix dimensions do not match", 0);
                return;
            }
            BinaryOpPanel.this.setResultMatrix(dMatrix);
        }
    }

    public class CreateNewInputSecondAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CreateNewInputSecondAction() {
            this.putValue("Name", "New[] 2nd");
            this.putValue("ShortDescription", "Create New 2nd Matrix from Input");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DMatrix dMatrix = MatrixUiUtil.getNewMatrixInput(BinaryOpPanel.this.a);
            if (dMatrix == null) {
                return;
            }
            BinaryOpPanel.this.setSecondInputMatrix(dMatrix);
        }
    }

    public class CreateNewSecondAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CreateNewSecondAction() {
            this.putValue("Name", "New 2nd");
            this.putValue("ShortDescription", "Create New 2nd Matrix");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DMatrix dMatrix = MatrixUiUtil.getNewMatrix();
            if (dMatrix == null) {
                return;
            }
            BinaryOpPanel.this.setSecondInputMatrix(dMatrix);
        }
    }

    public class CreateNewInputAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CreateNewInputAction() {
            this.putValue("Name", "New[] 1st");
            this.putValue("ShortDescription", "Create New 1st Matrix from Input");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DMatrix dMatrix = MatrixUiUtil.getNewMatrixInput(BinaryOpPanel.this.a);
            if (dMatrix == null) {
                return;
            }
            BinaryOpPanel.this.setFirstInputMatrix(dMatrix);
        }
    }

    public class CreateNewAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        public CreateNewAction() {
            this.putValue("Name", "New 1st");
            this.putValue("ShortDescription", "Create New 1st Matrix");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            DMatrix dMatrix = MatrixUiUtil.getNewMatrix();
            if (dMatrix == null) {
                return;
            }
            BinaryOpPanel.this.setFirstInputMatrix(dMatrix);
        }
    }
}

